/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.emmylua.lua.psi;

import com.immomo.emmylua.lua.psi.LuaTypes;
import com.immomo.emmylua.lua.psi.parser.LuaExpressionParser;
import com.immomo.emmylua.lua.psi.parser.LuaStatementParser;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.WhitespacesAndCommentsBinder;
import com.intellij.lang.WhitespacesBinders;
import com.intellij.lang.parser.GeneratedParserUtilBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;

public class LuaParserUtil
extends GeneratedParserUtilBase {
    public static WhitespacesAndCommentsBinder MY_LEFT_COMMENT_BINDER = (list, b, tokenTextGetter) -> {
        int lines = 0;
        for (int i = list.size() - 1; i >= 0; --i) {
            IElementType type2 = (IElementType)list.get(i);
            if (type2 == LuaTypes.DOC_COMMENT) {
                return i;
            }
            CharSequence sequence = tokenTextGetter.get(i);
            if ((lines += StringUtil.getLineBreakCount((CharSequence)sequence)) > 1) break;
        }
        return list.size();
    };
    public static WhitespacesAndCommentsBinder MY_RIGHT_COMMENT_BINDER = (list, b, tokenTextGetter) -> {
        for (int i = 0; i < list.size(); ++i) {
            IElementType type2 = (IElementType)list.get(i);
            if (type2 == LuaTypes.DOC_COMMENT) {
                return i + 1;
            }
            CharSequence sequence = tokenTextGetter.get(i);
            if (StringUtil.contains((CharSequence)sequence, (CharSequence)"\n")) break;
        }
        return 0;
    };
    private static TokenSet END_SET = TokenSet.create((IElementType[])new IElementType[]{LuaTypes.END});
    private static TokenSet IF_SKIPS = TokenSet.create((IElementType[])new IElementType[]{LuaTypes.THEN, LuaTypes.ELSE, LuaTypes.ELSEIF});
    private static TokenSet REPEAT_TYPES = TokenSet.create((IElementType[])new IElementType[]{LuaTypes.UNTIL});
    private static TokenSet THEN_TYPES1 = TokenSet.create((IElementType[])new IElementType[]{LuaTypes.ELSE, LuaTypes.ELSEIF, LuaTypes.END});
    private static TokenSet THEN_SKIPS2 = TokenSet.create((IElementType[])new IElementType[]{LuaTypes.ELSE, LuaTypes.ELSEIF});
    private static TokenSet BRACE_L_SET = TokenSet.create((IElementType[])new IElementType[]{LuaTypes.LCURLY, LuaTypes.LBRACK, LuaTypes.LPAREN});
    private static TokenSet BRACE_R_SET = TokenSet.create((IElementType[])new IElementType[]{LuaTypes.RCURLY, LuaTypes.RBRACK, LuaTypes.RPAREN});

    public static boolean repeat(PsiBuilder builder_, int level_, GeneratedParserUtilBase.Parser parser, int times) {
        PsiBuilder.Marker marker = builder_.mark();
        boolean r = true;
        for (int i = 0; r && i < times; ++i) {
            r = parser.parse(builder_, level_);
        }
        marker.rollbackTo();
        return r;
    }

    public static boolean checkType(PsiBuilder builder_, int level_, IElementType type2) {
        LighterASTNode marker = builder_.getLatestDoneMarker();
        return marker != null && marker.getTokenType() == type2;
    }

    public static boolean lazyBlock(PsiBuilder builder_, int level_) {
        int i = 0;
        IElementType begin = builder_.rawLookup(--i);
        while (begin == TokenType.WHITE_SPACE) {
            begin = builder_.rawLookup(--i);
        }
        if (begin != null) {
            PsiBuilder.Marker marker = builder_.mark();
            marker.setCustomEdgeTokenBinders(WhitespacesBinders.GREEDY_LEFT_BINDER, null);
            if (begin == LuaTypes.RPAREN) {
                begin = LuaTypes.FUNCTION;
            }
            LuaParserUtil.matchStart(true, builder_, 0, begin);
            marker.collapse(LuaTypes.BLOCK);
            marker.setCustomEdgeTokenBinders(null, WhitespacesBinders.GREEDY_RIGHT_BINDER);
        }
        return true;
    }

    private static boolean matchStart(boolean advanced, PsiBuilder builder, int level, IElementType begin) {
        if (begin == LuaTypes.DO) {
            return LuaParserUtil.matchEnd(advanced, builder, level, TokenSet.EMPTY, END_SET);
        }
        if (begin == LuaTypes.REPEAT) {
            return LuaParserUtil.matchEnd(advanced, builder, level, TokenSet.EMPTY, REPEAT_TYPES);
        }
        if (begin == LuaTypes.IF) {
            return LuaParserUtil.matchEnd(advanced, builder, level, IF_SKIPS, END_SET);
        }
        if (begin == LuaTypes.THEN) {
            if (level == 0) {
                return LuaParserUtil.matchEnd(advanced, builder, level, TokenSet.EMPTY, THEN_TYPES1);
            }
            return LuaParserUtil.matchEnd(advanced, builder, level, THEN_SKIPS2, END_SET);
        }
        if (begin == LuaTypes.ELSE) {
            return LuaParserUtil.matchEnd(advanced, builder, level, TokenSet.EMPTY, END_SET);
        }
        if (begin == LuaTypes.FUNCTION) {
            return LuaParserUtil.matchEnd(advanced, builder, level, TokenSet.EMPTY, END_SET);
        }
        return false;
    }

    private static IElementType getRBrace(IElementType type2) {
        if (type2 == LuaTypes.LCURLY) {
            return LuaTypes.RCURLY;
        }
        if (type2 == LuaTypes.LPAREN) {
            return LuaTypes.RPAREN;
        }
        if (type2 == LuaTypes.LBRACK) {
            return LuaTypes.RBRACK;
        }
        return null;
    }

    private static boolean matchBrace(boolean advanced, PsiBuilder builder, int level, IElementType end) {
        if (!advanced) {
            builder.advanceLexer();
        }
        IElementType type2 = builder.getTokenType();
        while (type2 != null && !builder.eof()) {
            while (true) {
                if (type2 == end) {
                    if (level != 0) {
                        builder.advanceLexer();
                    }
                    return true;
                }
                boolean matchBrace = false;
                if (BRACE_L_SET.contains(type2)) {
                    matchBrace = LuaParserUtil.matchBrace(false, builder, level + 1, LuaParserUtil.getRBrace(type2));
                }
                if (!matchBrace) break;
                type2 = builder.getTokenType();
            }
            builder.advanceLexer();
            type2 = builder.getTokenType();
        }
        return false;
    }

    private static boolean matchEnd(boolean advanced, PsiBuilder builder, int level, TokenSet skips, TokenSet types) {
        if (!advanced) {
            builder.advanceLexer();
        }
        IElementType type2 = builder.getTokenType();
        while (type2 != null && !builder.eof()) {
            while (!skips.contains(type2)) {
                if (types.contains(type2)) {
                    if (level != 0) {
                        builder.advanceLexer();
                    }
                    return true;
                }
                boolean isMatched = LuaParserUtil.matchStart(false, builder, level + 1, type2);
                if (!isMatched) break;
                type2 = builder.getTokenType();
            }
            builder.advanceLexer();
            type2 = builder.getTokenType();
        }
        return false;
    }

    public static boolean parseExpr(PsiBuilder b, int l) {
        return LuaExpressionParser.INSTANCE.parseExpr(b, l) != null;
    }

    public static boolean parseStatement(PsiBuilder b, int l) {
        return LuaStatementParser.INSTANCE.parseStatement(b, l) != null;
    }
}

