/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.emmylua.lua.psi;

import com.immomo.emmylua.lua.LLuaPluginID;
import com.immomo.emmylua.lua.ext.ILuaFileResolver;
import com.immomo.emmylua.lua.project.LLuaSourceRootManager;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.SmartList;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LuaFileUtil {
    private static String[] extensions = new String[]{".lua.txt", ".lua", ".txt", ""};
    public static Key<Boolean> PREDEFINED_KEY = Key.create((String)"llua.lib.predefined");

    public static boolean fileEquals(VirtualFile f1, VirtualFile f2) {
        if (f1 == null || f2 == null) {
            return false;
        }
        return f1.getPath().equals(f2.getPath());
    }

    public static List<String> getAllAvailablePathsForMob(@Nullable String shortPath, @NotNull VirtualFile file) {
        if (file == null) {
            LuaFileUtil.$$$reportNull$$$0(0);
        }
        SmartList list = new SmartList();
        String fullPath = file.getCanonicalPath();
        if (fullPath != null) {
            for (String ext : extensions) {
                if (!fullPath.endsWith(ext)) continue;
                list.add((Object)fullPath.substring(0, fullPath.length() - ext.length()));
            }
        }
        if (shortPath != null) {
            for (String ext : extensions) {
                if (!shortPath.endsWith(ext)) continue;
                String path = shortPath.substring(0, shortPath.length() - ext.length());
                list.add((Object)path);
                if (path.indexOf(47) == -1) continue;
                list.add((Object)path.replace('/', '.'));
            }
        }
        return list;
    }

    @Nullable
    public static VirtualFile findFile(@NotNull Project project, String shortUrl) {
        if (project == null) {
            LuaFileUtil.$$$reportNull$$$0(1);
        }
        if (shortUrl == null) {
            return null;
        }
        return ILuaFileResolver.Companion.findLuaFile(project, shortUrl, extensions);
    }

    public static String getShortPath(Project project, VirtualFile file) {
        return VfsUtil.urlToPath((String)LuaFileUtil.getShortUrl(project, file));
    }

    private static String getShortUrl(Project project, VirtualFile file) {
        String fileFullUrl;
        String fileShortUrl = fileFullUrl = file.getUrl();
        List<VirtualFile> roots = LLuaSourceRootManager.Companion.getInstance(project).getSourceRoots();
        for (VirtualFile root : roots) {
            String sourceRootUrl = root.getUrl();
            if (!fileFullUrl.startsWith(sourceRootUrl)) continue;
            fileShortUrl = fileFullUrl.substring(sourceRootUrl.length() + 1);
            break;
        }
        return fileShortUrl;
    }

    @Nullable
    private static VirtualFile getSourceRoot(Project project, VirtualFile file) {
        String fileFullUrl = file.getUrl();
        List<VirtualFile> roots = LLuaSourceRootManager.Companion.getInstance(project).getSourceRoots();
        for (VirtualFile root : roots) {
            String sourceRootUrl = root.getUrl();
            if (!fileFullUrl.startsWith(sourceRootUrl)) continue;
            return root;
        }
        return null;
    }

    @Nullable
    public static VirtualFile getPluginVirtualDirectory() {
        IdeaPluginDescriptor descriptor = PluginManager.getPlugin((PluginId)PluginId.getId((String)LLuaPluginID.pluginID));
        if (descriptor != null) {
            File pluginPath = descriptor.getPath();
            String url = VfsUtil.pathToUrl((String)pluginPath.getAbsolutePath());
            return VirtualFileManager.getInstance().findFileByUrl(url);
        }
        return null;
    }

    @Nullable
    public static String getPluginVirtualFile(String path) {
        VirtualFile directory = LuaFileUtil.getPluginVirtualDirectory();
        if (directory != null) {
            String fullPath = directory.getPath() + "/classes/" + path;
            if (new File(fullPath).exists()) {
                return fullPath;
            }
            fullPath = directory.getPath() + "/" + path;
            if (new File(fullPath).exists()) {
                return fullPath;
            }
        }
        return null;
    }

    @Nullable
    public static String asRequirePath(@NotNull Project project, @NotNull VirtualFile file) {
        VirtualFile root;
        if (project == null) {
            LuaFileUtil.$$$reportNull$$$0(2);
        }
        if (file == null) {
            LuaFileUtil.$$$reportNull$$$0(3);
        }
        if ((root = LuaFileUtil.getSourceRoot(project, file)) == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        VirtualFile item = file;
        while (!item.equals(root)) {
            if (item.isDirectory()) {
                list.add(item.getName());
            } else {
                list.add(FileUtil.getNameWithoutExtension((String)item.getName()));
            }
            item = item.getParent();
        }
        if (list.isEmpty()) {
            return null;
        }
        Collections.reverse(list);
        return String.join((CharSequence)".", list);
    }

    public static boolean isStdLibFile(@NotNull VirtualFile file, Project project) {
        if (file == null) {
            LuaFileUtil.$$$reportNull$$$0(4);
        }
        return file.getUserData(PREDEFINED_KEY) != null || FileIndexFacade.getInstance((Project)project).isInLibraryClasses(file);
    }

    @Nullable
    public static String getArchExeFile() {
        return LuaFileUtil.getPluginVirtualFile("debugger/windows/x86/emmy.arch.exe");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/immomo/emmylua/lua/psi/LuaFileUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getAllAvailablePathsForMob";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findFile";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "asRequirePath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isStdLibFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

