/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.emmylua.lua.psi;

import com.immomo.emmylua.lua.psi.ComputeKind;
import com.immomo.emmylua.lua.psi.ComputeResult;
import com.immomo.emmylua.lua.psi.ExpressionUtil$Companion$WhenMappings;
import com.immomo.emmylua.lua.psi.LuaBinaryExpr;
import com.immomo.emmylua.lua.psi.LuaBinaryOp;
import com.immomo.emmylua.lua.psi.LuaExpr;
import com.immomo.emmylua.lua.psi.LuaLiteralExpr;
import com.immomo.emmylua.lua.psi.LuaParenExpr;
import com.immomo.emmylua.lua.psi.LuaTypes;
import com.immomo.emmylua.lua.psi.PsiExtensionKt;
import com.intellij.lang.ASTNode;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/immomo/emmylua/lua/psi/ExpressionUtil;", "", "()V", "Companion", "MMPaas"})
public final class ExpressionUtil {
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lcom/immomo/emmylua/lua/psi/ExpressionUtil$Companion;", "", "()V", "calcBinary", "Lcom/immomo/emmylua/lua/psi/ComputeResult;", "l", "r", "op", "Lcom/intellij/psi/tree/IElementType;", "compute", "expr", "Lcom/immomo/emmylua/lua/psi/LuaExpr;", "MMPaas"})
    public static final class Companion {
        @Nullable
        public final ComputeResult compute(@NotNull LuaExpr expr) {
            ComputeResult computeResult;
            Intrinsics.checkParameterIsNotNull((Object)expr, (String)"expr");
            LuaExpr luaExpr = expr;
            if (luaExpr instanceof LuaLiteralExpr) {
                switch (ExpressionUtil$Companion$WhenMappings.$EnumSwitchMapping$0[PsiExtensionKt.getKind((LuaLiteralExpr)expr).ordinal()]) {
                    case 1: {
                        computeResult = new ComputeResult(ComputeKind.String, false, 0.0f, PsiExtensionKt.getStringValue((LuaLiteralExpr)expr), null, 16, null);
                        break;
                    }
                    case 2: {
                        computeResult = new ComputeResult(ComputeKind.Bool, PsiExtensionKt.getBoolValue((LuaLiteralExpr)expr), 0.0f, null, null, 28, null);
                        break;
                    }
                    case 3: {
                        computeResult = new ComputeResult(ComputeKind.Number, false, PsiExtensionKt.getNumberValue((LuaLiteralExpr)expr), null, null, 24, null);
                        break;
                    }
                    case 4: {
                        computeResult = new ComputeResult(ComputeKind.Nil, false, 0.0f, "nil", null, 16, null);
                        break;
                    }
                    default: {
                        computeResult = null;
                        break;
                    }
                }
            } else {
                if (luaExpr instanceof LuaBinaryExpr) {
                    LuaExpr luaExpr2 = PsiExtensionKt.getLeft((LuaBinaryExpr)expr);
                    if (luaExpr2 == null) {
                        Intrinsics.throwNpe();
                    }
                    ComputeResult computeResult2 = this.compute(luaExpr2);
                    if (computeResult2 == null) {
                        return null;
                    }
                    ComputeResult left = computeResult2;
                    LuaExpr luaExpr3 = PsiExtensionKt.getRight((LuaBinaryExpr)expr);
                    if (luaExpr3 == null) {
                        return null;
                    }
                    LuaExpr rExpr = luaExpr3;
                    ComputeResult computeResult3 = this.compute(rExpr);
                    if (computeResult3 == null) {
                        return null;
                    }
                    ComputeResult right = computeResult3;
                    LuaBinaryOp luaBinaryOp = ((LuaBinaryExpr)expr).getBinaryOp();
                    Intrinsics.checkExpressionValueIsNotNull((Object)luaBinaryOp, (String)"expr.binaryOp");
                    LuaBinaryOp op = luaBinaryOp;
                    ASTNode aSTNode = op.getNode();
                    Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"op.node");
                    ASTNode aSTNode2 = aSTNode.getFirstChildNode();
                    Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode2, (String)"op.node.firstChildNode");
                    IElementType iElementType = aSTNode2.getElementType();
                    Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"op.node.firstChildNode.elementType");
                    return this.calcBinary(left, right, iElementType);
                }
                if (luaExpr instanceof LuaParenExpr) {
                    LuaExpr inner = ((LuaParenExpr)expr).getExpr();
                    computeResult = inner != null ? this.compute(inner) : null;
                } else {
                    return new ComputeResult(ComputeKind.Other, true, 0.0f, "", expr);
                }
            }
            return computeResult;
        }

        private final ComputeResult calcBinary(ComputeResult l, ComputeResult r, IElementType op) {
            boolean bl;
            boolean b = false;
            float n = 0.0f;
            String s = "";
            ComputeKind k = l.getKind();
            boolean isValid = false;
            IElementType iElementType = op;
            if (Intrinsics.areEqual((Object)iElementType, (Object)LuaTypes.OR)) {
                return l.getBValue() ? l : r;
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)LuaTypes.AND)) {
                return l.getBValue() ? r : l;
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)LuaTypes.PLUS)) {
                n = l.getNValue() + r.getNValue();
                isValid = l.getKind() == ComputeKind.Number && r.getKind() == ComputeKind.Number;
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)LuaTypes.MINUS)) {
                n = l.getNValue() - r.getNValue();
                isValid = l.getKind() == ComputeKind.Number && r.getKind() == ComputeKind.Number;
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)LuaTypes.MULT)) {
                n = l.getNValue() * r.getNValue();
                isValid = l.getKind() == ComputeKind.Number && r.getKind() == ComputeKind.Number;
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)LuaTypes.DIV)) {
                n = l.getNValue() / r.getNValue();
                isValid = l.getKind() == ComputeKind.Number && r.getKind() == ComputeKind.Number;
                isValid = isValid && r.getNValue() != 0.0f;
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)LuaTypes.DOUBLE_DIV)) {
                n = l.getNValue() / r.getNValue();
                n = (int)n;
                isValid = l.getKind() == ComputeKind.Number && r.getKind() == ComputeKind.Number;
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)LuaTypes.MOD)) {
                n = l.getNValue() % r.getNValue();
                isValid = l.getKind() == ComputeKind.Number && r.getKind() == ComputeKind.Number;
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)LuaTypes.CONCAT)) {
                if (l.getKind() == ComputeKind.String) {
                    isValid = r.getKind() == ComputeKind.String || r.getKind() == ComputeKind.Number;
                } else if (r.getKind() == ComputeKind.String) {
                    isValid = l.getKind() == ComputeKind.Number;
                }
                k = ComputeKind.String;
                if (isValid) {
                    s = l.getString() + r.getString();
                }
            }
            switch (ExpressionUtil$Companion$WhenMappings.$EnumSwitchMapping$1[k.ordinal()]) {
                case 1: 
                case 2: 
                case 3: {
                    bl = true;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            b = bl;
            return isValid ? new ComputeResult(k, b, n, s, null, 16, null) : null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

