/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.emmylua.lua.project;

import com.immomo.emmylua.lua.lang.LuaLanguageLevel;
import com.immomo.emmylua.lua.project.LLuaSettings;
import com.immomo.emmylua.lua.project.LuaAdditionalSourcesRootPanel;
import com.immomo.emmylua.lua.project.StdLibraryProvider;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.FileContentUtil;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.SortedMap;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LuaSettingsPanel
implements SearchableConfigurable,
Configurable.NoScroll {
    private LLuaSettings settings;
    private JPanel myPanel;
    private JTextField constructorNames;
    private JCheckBox strictDoc;
    private JCheckBox smartCloseEnd;
    private JCheckBox showWordsInFile;
    private JCheckBox enforceTypeSafety;
    private JCheckBox nilStrict;
    private JCheckBox recognizeGlobalNameAsCheckBox;
    private LuaAdditionalSourcesRootPanel additionalRoots;
    private JCheckBox enableGenericCheckBox;
    private JCheckBox captureOutputDebugString;
    private JCheckBox captureStd;
    private JComboBox<String> defaultCharset;
    private JComboBox<LuaLanguageLevel> languageLevel;
    private JCheckBox autoInsertParameters;

    public LuaSettingsPanel(LLuaSettings settings) {
        this.settings = settings;
        this.$$$setupUI$$$();
        this.constructorNames.setText(settings.getConstructorNamesString());
        this.strictDoc.setSelected(settings.isStrictDoc());
        this.smartCloseEnd.setSelected(settings.isSmartCloseEnd());
        this.autoInsertParameters.setSelected(settings.getAutoInsertParameters());
        this.showWordsInFile.setSelected(settings.isShowWordsInFile());
        this.enforceTypeSafety.setSelected(settings.isEnforceTypeSafety());
        this.nilStrict.setSelected(settings.isNilStrict());
        this.recognizeGlobalNameAsCheckBox.setSelected(settings.isRecognizeGlobalNameAsType());
        this.additionalRoots.setRoots(settings.getAdditionalSourcesRoot());
        this.enableGenericCheckBox.setSelected(settings.getEnableGeneric());
        this.captureStd.setSelected(settings.getAttachDebugCaptureStd());
        this.captureOutputDebugString.setSelected(settings.getAttachDebugCaptureOutput());
        SortedMap<String, Charset> charsetSortedMap = Charset.availableCharsets();
        DefaultComboBoxModel<String> outputCharsetModel = new DefaultComboBoxModel<String>(ArrayUtil.toStringArray(charsetSortedMap.keySet()));
        this.defaultCharset.setModel(outputCharsetModel);
        this.defaultCharset.setSelectedItem(settings.getAttachDebugDefaultCharsetName());
        DefaultComboBoxModel<LuaLanguageLevel> lanLevelModel = new DefaultComboBoxModel<LuaLanguageLevel>(LuaLanguageLevel.values());
        this.languageLevel.setModel(lanLevelModel);
        lanLevelModel.setSelectedItem((Object)settings.getLanguageLevel());
    }

    @NotNull
    public String getId() {
        return "LLua";
    }

    @Nls
    public String getDisplayName() {
        return "LLua";
    }

    @Nullable
    public JComponent createComponent() {
        return this.myPanel;
    }

    public boolean isModified() {
        return !StringUtil.equals((CharSequence)this.settings.getConstructorNamesString(), (CharSequence)this.constructorNames.getText()) || this.settings.isStrictDoc() != this.strictDoc.isSelected() || this.settings.isSmartCloseEnd() != this.smartCloseEnd.isSelected() || this.settings.getAutoInsertParameters() != this.autoInsertParameters.isSelected() || this.settings.isShowWordsInFile() != this.showWordsInFile.isSelected() || this.settings.isEnforceTypeSafety() != this.enforceTypeSafety.isSelected() || this.settings.isNilStrict() != this.nilStrict.isSelected() || this.settings.isRecognizeGlobalNameAsType() != this.recognizeGlobalNameAsCheckBox.isSelected() || this.settings.getEnableGeneric() != this.enableGenericCheckBox.isSelected() || this.settings.getAttachDebugCaptureOutput() != this.captureOutputDebugString.isSelected() || this.settings.getAttachDebugCaptureStd() != this.captureStd.isSelected() || this.settings.getAttachDebugDefaultCharsetName() != this.defaultCharset.getSelectedItem() || this.settings.getLanguageLevel() != this.languageLevel.getSelectedItem() || !ArrayUtil.equals((Object[])this.settings.getAdditionalSourcesRoot(), (Object[])this.additionalRoots.getRoots(), String::compareTo);
    }

    public void apply() {
        this.settings.setConstructorNamesString(this.constructorNames.getText());
        this.constructorNames.setText(this.settings.getConstructorNamesString());
        this.settings.setStrictDoc(this.strictDoc.isSelected());
        this.settings.setSmartCloseEnd(this.smartCloseEnd.isSelected());
        this.settings.setAutoInsertParameters(this.autoInsertParameters.isSelected());
        this.settings.setShowWordsInFile(this.showWordsInFile.isSelected());
        this.settings.setEnforceTypeSafety(this.enforceTypeSafety.isSelected());
        this.settings.setNilStrict(this.nilStrict.isSelected());
        this.settings.setRecognizeGlobalNameAsType(this.recognizeGlobalNameAsCheckBox.isSelected());
        this.settings.setAdditionalSourcesRoot(this.additionalRoots.getRoots());
        this.settings.setEnableGeneric(this.enableGenericCheckBox.isSelected());
        this.settings.setAttachDebugCaptureOutput(this.captureOutputDebugString.isSelected());
        this.settings.setAttachDebugCaptureStd(this.captureStd.isSelected());
        this.settings.setAttachDebugDefaultCharsetName((String)Objects.requireNonNull(this.defaultCharset.getSelectedItem()));
        LuaLanguageLevel selectedLevel = (LuaLanguageLevel)((Object)Objects.requireNonNull(this.languageLevel.getSelectedItem()));
        if (selectedLevel != this.settings.getLanguageLevel()) {
            this.settings.setLanguageLevel(selectedLevel);
            StdLibraryProvider.Companion.reload();
            FileContentUtil.reparseOpenedFiles();
        } else {
            for (Project project : ProjectManager.getInstance().getOpenProjects()) {
                DaemonCodeAnalyzer.getInstance((Project)project).restart();
            }
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        LuaAdditionalSourcesRootPanel luaAdditionalSourcesRootPanel;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JCheckBox jCheckBox5;
        JCheckBox jCheckBox6;
        JCheckBox jCheckBox7;
        JCheckBox jCheckBox8;
        JCheckBox jCheckBox9;
        JCheckBox jCheckBox10;
        JTextField jTextField;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new FormLayout("fill:d:grow", "center:d:noGrow,top:4dlu:noGrow,center:max(d;4px):noGrow,top:4dlu:noGrow,center:max(d;4px):noGrow,top:4dlu:noGrow,center:max(d;4px):noGrow,top:4dlu:noGrow,center:max(d;4px):noGrow,top:4dlu:noGrow,center:max(d;4px):noGrow"));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new CellConstraints(1, 1, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.constructorNames = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(3, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("LuaBundle").getString("ui.settings.constructor_names"));
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.smartCloseEnd = jCheckBox10 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox10, ResourceBundle.getBundle("LuaBundle").getString("ui.settings.smart_close_end"));
        jPanel2.add((Component)jCheckBox10, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.strictDoc = jCheckBox9 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox9, ResourceBundle.getBundle("LuaBundle").getString("ui.settings.strict_doc"));
        jPanel2.add((Component)jCheckBox9, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.enableGenericCheckBox = jCheckBox8 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox8, ResourceBundle.getBundle("LuaBundle").getString("ui.settings.enable_generic"));
        jPanel2.add((Component)jCheckBox8, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.autoInsertParameters = jCheckBox7 = new JCheckBox();
        jCheckBox7.setText("auto Insert Parameters");
        jPanel2.add((Component)jCheckBox7, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new CellConstraints(1, 5, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Completion", 0, 0, null, null));
        this.showWordsInFile = jCheckBox6 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox6, ResourceBundle.getBundle("LuaBundle").getString("ui.settings.show_words"));
        jPanel3.add((Component)jCheckBox6, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null, 2));
        this.recognizeGlobalNameAsCheckBox = jCheckBox5 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox5, ResourceBundle.getBundle("LuaBundle").getString("ui.settings.recognize_global_name_as_type"));
        jPanel3.add((Component)jCheckBox5, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null, 2));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel4, new CellConstraints(1, 7, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceBundle.getBundle("LuaBundle").getString("ui.settings.type_safety"), 0, 0, null, null));
        this.enforceTypeSafety = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("LuaBundle").getString("ui.settings.enforce_type_safety"));
        jPanel4.add((Component)jCheckBox4, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null, 2));
        this.nilStrict = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("LuaBundle").getString("ui.settings.strict_nil_checks"));
        jPanel4.add((Component)jCheckBox3, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null, 2));
        this.additionalRoots = luaAdditionalSourcesRootPanel = new LuaAdditionalSourcesRootPanel();
        jPanel.add((Component)luaAdditionalSourcesRootPanel, new CellConstraints(1, 11, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel5, new CellConstraints(1, 9, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        jPanel5.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Debugging", 0, 0, null, null));
        this.captureStd = jCheckBox2 = new JCheckBox();
        jCheckBox2.setSelected(true);
        jCheckBox2.setText("Capture stdout/stderr (Attach debugger)");
        jPanel5.add((Component)jCheckBox2, new GridConstraints(1, 0, 1, 2, 8, 0, 3, 0, null, null, null, 2));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Default charset");
        jPanel5.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 2));
        this.captureOutputDebugString = jCheckBox = new JCheckBox();
        jCheckBox.setSelected(true);
        jCheckBox.setText("Capture OutputDebugString (Attach debugger)");
        jPanel5.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 2, 8, 0, 3, 0, null, null, null, 2));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel6, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.defaultCharset = jComboBox;
        jPanel6.add(jComboBox, new GridConstraints(0, 0, 1, 1, 8, 1, 2, 0, new Dimension(30, -1), null, null));
        Spacer spacer2 = new Spacer();
        jPanel6.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel7, new CellConstraints(1, 3, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        jPanel7.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "LLua", 0, 0, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Language level");
        jPanel7.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox jComboBox2 = new JComboBox();
        this.languageLevel = jComboBox2;
        jPanel7.add(jComboBox2, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        jLabel.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

