/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.emmylua.lua.lexer;

import com.immomo.emmylua.lua.lang.LuaLanguageLevel;
import com.immomo.emmylua.lua.psi.LuaTypes;
import com.intellij.lexer.FlexLexer;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import java.io.IOException;
import java.io.Reader;

public class _LuaLexer
implements FlexLexer {
    public static final int YYEOF = -1;
    private static final int ZZ_BUFFERSIZE = 16384;
    public static final int YYINITIAL = 0;
    public static final int xSHEBANG = 2;
    public static final int xDOUBLE_QUOTED_STRING = 4;
    public static final int xSINGLE_QUOTED_STRING = 6;
    public static final int xBLOCK_STRING = 8;
    public static final int xCOMMENT = 10;
    public static final int xBLOCK_COMMENT = 12;
    private static final int[] ZZ_LEXSTATE = new int[]{0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6};
    static final char[] ZZ_CMAP_Z = _LuaLexer.zzUnpackCMap("\u0001\u0000\u0001@\u0006\u0080\u0080\u00c0");
    static final char[] ZZ_CMAP_Y = _LuaLexer.zzUnpackCMap("\u0001\u0000\u0001\u0001+\u0002\u0001\u0003\u0012\u0002\u0001\u0004\u001f\u0002\u0001\u0003_\u0002@\u0005");
    static final char[] ZZ_CMAP_A = _LuaLexer.zzUnpackCMap("\t\u001c\u0001\u0003\u0001\u0002\u0001\u0000\u0001\u0003\u0001\u0001\u0012\u001c\u0001\u0003\u0001,\u0001\u001a\u0001+\u0001\u001c\u00011\u00019\u0001\u001e\u00013\u00014\u00010\u0001\b\u00015\u0001\r\u0001\f\u00012\u0001\n\t\u0005\u00017\u00016\u0001.\u0001\u0018\u0001-\u0002\u001c\u0004\u0006\u0001\u0007\u0001\u0006\t\u001d\u0001\t\u0007\u001d\u0001\u000b\u0002\u001d\u0001\u0017\u0001\u001b\u0001\u0019\u00018\u0001\u001d\u0001\u001c\u0001\u001f\u0001 \u0001&\u0001\u0015\u0001\u000f\u0001$\u0001\u0010\u0001)\u0001\u0011\u0001\u001d\u0001!\u0001\"\u0001\u001d\u0001\u0013\u0001\u0012\u0001(\u0001\u001d\u0001\u000e\u0001#\u0001'\u0001%\u0001\u001d\u0001*\u0001\u000b\u0002\u001d\u0001\u0014\u0001:\u0001\u0016\u0001/\u0006\u001c\u0001\u0000\u001a\u001c\u0001\u0000^\u001c\u0081\u001d\u0001\u0004\u007f\u001d\u000b\u0004\u001d\u001d\u0002\u0004\u0005\u001d\u0001\u0004/\u001d\u0001\u0004 \u001d\u0080\u001c");
    private static final int[] ZZ_ACTION = _LuaLexer.zzUnpackAction();
    private static final String ZZ_ACTION_PACKED_0 = "\u0001\u0000\u0001\u0001\u0005\u0000\u0001\u0002\u0001\u0003\u0001\u0004\u0001\u0005\u0001\u0006\u0001\u0005\u0001\u0007\u0001\b\u0006\u0004\u0001\t\u0001\u0004\u0001\n\u0001\u000b\u0001\f\u0001\r\u0001\u000e\u0001\u000f\u0007\u0004\u0001\u0010\u0001\u0011\u0001\u0012\u0001\u0013\u0001\u0014\u0001\u0015\u0001\u0016\u0001\u0017\u0001\u0018\u0001\u0019\u0001\u001a\u0001\u001b\u0001\u001c\u0001\u001d\u0001\u001e\u0002\u001f\u0001\u0002\u0001\u0000\u0002 \u0002\u0005\u0001\u0000\u0001\u0005\u0001!\u0001\"\u0004\u0004\u0001#\u0001$\u0001%\u0002\u0004\u0001&\u0001'\u0001\u0000\u0001(\n\u0004\u0001)\u0001*\u0001+\u0001,\u0001-\u0001.\u0001/\u00010\u0001\u001f\u0004\u0000\u00011\u0002\u0000\u0002\u0005\u00012\u0004\u0000\u0002\u0004\u00013\u0002\u0004\u00014\u00015\u00016\u0002\u0004\u00017\u0006\u0004\u0001\u0000\u00011\u00018\u0001\u0000\u0001\u0005\u0006\u0000\u0002\u0004\u00019\u0001:\u0005\u0004\u0001;\u0001<\u0001\u0004\u0001=\u0002\u0000\u0001>\u0001\u0005\u0002\u0000\u0001?\u0001@\u0003\u0004\u0001A\u0001B\u0001C\u0001\u0004\u0001D\u0001E\u0001\u0000\u0001\u0005\u0002\u0000\u0001F\u0001G\u0001H\u0001\u0004\u0003\u0000\u0001\u0004\u0001\u0000\u0001I\u0002\u0000";
    private static final int[] ZZ_ROWMAP = _LuaLexer.zzUnpackRowMap();
    private static final String ZZ_ROWMAP_PACKED_0 = "\u0000\u0000\u0000;\u0000v\u0000\u00b1\u0000\u00ec\u0000\u0127\u0000\u0162\u0000\u019d\u0000\u01d8\u0000\u0213\u0000\u024e\u0000\u019d\u0000\u0289\u0000\u02c4\u0000\u02ff\u0000\u033a\u0000\u0375\u0000\u03b0\u0000\u03eb\u0000\u0426\u0000\u0461\u0000\u019d\u0000\u049c\u0000\u019d\u0000\u04d7\u0000\u0512\u0000\u019d\u0000\u019d\u0000\u019d\u0000\u054d\u0000\u0588\u0000\u05c3\u0000\u05fe\u0000\u0639\u0000\u0674\u0000\u06af\u0000\u06ea\u0000\u0725\u0000\u0760\u0000\u079b\u0000\u019d\u0000\u019d\u0000\u07d6\u0000\u019d\u0000\u019d\u0000\u019d\u0000\u019d\u0000\u0811\u0000\u019d\u0000\u019d\u0000\u019d\u0000\u084c\u0000\u0887\u0000\u08c2\u0000\u08fd\u0000\u019d\u0000\u0938\u0000\u0973\u0000\u09ae\u0000\u09e9\u0000\u0a24\u0000\u0a5f\u0000\u0a9a\u0000\u0ad5\u0000\u0b10\u0000\u0b4b\u0000\u0b86\u0000\u0213\u0000\u0213\u0000\u0213\u0000\u0bc1\u0000\u0bfc\u0000\u0213\u0000\u019d\u0000\u04d7\u0000\u019d\u0000\u0c37\u0000\u0c72\u0000\u0cad\u0000\u0ce8\u0000\u0d23\u0000\u0d5e\u0000\u0d99\u0000\u0dd4\u0000\u0e0f\u0000\u0e4a\u0000\u019d\u0000\u019d\u0000\u019d\u0000\u019d\u0000\u019d\u0000\u019d\u0000\u019d\u0000\u019d\u0000\u019d\u0000\u0e85\u0000\u0ec0\u0000\u0efb\u0000\u08c2\u0000\u0f36\u0000\u0f71\u0000\u0a24\u0000\u0fac\u0000\u0fe7\u0000\u019d\u0000\u1022\u0000\u105d\u0000\u1098\u0000\u10d3\u0000\u110e\u0000\u1149\u0000\u0213\u0000\u1184\u0000\u11bf\u0000\u0213\u0000\u0213\u0000\u0213\u0000\u11fa\u0000\u1235\u0000\u0213\u0000\u1270\u0000\u12ab\u0000\u12e6\u0000\u1321\u0000\u135c\u0000\u1397\u0000\u13d2\u0000\u140d\u0000\u1448\u0000\u1483\u0000\u14be\u0000\u14f9\u0000\u1534\u0000\u156f\u0000\u15aa\u0000\u15e5\u0000\u1620\u0000\u165b\u0000\u1696\u0000\u16d1\u0000\u0213\u0000\u170c\u0000\u1747\u0000\u1782\u0000\u17bd\u0000\u17f8\u0000\u0213\u0000\u0213\u0000\u1833\u0000\u13d2\u0000\u186e\u0000\u18a9\u0000\u18e4\u0000\u191f\u0000\u195a\u0000\u1995\u0000\u19d0\u0000\u1a0b\u0000\u1a46\u0000\u1a81\u0000\u1abc\u0000\u0213\u0000\u0213\u0000\u0213\u0000\u1af7\u0000\u0213\u0000\u0213\u0000\u1b32\u0000\u1b6d\u0000\u1ba8\u0000\u1be3\u0000\u0213\u0000\u0213\u0000\u0213\u0000\u1c1e\u0000\u1c59\u0000\u1c94\u0000\u1ccf\u0000\u1d0a\u0000\u1d45\u0000\u0213\u0000\u1d80\u0000\u1dbb";
    private static final int[] ZZ_TRANS = _LuaLexer.zzUnpackTrans();
    private static final String ZZ_TRANS_PACKED_0 = "\u0001\b\u0003\t\u0001\n\u0001\u000b\u0002\n\u0001\f\u0001\n\u0001\r\u0001\n\u0001\u000e\u0001\u000f\u0001\u0010\u0001\u0011\u0001\u0012\u0001\u0013\u0001\u0014\u0001\u0015\u0001\u0016\u0001\u0017\u0001\u0018\u0001\u0019\u0001\u001a\u0001\u001b\u0001\u001c\u0002\b\u0001\n\u0001\u001d\u0001\u001e\u0001\u001f\u0001\n\u0001 \u0001\n\u0001!\u0001\"\u0001\n\u0001#\u0002\n\u0001$\u0001%\u0001\b\u0001&\u0001'\u0001(\u0001)\u0001*\u0001+\u0001,\u0001-\u0001.\u0001/\u00010\u00011\u00012\u00013\u0001\u0002\u0002\u00008\u0002\u001a\u0000\u00014>\u0000\u00015\u001c\u0000\u0017\b\u00016#\b\r\u0000\u00017-\u0000\r8\u00019-8<\u0000\u0003\t;\u0000\u0004\n\u0001\u0000\u0003\n\u0002\u0000\u0006\n\u0001\u0000\u0001\n\u0007\u0000\u0001\n\u0001\u0000\f\n\u0015\u0000\u0001\u000b\u0001\u0000\u0001:\u0002\u0000\u0001\u000b\u0001\u0000\u0001;\u0002\u0000\u0001:0\u0000\u0001\u000b\u0001\u0000\u0001:\u0002\u0000\u0001\u000b\u0001<\u0001;\u0002\u0000\u0001:0\u0000\u0001=\u0004\u0000\u0001=\u0001\u0000\u0001>;\u0000\u0001?1\u0000\u0004\n\u0001\u0000\u0003\n\u0002\u0000\u0001\n\u0001@\u0004\n\u0001\u0000\u0001\n\u0007\u0000\u0001\n\u0001\u0000\f\n\u0014\u0000\u0004\n\u0001\u0000\u0003\n\u0002\u0000\u0005\n\u0001A\u0001\u0000\u0001\n\u0007\u0000\u0001\n\u0001\u0000\u0003\n\u0001B\b\n\u0014\u0000\u0004\n\u0001\u0000\u0003\n\u0002\u0000\u0004\n\u0001C\u0001\n\u0001\u0000\u0001\n\u0007\u0000\u0001\n\u0001\u0000\f\n\u0014\u0000\u0004\n\u0001\u0000\u0003\n\u0002\u0000\u0005\n\u0001D\u0001\u0000\u0001\n\u0007\u0000\u0001\n\u0001\u0000\u0005\n\u0001E\u0006\n\u0014\u0000\u0004\n\u0001\u0000\u0003\n\u0002\u0000\u0001F\u0005\n\u0001\u0000\u0001\n\u0007\u0000\u0001\n\u0001\u0000\f\n\u0014\u0000\u0004\n\u0001\u0000\u0003\n\u0002\u0000\u0003\n\u0001G\u0001H\u0001\n\u0001\u0000\u0001\n\u0007\u0000\u0001\n\u0001\u0000\f\n\u0014\u0000\u0004\n\u0001\u0000\u0003\n\u0002\u0000\u0004\n\u0001I\u0001\n\u0001\u0000\u0001\n\u0007\u0000\u0001\n\u0001\u0000\f\n'\u0000\u0001J\u0001K:\u0000\u0001L&\u0000\u0004\n\u0001\u0000\u0003\n\u0002\u0000\u0005\n\u0001M\u0001\u0000\u0001\n\u0007\u0000\u0001\n\u0001\u0000\f\n\u0014\u0000\u0004\n\u0001\u0000\u0003\n\u0002\u0000\u0001N\u0005\n\u0001\u0000\u0001\n\u0007\u0000\u0001\n\u0001\u0000\f\n\u0014\u0000\u0004\n\u0001\u0000\u0003\n\u0002\u0000\u0004\n\u0001O\u0001\n\u0001\u0000\u0001\n\u0007\u0000\u0001\n\u0001\u0000\f\n\u0014\u0000\u0004\n\u0001\u0000\u0003\n\u0002\u0000\u0004\n\u0001P\u0001\n\u0001\u0000\u0001\n\u0007\u0000\u0001\n\u0001\u0000\u0001Q\u0005\n\u0001R\u0005\n\u0014\u0000\u0004\n\u0001\u0000\u0003\n\u0002\u0000\u0005\n\u0001S\u0001\u0000\u0001\n\u0007\u0000\u0001\n\u0001\u0000\f\n\u0014\u0000\u0004\n\u0001\u0000\u0003\n\u0002\u0000\u0001T\u0005\n\u0001\u0000\u0001\n\u0007\u0000\u0001\n\u0001\u0000\n\n\u0001U\u0001\n\u0014\u0000\u0004\n\u0001\u0000\u0003\n\u0002\u0000\u0006\n\u0001\u0000\u0001\n\u0007\u0000\u0001\n\u0001\u0000\n\n\u0001V\u0001\n<\u0000\u0001W&\u0000\u0001X\u0014\u0000\u0001Y%\u0000\u0001Z\u0015\u0000\u0001[$\u0000\u0001\\T\u0000\u0001]?\u0000\u0001^\u0003\u0000\u001a4\u0001_\u0001`\u001f4\u001b5\u0001a\u00025\u0001_\u001c5\u0017\u0000\u0001b\u0001c/\u0000\u0001d:\u0000\u0001e2\u0000\u0001=\u0002\u0000\u0001f\u0001\u0000\u0001=\u0002\u0000\u0001f2\u0000\u0001g\u0004\u0000\u0001g5\u0000\u0003h\u0002\u0000\u0001h\u0004\u0000\u0001h\u0005\u0000\u0001h\t\u0000\u0002h\u0003\u0000\u0001h\u0001\u0000\u0001h\u0019\u0000\u0001=\u0004\u0000\u0001=<\u0000\u0001i<\u0000\u0001j\u0001k\u0004\u0000\u0001l\u0001\u0000\u0001m(\u0000\u0004\n\u0001\u0000\u0003\n\u0002\u0000\u0006\n\u0001\u0000\u0001\n\u0007\u0000\u0001\n\u0001\u0000\b\n\u0001n\u0001o\u0002\n\u0014\u0000\u0004\n\u0001\u0000\u0003\n\u0002\u0000\u0006\n\u0001\u0000\u0001p\u0007\u0000\u0001\n\u0001\u0000\f\n\u0014\u0000\u0004\n\u0001\u0000\u0003\n\u0002\u0000\u0006\n\u0001\u0000\u0001\n\u0007\u0000\u0001\n\u0001\u0000\u0004\n\u0001q\u0007\n\u0014\u0000\u0004\n\u0001\u0000\u0003\n\u0002\u0000\u0006\n\u0001\u0000\u0001\n\u0007\u0000\u0001\n\u0001\u0000\b\n\u0001r\u0003\n\u0014\u0000\u0004\n\u0001\u0000\u0003\n\u0002\u0000\u0006\n\u0001\u0000\u0001\n\u0007\u0000\u0001\n\u0001\u0000\u0003\n\u0001s\b\n\u0014\u0000\u0004\n\u0001\u0000\u0003\n\u0002\u0000\u0006\n\u0001\u0000\u0001\n\u0007\u0000\u0001\n\u0001\u0000\b\n\u0001t\u0003\n\u0014\u0000\u0004\n\u0001\u0000\u0003\n\u0002\u0000\u0006\n\u0001\u0000\u0001u\u0007\u0000\u0001\n\u0001\u0000\f\n\u0014\u0000\u0004\n\u0001\u0000\u0003\n\u0002\u0000\u0001\n\u0001v\u0004\n\u0001\u0000\u0001\n\u0007\u0000\u0001\n\u0001\u0000\f\n\u0014\u0000\u0004\n\u0001\u0000\u0003\n\u0002\u0000\u0006\n\u0001\u0000\u0001\n\u0007\u0000\u0001\n\u0001\u0000\u0007\n\u0001w\u0004\n\u0014\u0000\u0004\n\u0001\u0000\u0003\n\u0002\u0000\u0001x\u0005\n\u0001\u0000\u0001\n\u0007\u0000\u0001\n\u0001\u0000\f\n\u0014\u0000\u0004\n\u0001\u0000\u0003\n\u0002\u0000\u0006\n\u0001\u0000\u0001\n\u0007\u0000\u0001\n\u0001\u0000\u0003\n\u0001y\b\n\u0014\u0000\u0004\n\u0001\u0000\u0003\n\u0002\u0000\u0005\n\u0001z\u0001\u0000\u0001\n\u0007\u0000\u0001\n\u0001\u0000\f\n\u0014\u0000\u0004\n\u0001\u0000\u0003\n\u0002\u0000\u0006\n\u0001\u0000\u0001\n\u0007\u0000\u0001\n\u0001\u0000\b\n\u0001{\u0003\n\u0014\u0000\u0004\n\u0001\u0000\u0003\n\u0002\u0000\u0006\n\u0001\u0000\u0001\n\u0007\u0000\u0001\n\u0001\u0000\u0006\n\u0001|\u0005\n\u0014\u0000\u0004\n\u0001\u0000\u0003\n\u0002\u0000\u0001\n\u0001}\u0004\n\u0001\u0000\u0001\n\u0007\u0000\u0001\n\u0001\u0000\f\n\u0014\u0000\u0004\n\u0001\u0000\u0003\n\u0002\u0000\u0003\n\u0001~\u0002\n\u0001\u0000\u0001\n\u0007\u0000\u0001\n\u0001\u0000\f\n\u0011\u0000\u00024\u0002\u000064\u0001\u0000\u00025\u0002\u000065\u0019b\u0001\u007f!b\u0001\u0080\u0002\u0000\n\u0080\u0001\u0081-\u0080\u0017\u0000\u0001\u0082(\u0000\u0001g\u0001\u0000\u0001:\u0002\u0000\u0001g\u0004\u0000\u0001:0\u0000\u0002h\u0001\u0083\u0001\u0000\u0001\u0084\u0001h\u0001\u0000\u0001\u0085\u0002\u0000\u0001\u0083\u0005\u0000\u0001h\t\u0000\u0002h\u0003\u0000\u0001h\u0001\u0000\u0001h\u0001\u0000\u0001\u0084!\u0000\u0001\u0086>\u0000\u0001\u0087;\u0000\u0001\u0088<\u0000\u0001\u0089(\u0000\u0004\n\u0001\u0000\u0003\n\u0002\u0000\u0006\n\u0001\u0000\u0001\n\u0007\u0000\u0001\n\u0001\u0000\u0006\n\u0001\u008a\u0005\n\u0014\u0000\u0004\n\u0001\u0000\u0003\n\u0002\u0000\u0001\n\u0001\u008b\u0004\n\u0001\u0000\u0001\n\u0007\u0000\u0001\n\u0001\u0000\f\n\u0014\u0000\u0004\n\u0001\u0000\u0003\n\u0002\u0000\u0001\n\u0001\u008c\u0004\n\u0001\u0000\u0001\n\u0007\u0000\u0001\n\u0001\u0000\f\n\u0014\u0000\u0004\n\u0001\u0000\u0003\n\u0002\u0000\u0004\n\u0001\u008d\u0001\n\u0001\u0000\u0001\n\u0007\u0000\u0001\n\u0001\u0000\f\n\u0014\u0000\u0004\n\u0001\u0000\u0003\n\u0002\u0000\u0006\n\u0001\u0000\u0001\n\u0007\u0000\u0001\n\u0001\u0000\u0001\u008e\u000b\n\u0014\u0000\u0004\n\u0001\u0000\u0003\n\u0002\u0000\u0006\n\u0001\u0000\u0001\n\u0007\u0000\u0001\n\u0001\u0000\u0001\u008f\u000b\n\u0014\u0000\u0004\n\u0001\u0000\u0003\n\u0002\u0000\u0006\n\u0001\u0000\u0001\n\u0007\u0000\u0001\n\u0001\u0000\u0004\n\u0001\u0090\u0007\n\u0014\u0000\u0004\n\u0001\u0000\u0003\n\u0002\u0000\u0006\n\u0001\u0000\u0001\n\u0007\u0000\u0001\n\u0001\u0000\u0007\n\u0001\u0091\u0004\n\u0014\u0000\u0004\n\u0001\u0000\u0003\n\u0002\u0000\u0003\n\u0001\u0092\u0002\n\u0001\u0000\u0001\n\u0007\u0000\u0001\n\u0001\u0000\f\n\u0014\u0000\u0004\n\u0001\u0000\u0003\n\u0002\u0000\u0001\n\u0001\u0093\u0004\n\u0001\u0000\u0001\n\u0007\u0000\u0001\n\u0001\u0000\f\n\u0014\u0000\u0004\n\u0001\u0000\u0003\n\u0002\u0000\u0005\n\u0001\u0094\u0001\u0000\u0001\n\u0007\u0000\u0001\n\u0001\u0000\f\n\u0014\u0000\u0004\n\u0001\u0000\u0003\n\u0002\u0000\u0006\n\u0001\u0000\u0001\n\u0007\u0000\u0001\n\u0001\u0000\u0003\n\u0001\u0095\b\n\u0010\u0000\u0018b\u0001\u007f\u0001\u0096!b\u0001\u0080\u0002\u00008\u0080\u0001\u0081\u0001\u0097\u0001\u00988\u0081\u0017\u0000\u0001\u0099\u0001\u0082'\u0000\u0002h\u0001\u0083\u0001f\u0001\u0084\u0001h\u0001\u0000\u0001\u0085\u0001f\u0001\u0000\u0001\u0083\u0005\u0000\u0001h\t\u0000\u0002h\u0003\u0000\u0001h\u0001\u0000\u0001h\u0001\u0000\u0001\u0084\u001a\u0000\u0001f\u0004\u0000\u0001f2\u0000\u0003\u009a\u0002\u0000\u0001\u009a\u0004\u0000\u0001\u009a\u0005\u0000\u0001\u009a\t\u0000\u0002\u009a\u0003\u0000\u0001\u009a\u0001\u0000\u0001\u009a$\u0000\u0001\u009b?\u0000\u0001\u009c9\u0000\u0001\u009d<\u0000\u0001\u009e(\u0000\u0004\n\u0001\u0000\u0003\n\u0002\u0000\u0001\u009f\u0005\n\u0001\u0000\u0001\n\u0007\u0000\u0001\n\u0001\u0000\f\n\u0014\u0000\u0004\n\u0001\u0000\u0003\n\u0002\u0000\u0006\n\u0001\u0000\u0001\n\u0007\u0000\u0001\n\u0001\u0000\u0001\u00a0\u000b\n\u0014\u0000\u0004\n\u0001\u0000\u0003\n\u0002\u0000\u0003\n\u0001\u00a1\u0002\n\u0001\u0000\u0001\n\u0007\u0000\u0001\n\u0001\u0000\f\n\u0014\u0000\u0004\n\u0001\u0000\u0003\n\u0002\u0000\u0006\n\u0001\u0000\u0001\n\u0007\u0000\u0001\n\u0001\u0000\u0002\n\u0001\u00a2\t\n\u0014\u0000\u0004\n\u0001\u0000\u0003\n\u0002\u0000\u0006\n\u0001\u0000\u0001\n\u0007\u0000\u0001\n\u0001\u0000\u0003\n\u0001\u00a3\b\n\u0014\u0000\u0004\n\u0001\u0000\u0003\n\u0002\u0000\u0001\n\u0001\u00a4\u0004\n\u0001\u0000\u0001\n\u0007\u0000\u0001\n\u0001\u0000\f\n\u0014\u0000\u0004\n\u0001\u0000\u0003\n\u0002\u0000\u0006\n\u0001\u0000\u0001\n\u0007\u0000\u0001\n\u0001\u0000\b\n\u0001\u00a5\u0003\n\u0014\u0000\u0004\n\u0001\u0000\u0003\n\u0002\u0000\u0006\n\u0001\u0000\u0001\n\u0007\u0000\u0001\n\u0001\u0000\u0003\n\u0001\u00a6\b\n\u0014\u0000\u0004\n\u0001\u0000\u0003\n\u0002\u0000\u0001\n\u0001\u00a7\u0004\n\u0001\u0000\u0001\n\u0007\u0000\u0001\n\u0001\u0000\f\n\u0012\u0000\u0001\u0098;\u0000\u0001\u0098\t\u0000\u0001\u00a8-\u0000;\u0099\u0005\u0000\u0002\u009a\u0001\u00a9\u0001\u0000\u0001\u0084\u0001\u009a\u0004\u0000\u0001\u00a9\u0005\u0000\u0001\u009a\t\u0000\u0002\u009a\u0003\u0000\u0001\u009a\u0001\u0000\u0001\u009a\u0001\u0000\u0001\u0084#\u0000\u0001\u00aa7\u0000\u0001\u00ab,\u0000\u0001\u009d\u0002\u00008\u009d\u0001\u009e\u0002\u00008\u009e\u0004\u0000\u0004\n\u0001\u0000\u0003\n\u0002\u0000\u0005\n\u0001\u00ac\u0001\u0000\u0001\n\u0007\u0000\u0001\n\u0001\u0000\f\n\u0014\u0000\u0004\n\u0001\u0000\u0003\n\u0002\u0000\u0006\n\u0001\u0000\u0001\n\u0007\u0000\u0001\n\u0001\u0000\b\n\u0001\u00ad\u0003\n\u0014\u0000\u0004\n\u0001\u0000\u0003\n\u0002\u0000\u0006\n\u0001\u0000\u0001\n\u0007\u0000\u0001\n\u0001\u0000\u0005\n\u0001\u00ae\u0006\n\u0014\u0000\u0004\n\u0001\u0000\u0003\n\u0002\u0000\u0003\n\u0001\u00af\u0002\n\u0001\u0000\u0001\n\u0007\u0000\u0001\n\u0001\u0000\f\n\u001d\u0000\u0001\u00b02\u0000\u0002\u009a\u0001\u00a9\u0001f\u0001\u0084\u0001\u009a\u0002\u0000\u0001f\u0001\u0000\u0001\u00a9\u0005\u0000\u0001\u009a\t\u0000\u0002\u009a\u0003\u0000\u0001\u009a\u0001\u0000\u0001\u009a\u0001\u0000\u0001\u0084$\u0000\u0001\u00b17\u0000\u0001\u00b2/\u0000\u0004\n\u0001\u0000\u0003\n\u0002\u0000\u0004\n\u0001\u00b3\u0001\n\u0001\u0000\u0001\n\u0007\u0000\u0001\n\u0001\u0000\f\n\u001d\u0000\u0001\u0081@\u0000\u0001\u009d7\u0000\u0001\u00b4.\u0000\u0004\n\u0001\u0000\u0003\n\u0002\u0000\u0005\n\u0001\u00b5\u0001\u0000\u0001\n\u0007\u0000\u0001\n\u0001\u0000\f\n!\u0000\u0001\u00b6;\u0000\u0001\u00b7;\u0000\u0001\u009e'\u0000";
    private static final int ZZ_UNKNOWN_ERROR = 0;
    private static final int ZZ_NO_MATCH = 1;
    private static final int ZZ_PUSHBACK_2BIG = 2;
    private static final String[] ZZ_ERROR_MSG = new String[]{"Unknown internal scanner error", "Error: could not match input", "Error: pushback value was too large"};
    private static final int[] ZZ_ATTRIBUTE = _LuaLexer.zzUnpackAttribute();
    private static final String ZZ_ATTRIBUTE_PACKED_0 = "\u0001\u0000\u0001\u0001\u0005\u0000\u0001\t\u0003\u0001\u0001\t\t\u0001\u0001\t\u0001\u0001\u0001\t\u0002\u0001\u0003\t\u000b\u0001\u0002\t\u0001\u0001\u0004\t\u0001\u0001\u0003\t\u0003\u0001\u0001\u0000\u0001\t\u0003\u0001\u0001\u0000\r\u0001\u0001\t\u0001\u0000\u0001\t\n\u0001\t\t\u0004\u0000\u0001\u0001\u0002\u0000\u0002\u0001\u0001\t\u0004\u0000\u0011\u0001\u0001\u0000\u0002\u0001\u0001\u0000\u0001\u0001\u0006\u0000\r\u0001\u0002\u0000\u0002\u0001\u0002\u0000\u000b\u0001\u0001\u0000\u0001\u0001\u0002\u0000\u0004\u0001\u0003\u0000\u0001\u0001\u0001\u0000\u0001\u0001\u0002\u0000";
    private Reader zzReader;
    private int zzState;
    private int zzLexicalState = 0;
    private CharSequence zzBuffer = "";
    private int zzMarkedPos;
    private int zzCurrentPos;
    private int zzStartRead;
    private int zzEndRead;
    private boolean zzAtBOL = true;
    private boolean zzAtEOF;
    private boolean zzEOFDone;
    private LuaLanguageLevel level;
    private int nBrackets = 0;

    public static int ZZ_CMAP(int ch) {
        return ZZ_CMAP_A[ZZ_CMAP_Y[ZZ_CMAP_Z[ch >> 13] | ch >> 7 & 0x3F] << 7 | ch & 0x7F];
    }

    private static int[] zzUnpackAction() {
        int[] result = new int[183];
        int offset = 0;
        offset = _LuaLexer.zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAction(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackRowMap() {
        int[] result = new int[183];
        int offset = 0;
        offset = _LuaLexer.zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackRowMap(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int high = packed.charAt(i++) << 16;
            result[j++] = high | packed.charAt(i++);
        }
        return j;
    }

    private static int[] zzUnpackTrans() {
        int[] result = new int[7670];
        int offset = 0;
        offset = _LuaLexer.zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackTrans(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            int value = packed.charAt(i++);
            do {
                result[j++] = --value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackAttribute() {
        int[] result = new int[183];
        int offset = 0;
        offset = _LuaLexer.zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAttribute(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    public _LuaLexer(LuaLanguageLevel level) {
        this((Reader)null);
        this.level = level;
    }

    private boolean checkAhead(char c, int offset) {
        return this.zzMarkedPos + offset < this.zzBuffer.length() && this.zzBuffer.charAt(this.zzMarkedPos + offset) == c;
    }

    private boolean checkBlock() {
        this.nBrackets = 0;
        if (this.checkAhead('[', 0)) {
            int n = 0;
            while (this.checkAhead('=', n + 1)) {
                ++n;
            }
            if (this.checkAhead('[', n + 1)) {
                this.nBrackets = n;
                return true;
            }
        }
        return false;
    }

    private int checkBlockRedundant() {
        int redundant = -1;
        String cs = this.yytext().toString();
        StringBuilder s = new StringBuilder("]");
        for (int i = 0; i < this.nBrackets; ++i) {
            s.append('=');
        }
        s.append(']');
        int index = cs.indexOf(s.toString());
        if (index > 0) {
            redundant = this.yylength() - index - this.nBrackets - 2;
        }
        return redundant;
    }

    public _LuaLexer(Reader in) {
        this.zzReader = in;
    }

    private static char[] zzUnpackCMap(String packed) {
        int size = 0;
        int length = packed.length();
        for (int i = 0; i < length; i += 2) {
            size += packed.charAt(i);
        }
        char[] map = new char[size];
        int i = 0;
        int j = 0;
        while (i < packed.length()) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                map[j++] = value;
            } while (--count > 0);
        }
        return map;
    }

    public final int getTokenStart() {
        return this.zzStartRead;
    }

    public final int getTokenEnd() {
        return this.getTokenStart() + this.yylength();
    }

    public void reset(CharSequence buffer, int start, int end, int initialState) {
        this.zzBuffer = buffer;
        this.zzMarkedPos = this.zzStartRead = start;
        this.zzCurrentPos = this.zzStartRead;
        this.zzAtEOF = false;
        this.zzAtBOL = true;
        this.zzEndRead = end;
        this.yybegin(initialState);
    }

    private boolean zzRefill() throws IOException {
        return true;
    }

    public final int yystate() {
        return this.zzLexicalState;
    }

    public final void yybegin(int newState) {
        this.zzLexicalState = newState;
    }

    public final CharSequence yytext() {
        return this.zzBuffer.subSequence(this.zzStartRead, this.zzMarkedPos);
    }

    public final char yycharat(int pos) {
        return this.zzBuffer.charAt(this.zzStartRead + pos);
    }

    public final int yylength() {
        return this.zzMarkedPos - this.zzStartRead;
    }

    private void zzScanError(int errorCode) {
        String message2;
        try {
            message2 = ZZ_ERROR_MSG[errorCode];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            message2 = ZZ_ERROR_MSG[0];
        }
        throw new Error(message2);
    }

    public void yypushback(int number) {
        if (number > this.yylength()) {
            this.zzScanError(2);
        }
        this.zzMarkedPos -= number;
    }

    public IElementType advance() throws IOException {
        int zzEndReadL = this.zzEndRead;
        CharSequence zzBufferL = this.zzBuffer;
        int[] zzTransL = ZZ_TRANS;
        int[] zzRowMapL = ZZ_ROWMAP;
        int[] zzAttrL = ZZ_ATTRIBUTE;
        block148: while (true) {
            int zzInput;
            int zzMarkedPosL = this.zzMarkedPos;
            int zzAction = -1;
            this.zzCurrentPos = this.zzStartRead = zzMarkedPosL;
            int zzCurrentPosL = this.zzStartRead;
            this.zzState = ZZ_LEXSTATE[this.zzLexicalState];
            int zzAttributes = zzAttrL[this.zzState];
            if ((zzAttributes & 1) == 1) {
                zzAction = this.zzState;
            }
            while (true) {
                if (zzCurrentPosL < zzEndReadL) {
                    zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL);
                    zzCurrentPosL += Character.charCount(zzInput);
                } else {
                    if (this.zzAtEOF) {
                        zzInput = -1;
                        break;
                    }
                    this.zzCurrentPos = zzCurrentPosL;
                    this.zzMarkedPos = zzMarkedPosL;
                    boolean eof = this.zzRefill();
                    zzCurrentPosL = this.zzCurrentPos;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    zzEndReadL = this.zzEndRead;
                    if (eof) {
                        zzInput = -1;
                        break;
                    }
                    zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL);
                    zzCurrentPosL += Character.charCount(zzInput);
                }
                int zzNext = zzTransL[zzRowMapL[this.zzState] + _LuaLexer.ZZ_CMAP(zzInput)];
                if (zzNext == -1) break;
                this.zzState = zzNext;
                zzAttributes = zzAttrL[this.zzState];
                if ((zzAttributes & 1) != 1) continue;
                zzAction = this.zzState;
                zzMarkedPosL = zzCurrentPosL;
                if ((zzAttributes & 8) == 8) break;
            }
            this.zzMarkedPos = zzMarkedPosL;
            if (zzInput == -1 && this.zzStartRead == this.zzCurrentPos) {
                this.zzAtEOF = true;
                return null;
            }
            switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
                case 1: {
                    this.yybegin(0);
                    return LuaTypes.SHEBANG_CONTENT;
                }
                case 74: {
                    continue block148;
                }
                case 2: {
                    return TokenType.BAD_CHARACTER;
                }
                case 75: {
                    continue block148;
                }
                case 3: {
                    return TokenType.WHITE_SPACE;
                }
                case 76: {
                    continue block148;
                }
                case 4: {
                    return LuaTypes.ID;
                }
                case 77: {
                    continue block148;
                }
                case 5: {
                    return LuaTypes.NUMBER;
                }
                case 78: {
                    continue block148;
                }
                case 6: {
                    return LuaTypes.PLUS;
                }
                case 79: {
                    continue block148;
                }
                case 7: {
                    return LuaTypes.DOT;
                }
                case 80: {
                    continue block148;
                }
                case 8: {
                    return LuaTypes.MINUS;
                }
                case 81: {
                    continue block148;
                }
                case 9: {
                    return LuaTypes.LCURLY;
                }
                case 82: {
                    continue block148;
                }
                case 10: {
                    return LuaTypes.RCURLY;
                }
                case 83: {
                    continue block148;
                }
                case 11: {
                    return LuaTypes.LBRACK;
                }
                case 84: {
                    continue block148;
                }
                case 12: {
                    return LuaTypes.ASSIGN;
                }
                case 85: {
                    continue block148;
                }
                case 13: {
                    return LuaTypes.RBRACK;
                }
                case 86: {
                    continue block148;
                }
                case 14: {
                    this.yybegin(4);
                    this.yypushback(this.yylength());
                }
                case 87: {
                    continue block148;
                }
                case 15: {
                    this.yybegin(6);
                    this.yypushback(this.yylength());
                }
                case 88: {
                    continue block148;
                }
                case 16: {
                    return LuaTypes.GETN;
                }
                case 89: {
                    continue block148;
                }
                case 17: {
                    return LuaTypes.GT;
                }
                case 90: {
                    continue block148;
                }
                case 18: {
                    return LuaTypes.LT;
                }
                case 91: {
                    continue block148;
                }
                case 19: {
                    return LuaTypes.BIT_TILDE;
                }
                case 92: {
                    continue block148;
                }
                case 20: {
                    return LuaTypes.MULT;
                }
                case 93: {
                    continue block148;
                }
                case 21: {
                    return LuaTypes.MOD;
                }
                case 94: {
                    continue block148;
                }
                case 22: {
                    return LuaTypes.DIV;
                }
                case 95: {
                    continue block148;
                }
                case 23: {
                    return LuaTypes.LPAREN;
                }
                case 96: {
                    continue block148;
                }
                case 24: {
                    return LuaTypes.RPAREN;
                }
                case 97: {
                    continue block148;
                }
                case 25: {
                    return LuaTypes.COMMA;
                }
                case 98: {
                    continue block148;
                }
                case 26: {
                    return LuaTypes.SEMI;
                }
                case 99: {
                    continue block148;
                }
                case 27: {
                    return LuaTypes.COLON;
                }
                case 100: {
                    continue block148;
                }
                case 28: {
                    return LuaTypes.EXP;
                }
                case 101: {
                    continue block148;
                }
                case 29: {
                    return LuaTypes.BIT_AND;
                }
                case 102: {
                    continue block148;
                }
                case 30: {
                    return LuaTypes.BIT_OR;
                }
                case 103: {
                    continue block148;
                }
                case 31: {
                    this.yybegin(0);
                    return LuaTypes.STRING;
                }
                case 104: {
                    continue block148;
                }
                case 32: {
                    this.yypushback(this.yylength());
                    this.yybegin(10);
                }
                case 105: {
                    continue block148;
                }
                case 33: {
                    return LuaTypes.CONCAT;
                }
                case 106: {
                    continue block148;
                }
                case 34: {
                    boolean block = this.checkBlock();
                    if (block) {
                        this.yypushback(this.yylength());
                        this.yybegin(12);
                    } else {
                        this.yypushback(this.yylength());
                        this.yybegin(10);
                    }
                }
                case 107: {
                    continue block148;
                }
                case 35: {
                    return LuaTypes.IN;
                }
                case 108: {
                    continue block148;
                }
                case 36: {
                    return LuaTypes.IF;
                }
                case 109: {
                    continue block148;
                }
                case 37: {
                    return LuaTypes.OR;
                }
                case 110: {
                    continue block148;
                }
                case 38: {
                    return LuaTypes.DO;
                }
                case 111: {
                    continue block148;
                }
                case 39: {
                    this.yybegin(8);
                    this.yypushback(this.yylength());
                    this.checkBlock();
                }
                case 112: {
                    continue block148;
                }
                case 40: {
                    return LuaTypes.EQ;
                }
                case 113: {
                    continue block148;
                }
                case 41: {
                    this.yybegin(2);
                    return LuaTypes.SHEBANG;
                }
                case 114: {
                    continue block148;
                }
                case 42: {
                    return LuaTypes.GE;
                }
                case 115: {
                    continue block148;
                }
                case 43: {
                    return LuaTypes.BIT_RTRT;
                }
                case 116: {
                    continue block148;
                }
                case 44: {
                    return LuaTypes.LE;
                }
                case 117: {
                    continue block148;
                }
                case 45: {
                    return LuaTypes.BIT_LTLT;
                }
                case 118: {
                    continue block148;
                }
                case 46: {
                    return LuaTypes.NE;
                }
                case 119: {
                    continue block148;
                }
                case 47: {
                    return LuaTypes.DOUBLE_DIV;
                }
                case 120: {
                    continue block148;
                }
                case 48: {
                    return LuaTypes.DOUBLE_COLON;
                }
                case 121: {
                    continue block148;
                }
                case 49: {
                    this.yybegin(0);
                    return LuaTypes.SHORT_COMMENT;
                }
                case 122: {
                    continue block148;
                }
                case 50: {
                    return LuaTypes.ELLIPSIS;
                }
                case 123: {
                    continue block148;
                }
                case 51: {
                    return LuaTypes.END;
                }
                case 124: {
                    continue block148;
                }
                case 52: {
                    return LuaTypes.NIL;
                }
                case 125: {
                    continue block148;
                }
                case 53: {
                    return LuaTypes.NOT;
                }
                case 126: {
                    continue block148;
                }
                case 54: {
                    return LuaTypes.AND;
                }
                case 127: {
                    continue block148;
                }
                case 55: {
                    return LuaTypes.FOR;
                }
                case 128: {
                    continue block148;
                }
                case 56: {
                    this.yybegin(0);
                    return LuaTypes.DOC_COMMENT;
                }
                case 129: {
                    continue block148;
                }
                case 57: {
                    return LuaTypes.ELSE;
                }
                case 130: {
                    continue block148;
                }
                case 58: {
                    if (this.level.getVersion() < LuaLanguageLevel.LUA52.getVersion()) {
                        return LuaTypes.ID;
                    }
                    return LuaTypes.GOTO;
                }
                case 131: {
                    continue block148;
                }
                case 59: {
                    return LuaTypes.TRUE;
                }
                case 132: {
                    continue block148;
                }
                case 60: {
                    return LuaTypes.THEN;
                }
                case 133: {
                    continue block148;
                }
                case 61: {
                    int redundant = this.checkBlockRedundant();
                    if (redundant != -1) {
                        this.yypushback(redundant);
                        this.yybegin(0);
                        return LuaTypes.STRING;
                    }
                    this.yybegin(0);
                    return TokenType.BAD_CHARACTER;
                }
                case 134: {
                    continue block148;
                }
                case 62: {
                    int redundant = this.checkBlockRedundant();
                    if (redundant != -1) {
                        this.yypushback(redundant);
                        this.yybegin(0);
                        return LuaTypes.BLOCK_COMMENT;
                    }
                    this.yybegin(0);
                    return LuaTypes.BLOCK_COMMENT;
                }
                case 135: {
                    continue block148;
                }
                case 63: {
                    return LuaTypes.REGION;
                }
                case 136: {
                    continue block148;
                }
                case 64: {
                    return LuaTypes.ENDREGION;
                }
                case 137: {
                    continue block148;
                }
                case 65: {
                    return LuaTypes.BREAK;
                }
                case 138: {
                    continue block148;
                }
                case 66: {
                    return LuaTypes.LOCAL;
                }
                case 139: {
                    continue block148;
                }
                case 67: {
                    return LuaTypes.FALSE;
                }
                case 140: {
                    continue block148;
                }
                case 68: {
                    return LuaTypes.UNTIL;
                }
                case 141: {
                    continue block148;
                }
                case 69: {
                    return LuaTypes.WHILE;
                }
                case 142: {
                    continue block148;
                }
                case 70: {
                    return LuaTypes.RETURN;
                }
                case 143: {
                    continue block148;
                }
                case 71: {
                    return LuaTypes.REPEAT;
                }
                case 144: {
                    continue block148;
                }
                case 72: {
                    return LuaTypes.ELSEIF;
                }
                case 145: {
                    continue block148;
                }
                case 73: {
                    return LuaTypes.FUNCTION;
                }
                case 146: {
                    continue block148;
                }
            }
            this.zzScanError(1);
        }
    }
}

