/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.emmylua.lua.errorreporting;

import com.immomo.emmylua.lua.errorreporting.ErrorReportBundle;
import com.immomo.emmylua.lua.errorreporting.Error_reportKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.SubmittedReportInfo;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.Issue;
import org.eclipse.egit.github.core.Label;
import org.eclipse.egit.github.core.RepositoryId;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.eclipse.egit.github.core.client.PageIterator;
import org.eclipse.egit.github.core.service.IssueService;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000bH\u0002J\"\u0010\f\u001a\u0004\u0018\u00010\t2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J$\u0010\u0012\u001a\u00020\u00042\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J!\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000bH\u0000\u00a2\u0006\u0002\b\u0018R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/immomo/emmylua/lua/errorreporting/AnonymousFeedback;", "", "()V", "gitRepo", "", "gitRepoUser", "issueLabel", "tokenFile", "createNewGibHubIssue", "Lorg/eclipse/egit/github/core/Issue;", "details", "", "findFirstDuplicate", "uniqueTitle", "service", "Lorg/eclipse/egit/github/core/service/IssueService;", "repo", "Lorg/eclipse/egit/github/core/RepositoryId;", "generateGitHubIssueBody", "includeStacktrace", "", "sendFeedback", "Lcom/intellij/openapi/diagnostic/SubmittedReportInfo;", "environmentDetails", "sendFeedback$MMPaas", "MMPaas"})
final class AnonymousFeedback {
    private static final String tokenFile = "errorreporting/token.bin";
    private static final String gitRepoUser = "EmmyLLua";
    private static final String gitRepo = "EmmyLua-ErrorReport";
    private static final String issueLabel = "pending";
    public static final AnonymousFeedback INSTANCE;

    @NotNull
    public final SubmittedReportInfo sendFeedback$MMPaas(@NotNull Map<String, String> environmentDetails) {
        Intrinsics.checkParameterIsNotNull(environmentDetails, (String)"environmentDetails");
        Logger logger = Logger.getInstance((String)this.getClass().getName());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(javaClass.name)");
        Logger logger2 = logger;
        try {
            URL resource = this.getClass().getClassLoader().getResource(tokenFile);
            if (resource == null) {
                logger2.info("Could not find token file");
                throw (Throwable)new IOException("Could not decrypt access token");
            }
            String gitAccessToken = Error_reportKt.access$decrypt(resource);
            GitHubClient client = new GitHubClient();
            client.setOAuth2Token(gitAccessToken);
            RepositoryId repoID = new RepositoryId(gitRepoUser, gitRepo);
            IssueService issueService = new IssueService(client);
            Issue newGibHubIssue = this.createNewGibHubIssue(environmentDetails);
            String string = newGibHubIssue.getTitle();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"newGibHubIssue.title");
            Issue duplicate = this.findFirstDuplicate(string, issueService, repoID);
            boolean isNewIssue = true;
            if (duplicate != null) {
                issueService.createComment((IRepositoryIdProvider)repoID, duplicate.getNumber(), this.generateGitHubIssueBody(environmentDetails, false));
                newGibHubIssue = duplicate;
                isNewIssue = false;
            } else {
                Issue issue = issueService.createIssue((IRepositoryIdProvider)repoID, newGibHubIssue);
                Intrinsics.checkExpressionValueIsNotNull((Object)issue, (String)"issueService.createIssue(repoID, newGibHubIssue)");
                newGibHubIssue = issue;
            }
            String string2 = newGibHubIssue.getHtmlUrl();
            String string3 = isNewIssue ? "git.issue.text" : "git.issue.duplicate.text";
            Object[] objectArray = new Object[2];
            String string4 = newGibHubIssue.getHtmlUrl();
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"newGibHubIssue.htmlUrl");
            objectArray[0] = string4;
            objectArray[1] = (long)newGibHubIssue.getNumber();
            return new SubmittedReportInfo(string2, ErrorReportBundle.message$MMPaas(string3, objectArray), isNewIssue ? SubmittedReportInfo.SubmissionStatus.NEW_ISSUE : SubmittedReportInfo.SubmissionStatus.DUPLICATE);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new SubmittedReportInfo(null, ErrorReportBundle.message$MMPaas("report.error.connection.failure", new Object[0]), SubmittedReportInfo.SubmissionStatus.FAILED);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Issue findFirstDuplicate(String uniqueTitle, IssueService service, RepositoryId repo) {
        Object v2;
        block2: {
            void $receiver$iv$iv;
            HashMap searchParameters = new HashMap(2);
            Map map = searchParameters;
            Iterator iterator = "state";
            String string = "open";
            map.put(iterator, string);
            PageIterator pageIterator = service.pageIssues((IRepositoryIdProvider)repo, (Map)searchParameters);
            Intrinsics.checkExpressionValueIsNotNull((Object)pageIterator, (String)"service.pageIssues(repo, searchParameters)");
            Iterable $receiver$iv = (Iterable)pageIterator;
            iterator = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                Collection it = (Collection)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = it;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            for (Object element$iv : $receiver$iv) {
                Issue it = (Issue)element$iv;
                boolean bl = false;
                Issue issue = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)issue, (String)"it");
                if (!Intrinsics.areEqual((Object)issue.getTitle(), (Object)uniqueTitle)) continue;
                v2 = element$iv;
                break block2;
            }
            v2 = null;
        }
        return v2;
    }

    private final Issue createNewGibHubIssue(Map<String, String> details) {
        Object[] objectArray;
        String string;
        String string2;
        Issue $receiver;
        Issue issue;
        block5: {
            block4: {
                $receiver = issue = new Issue();
                boolean bl = false;
                string2 = details.remove("error.message");
                if (string2 == null) break block4;
                String p1 = string = string2;
                boolean bl2 = false;
                CharSequence charSequence = p1;
                string2 = !StringsKt.isBlank((CharSequence)charSequence) ? string : null;
                if (string2 != null) break block5;
            }
            string2 = "Unspecified error";
        }
        String errorMessage = string2;
        string = details.remove("error.hash");
        int n = 0;
        Object[] objectArray2 = objectArray = new Object[2];
        String string3 = "git.issue.title";
        Issue issue2 = $receiver;
        String string4 = string;
        if (string4 == null) {
            string4 = "";
        }
        String string5 = string4;
        objectArray[n] = string5;
        objectArray2[1] = errorMessage;
        issue2.setTitle(ErrorReportBundle.message$MMPaas(string3, objectArray2));
        $receiver.setBody(INSTANCE.generateGitHubIssueBody(details, true));
        string = new Label();
        issue2 = $receiver;
        String $receiver2 = string;
        boolean bl = false;
        $receiver2.setName(issueLabel);
        string3 = string;
        issue2.setLabels(CollectionsKt.listOf((Object)string3));
        return issue;
    }

    private final String generateGitHubIssueBody(Map<String, String> details, boolean includeStacktrace) {
        Object object;
        Object object2;
        Object object3;
        String errorDescription;
        StringBuilder $receiver;
        StringBuilder stringBuilder;
        block8: {
            block7: {
                $receiver = stringBuilder = new StringBuilder();
                boolean bl = false;
                String string = details.remove("error.description");
                String string2 = string;
                if (string2 == null) {
                    string2 = errorDescription = "";
                }
                if ((object3 = details.remove("error.stacktrace")) == null) break block7;
                object2 = object3;
                String p1 = object2;
                boolean bl2 = false;
                CharSequence charSequence = p1;
                object3 = !StringsKt.isBlank((CharSequence)charSequence) ? object2 : null;
                if (object3 != null) break block8;
            }
            object3 = "invalid stacktrace";
        }
        String stackTrace = object3;
        object2 = errorDescription;
        if (object2.length() > 0) {
            StringBuilder stringBuilder2 = $receiver.append(errorDescription);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder2, (String)"append(errorDescription)");
            object2 = stringBuilder2;
            object = "\n\n----------------------\n";
            StringBuilder stringBuilder3 = ((StringBuilder)object2).append((String)object);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder3, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder3);
        }
        Map<String, String> bl2 = details;
        object = bl2.entrySet().iterator();
        while (object.hasNext()) {
            Object object4 = object2 = (Map.Entry)object.next();
            String key = (String)object4.getKey();
            object4 = object2;
            String value = (String)object4.getValue();
            StringBuilder stringBuilder4 = $receiver.append("- ").append(key).append(": ");
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder4, (String)"append(\"- \").append(key).append(\": \")");
            object4 = stringBuilder4;
            StringBuilder stringBuilder5 = ((StringBuilder)object4).append(value);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder5, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder5);
        }
        if (includeStacktrace) {
            object2 = $receiver;
            object = "\n```";
            StringBuilder stringBuilder6 = ((StringBuilder)object2).append((String)object);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder6, (String)"append(value)");
            object2 = StringsKt.appendln((StringBuilder)stringBuilder6);
            StringBuilder stringBuilder7 = ((StringBuilder)object2).append(stackTrace);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder7, (String)"append(value)");
            object2 = StringsKt.appendln((StringBuilder)stringBuilder7);
            object = "```";
            StringBuilder stringBuilder8 = ((StringBuilder)object2).append((String)object);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder8, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder8);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    private AnonymousFeedback() {
    }

    static {
        AnonymousFeedback anonymousFeedback;
        INSTANCE = anonymousFeedback = new AnonymousFeedback();
    }
}

