/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.emmylua.lua.editor.surroundWith;

import com.immomo.emmylua.lua.editor.surroundWith.RegionSurrounder;
import com.immomo.emmylua.lua.lang.LuaLanguage;
import com.immomo.emmylua.lua.psi.LuaStatement;
import com.intellij.lang.Language;
import com.intellij.lang.surroundWith.SurroundDescriptor;
import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J+\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0002\u0010\u000eJ+\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u00042\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\u000eJ\u0013\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0016\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u0017"}, d2={"Lcom/immomo/emmylua/lua/editor/surroundWith/LuaSurroundDescriptor;", "Lcom/intellij/lang/surroundWith/SurroundDescriptor;", "()V", "surrounders", "", "Lcom/intellij/lang/surroundWith/Surrounder;", "[Lcom/intellij/lang/surroundWith/Surrounder;", "findStatementsInRange", "Lcom/intellij/psi/PsiElement;", "file", "Lcom/intellij/psi/PsiFile;", "start", "", "end", "(Lcom/intellij/psi/PsiFile;II)[Lcom/intellij/psi/PsiElement;", "getElementsToSurround", "psiFile", "startOffset", "endOffset", "getSurrounders", "()[Lcom/intellij/lang/surroundWith/Surrounder;", "isExclusive", "", "MMPaas"})
public final class LuaSurroundDescriptor
implements SurroundDescriptor {
    private final Surrounder[] surrounders = new Surrounder[]{new RegionSurrounder("Lua Region --region", "region", "endregion"), new RegionSurrounder("Lua Region --{{{", "{{{", "}}}")};

    @NotNull
    public PsiElement[] getElementsToSurround(@NotNull PsiFile psiFile, int startOffset, int endOffset) {
        Intrinsics.checkParameterIsNotNull((Object)psiFile, (String)"psiFile");
        return this.findStatementsInRange(psiFile, startOffset, endOffset);
    }

    private final PsiElement[] findStatementsInRange(PsiFile file, int start, int end) {
        int startOffset = start;
        int endOffset = end;
        PsiElement element1 = file.getViewProvider().findElementAt(startOffset, (Language)LuaLanguage.INSTANCE);
        PsiElement element2 = file.getViewProvider().findElementAt(endOffset - 1, (Language)LuaLanguage.INSTANCE);
        if (element1 instanceof PsiWhiteSpace) {
            TextRange textRange = ((PsiWhiteSpace)element1).getTextRange();
            Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"element1.textRange");
            startOffset = textRange.getEndOffset();
            element1 = file.findElementAt(startOffset);
        }
        if (element2 instanceof PsiWhiteSpace) {
            TextRange textRange = ((PsiWhiteSpace)element2).getTextRange();
            Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"element2.textRange");
            endOffset = textRange.getStartOffset();
            element2 = file.findElementAt(endOffset - 1);
        }
        if (element1 == null || element2 == null) {
            Intrinsics.checkExpressionValueIsNotNull((Object)PsiElement.EMPTY_ARRAY, (String)"PsiElement.EMPTY_ARRAY");
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement psiElement = PsiTreeUtil.findCommonParent((PsiElement)element1, (PsiElement)element2);
        if (psiElement == null) {
            Intrinsics.checkExpressionValueIsNotNull((Object)PsiElement.EMPTY_ARRAY, (String)"PsiElement.EMPTY_ARRAY");
            return PsiElement.EMPTY_ARRAY;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"PsiTreeUtil.findCommonPa\u2026rn PsiElement.EMPTY_ARRAY");
        PsiElement parent = psiElement;
        while (true) {
            if (parent instanceof LuaStatement) {
                if (element1 instanceof PsiComment) break;
                PsiElement psiElement2 = ((LuaStatement)parent).getParent();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"parent.parent");
                parent = psiElement2;
                break;
            }
            if (parent instanceof PsiFile) break;
            Intrinsics.checkExpressionValueIsNotNull((Object)parent.getParent(), (String)"parent.parent");
        }
        if (Intrinsics.areEqual((Object)parent, (Object)element1) ^ true) {
            while (true) {
                PsiElement psiElement3 = element1;
                if (psiElement3 == null) {
                    Intrinsics.throwNpe();
                }
                if (!(Intrinsics.areEqual((Object)parent, (Object)psiElement3.getParent()) ^ true)) break;
                element1 = element1.getParent();
            }
        }
        if (Intrinsics.areEqual((Object)parent, (Object)element2) ^ true) {
            while (true) {
                PsiElement psiElement4 = element2;
                if (psiElement4 == null) {
                    Intrinsics.throwNpe();
                }
                if (!(Intrinsics.areEqual((Object)parent, (Object)psiElement4.getParent()) ^ true)) break;
                element2 = element2.getParent();
            }
        }
        PsiElement[] psiElementArray = parent.getChildren();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElementArray, (String)"parent.children");
        PsiElement[] children = psiElementArray;
        ArrayList<PsiElement> array = new ArrayList<PsiElement>();
        boolean flag = false;
        for (PsiElement child : children) {
            if (Intrinsics.areEqual((Object)child, (Object)element1)) {
                flag = true;
            }
            if (flag && !(child instanceof PsiWhiteSpace)) {
                array.add(child);
            }
            if (Intrinsics.areEqual((Object)child, (Object)element2)) break;
        }
        for (PsiElement element : array) {
            if (element instanceof LuaStatement || element instanceof PsiWhiteSpace || element instanceof PsiComment) continue;
            Intrinsics.checkExpressionValueIsNotNull((Object)PsiElement.EMPTY_ARRAY, (String)"PsiElement.EMPTY_ARRAY");
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement[] psiElementArray2 = PsiUtilCore.toPsiElementArray((Collection)array);
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElementArray2, (String)"PsiUtilCore.toPsiElementArray(array)");
        return psiElementArray2;
    }

    @NotNull
    public Surrounder[] getSurrounders() {
        return this.surrounders;
    }

    public boolean isExclusive() {
        return false;
    }
}

