/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.emmylua.lua.editor.completion;

import com.immomo.emmylua.lua.editor.completion.CompletionSession;
import com.immomo.emmylua.lua.editor.completion.LuaCompletionProvider;
import com.immomo.emmylua.lua.lang.LuaFileType;
import com.immomo.emmylua.lua.lang.LuaIcons;
import com.immomo.emmylua.lua.lang.type.LuaString;
import com.immomo.emmylua.lua.project.LLuaSourceRootManager;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00142\u00020\u0001:\u0002\u0014\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J5\u0010\u0003\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a8\u0006\u0016"}, d2={"Lcom/immomo/emmylua/lua/editor/completion/RequirePathCompletionProvider;", "Lcom/immomo/emmylua/lua/editor/completion/LuaCompletionProvider;", "()V", "addAllFiles", "", "completionParameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "completionResultSet", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "project", "Lcom/intellij/openapi/project/Project;", "pck", "", "children", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/codeInsight/completion/CompletionResultSet;Ljava/lang/String;[Lcom/intellij/openapi/vfs/VirtualFile;)V", "addCompletions", "session", "Lcom/immomo/emmylua/lua/editor/completion/CompletionSession;", "Companion", "FullPackageInsertHandler", "MMPaas"})
public final class RequirePathCompletionProvider
extends LuaCompletionProvider {
    private static final char PATH_SPLITTER = '.';
    public static final Companion Companion = new Companion(null);

    @Override
    public void addCompletions(@NotNull CompletionSession session) {
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        CompletionParameters completionParameters = session.getParameters();
        CompletionResultSet completionResultSet = session.getResultSet();
        PsiFile psiFile = completionParameters.getOriginalFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"completionParameters.originalFile");
        PsiFile file = psiFile;
        PsiElement cur2 = file.findElementAt(completionParameters.getOffset() - 1);
        if (cur2 != null) {
            String string = cur2.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"cur.text");
            LuaString ls = LuaString.Companion.getContent(string);
            String content = StringsKt.replace$default((String)ls.getValue(), (char)'/', (char)'.', (boolean)false, (int)4, null);
            CompletionResultSet completionResultSet2 = completionResultSet.withPrefixMatcher(content);
            Intrinsics.checkExpressionValueIsNotNull((Object)completionResultSet2, (String)"completionResultSet.withPrefixMatcher(content)");
            CompletionResultSet resultSet = completionResultSet2;
            this.addAllFiles(completionParameters, resultSet);
        }
        completionResultSet.stopHere();
    }

    private final void addAllFiles(CompletionParameters completionParameters, CompletionResultSet completionResultSet) {
        PsiFile psiFile = completionParameters.getOriginalFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"completionParameters.originalFile");
        Project project = psiFile.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"completionParameters.originalFile.project");
        Project project2 = project;
        List<VirtualFile> sourceRoots = LLuaSourceRootManager.Companion.getInstance(project2).getSourceRoots();
        for (VirtualFile sourceRoot : sourceRoots) {
            VirtualFile[] virtualFileArray = sourceRoot.getChildren();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFileArray, (String)"sourceRoot.children");
            this.addAllFiles(project2, completionResultSet, null, virtualFileArray);
        }
    }

    private final void addAllFiles(Project project, CompletionResultSet completionResultSet, String pck, VirtualFile[] children) {
        for (VirtualFile child : children) {
            String fileName;
            String newPath;
            if (!LLuaSourceRootManager.Companion.getInstance(project).isInSource(child)) continue;
            Intrinsics.checkExpressionValueIsNotNull((Object)FileUtil.getNameWithoutExtension((String)child.getName()), (String)"FileUtil.getNameWithoutExtension(child.name)");
            String string = newPath = pck == null ? fileName : pck + '.' + fileName;
            if (child.isDirectory()) {
                VirtualFile[] virtualFileArray = child.getChildren();
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFileArray, (String)"child.children");
                this.addAllFiles(project, completionResultSet, newPath, virtualFileArray);
                continue;
            }
            if (child.getFileType() != LuaFileType.INSTANCE) continue;
            LookupElementBuilder lookupElement = LookupElementBuilder.create((String)newPath).withIcon(LuaIcons.FILE).withInsertHandler((InsertHandler)new FullPackageInsertHandler());
            completionResultSet.addElement(PrioritizedLookupElement.withPriority((LookupElement)((LookupElement)lookupElement), (double)1.0));
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Lcom/immomo/emmylua/lua/editor/completion/RequirePathCompletionProvider$FullPackageInsertHandler;", "Lcom/intellij/codeInsight/completion/InsertHandler;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "()V", "handleInsert", "", "insertionContext", "Lcom/intellij/codeInsight/completion/InsertionContext;", "lookupElement", "MMPaas"})
    public static final class FullPackageInsertHandler
    implements InsertHandler<LookupElement> {
        public void handleInsert(@NotNull InsertionContext insertionContext, @NotNull LookupElement lookupElement) {
            Intrinsics.checkParameterIsNotNull((Object)insertionContext, (String)"insertionContext");
            Intrinsics.checkParameterIsNotNull((Object)lookupElement, (String)"lookupElement");
            int tailOffset = insertionContext.getTailOffset();
            PsiElement cur2 = insertionContext.getFile().findElementAt(tailOffset);
            if (cur2 != null) {
                int start = cur2.getTextOffset();
                String string = cur2.getText();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"cur.text");
                LuaString ls = LuaString.Companion.getContent(string);
                insertionContext.getDocument().deleteString(start + ls.getStart(), start + ls.getEnd());
                String string2 = lookupElement.getLookupString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"lookupElement.lookupString");
                String lookupString = string2;
                insertionContext.getDocument().insertString(start + ls.getStart(), (CharSequence)lookupString);
                Editor editor = insertionContext.getEditor();
                Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"insertionContext.editor");
                editor.getCaretModel().moveToOffset(start + ls.getStart() + lookupString.length());
            }
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/immomo/emmylua/lua/editor/completion/RequirePathCompletionProvider$Companion;", "", "()V", "PATH_SPLITTER", "", "MMPaas"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

