/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.emmylua.lua.editor.completion;

import com.immomo.emmylua.lua.editor.completion.ClassMemberCompletionProvider;
import com.immomo.emmylua.lua.editor.completion.CompletionSession;
import com.immomo.emmylua.lua.editor.completion.LocalAndGlobalCompletionProvider;
import com.immomo.emmylua.lua.editor.completion.LuaStringArgHistoryProvider;
import com.immomo.emmylua.lua.editor.completion.OverrideCompletionProvider;
import com.immomo.emmylua.lua.editor.completion.RequirePathCompletionProvider;
import com.immomo.emmylua.lua.editor.completion.SuggestLocalNameProvider;
import com.immomo.emmylua.lua.editor.completion.SuggestSelfMemberProvider;
import com.immomo.emmylua.lua.editor.completion.TableCompletionProvider;
import com.immomo.emmylua.lua.lang.LuaIcons;
import com.immomo.emmylua.lua.lang.LuaLanguage;
import com.immomo.emmylua.lua.project.LLuaSettings;
import com.immomo.emmylua.lua.psi.LuaArgs;
import com.immomo.emmylua.lua.psi.LuaClassMethodDef;
import com.immomo.emmylua.lua.psi.LuaClassMethodName;
import com.immomo.emmylua.lua.psi.LuaGotoStat;
import com.immomo.emmylua.lua.psi.LuaIndexExpr;
import com.immomo.emmylua.lua.psi.LuaLabelStat;
import com.immomo.emmylua.lua.psi.LuaNameDef;
import com.immomo.emmylua.lua.psi.LuaNameExpr;
import com.immomo.emmylua.lua.psi.LuaPsiFile;
import com.immomo.emmylua.lua.psi.LuaPsiTreeUtil;
import com.immomo.emmylua.lua.psi.LuaTableField;
import com.immomo.emmylua.lua.psi.LuaTypes;
import com.immomo.emmylua.lua.refactoring.LuaRefactoringUtil;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.cacheBuilder.WordOccurrence;
import com.intellij.lang.cacheBuilder.WordsScanner;
import com.intellij.lang.findUsages.FindUsagesProvider;
import com.intellij.lang.findUsages.LanguageFindUsages;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.ObjectPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.TreeElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/immomo/emmylua/lua/editor/completion/LuaCompletionContributor;", "Lcom/intellij/codeInsight/completion/CompletionContributor;", "()V", "suggestWords", "", "beforeCompletion", "", "context", "Lcom/intellij/codeInsight/completion/CompletionInitializationContext;", "fillCompletionVariants", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "Companion", "MMPaas"})
public final class LuaCompletionContributor
extends CompletionContributor {
    private boolean suggestWords = true;
    private static final TokenSet IGNORE_SET;
    private static final PsiElementPattern.Capture<PsiElement> SHOW_CLASS_FIELD;
    private static final PsiElementPattern.Capture<PsiElement> IN_FUNC_NAME;
    private static final PsiElementPattern.Capture<PsiElement> AFTER_FUNCTION;
    private static final PsiElementPattern.Capture<PsiElement> IN_CLASS_METHOD_NAME;
    private static final PsiElementPattern.Capture<PsiElement> IN_NAME_EXPR;
    private static final PsiElementPattern.Capture<PsiElement> SHOW_OVERRIDE;
    private static final PsiElementPattern.Capture<PsiElement> IN_CLASS_METHOD;
    private static final PsiElementPattern.Capture<PsiElement> SHOW_REQUIRE_PATH;
    private static final PsiElementPattern.Capture<PsiElement> GOTO;
    private static final PsiElementPattern.Capture<PsiElement> IN_TABLE_FIELD;
    public static final Companion Companion;

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
        CompletionSession session = new CompletionSession(parameters, result);
        parameters.getEditor().putUserData(CompletionSession.Companion.getKEY(), (Object)session);
        super.fillCompletionVariants(parameters, result);
        if (LLuaSettings.Companion.getInstance().isShowWordsInFile() && this.suggestWords && session.isSuggestWords() && !result.isStopped()) {
            LuaCompletionContributor.Companion.suggestWordsInFile(parameters);
        }
    }

    public void beforeCompletion(@NotNull CompletionInitializationContext context2) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        this.suggestWords = true;
        PsiFile psiFile = context2.getFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"context.file");
        PsiFile file = psiFile;
        if (file instanceof LuaPsiFile) {
            Caret caret = context2.getCaret();
            Intrinsics.checkExpressionValueIsNotNull((Object)caret, (String)"context.caret");
            PsiElement element = file.findElementAt(caret.getOffset() - 1);
            if (element != null) {
                if (element.getParent() instanceof LuaLabelStat) {
                    this.suggestWords = false;
                    context2.setDummyIdentifier("");
                } else {
                    IElementType type2;
                    ASTNode aSTNode = element.getNode();
                    Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"element.node");
                    IElementType iElementType = aSTNode.getElementType();
                    Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"element.node.elementType");
                    IElementType iElementType2 = type2 = iElementType;
                    if (IGNORE_SET.contains(iElementType2)) {
                        this.suggestWords = false;
                        context2.setDummyIdentifier("");
                    }
                }
            }
        }
    }

    public LuaCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)SHOW_OVERRIDE, new OverrideCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)IN_CLASS_METHOD, new SuggestSelfMemberProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)SHOW_CLASS_FIELD, new ClassMemberCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)SHOW_REQUIRE_PATH, new RequirePathCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)LuaStringArgHistoryProvider.Companion.getSTRING_ARG(), new LuaStringArgHistoryProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)IN_NAME_EXPR, new LocalAndGlobalCompletionProvider(LocalAndGlobalCompletionProvider.Companion.getALL()));
        this.extend(CompletionType.BASIC, (ElementPattern)IN_CLASS_METHOD_NAME, new LocalAndGlobalCompletionProvider(LocalAndGlobalCompletionProvider.Companion.getVARS()));
        this.extend(CompletionType.BASIC, (ElementPattern)GOTO, (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context2, @NotNull CompletionResultSet resultSet) {
                Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
                Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
                Intrinsics.checkParameterIsNotNull((Object)resultSet, (String)"resultSet");
                LuaPsiTreeUtil.walkUpLabel(parameters.getPosition(), (Processor<LuaLabelStat>)((Processor)new Processor<LuaLabelStat>(resultSet){
                    final /* synthetic */ CompletionResultSet $resultSet;

                    public final boolean process(LuaLabelStat it) {
                        LuaLabelStat luaLabelStat = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)luaLabelStat, (String)"it");
                        String name = luaLabelStat.getName();
                        if (name != null) {
                            this.$resultSet.addElement((LookupElement)LookupElementBuilder.create((String)name).withIcon(AllIcons.Actions.Rollback));
                        }
                        return true;
                    }
                    {
                        this.$resultSet = completionResultSet;
                    }
                }));
                resultSet.stopHere();
            }
        });
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement((IElementType)LuaTypes.ID).withParent(LuaNameDef.class), new SuggestLocalNameProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)IN_TABLE_FIELD, new TableCompletionProvider());
    }

    static {
        Companion = new Companion(null);
        TokenSet tokenSet = TokenSet.create((IElementType[])new IElementType[]{LuaTypes.STRING, LuaTypes.NUMBER, LuaTypes.CONCAT});
        Intrinsics.checkExpressionValueIsNotNull((Object)tokenSet, (String)"TokenSet.create(LuaTypes\u2026.NUMBER, LuaTypes.CONCAT)");
        IGNORE_SET = tokenSet;
        SHOW_CLASS_FIELD = (PsiElementPattern.Capture)PlatformPatterns.psiElement((IElementType)LuaTypes.ID).withParent(LuaIndexExpr.class);
        IN_FUNC_NAME = (PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement((IElementType)LuaTypes.ID).withParent(LuaIndexExpr.class)).inside(LuaClassMethodName.class);
        PsiElementPattern psiElementPattern = PlatformPatterns.psiElement().afterLeaf((ElementPattern)PlatformPatterns.psiElement((IElementType)LuaTypes.FUNCTION));
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElementPattern, (String)"psiElement()\n           \u2026ement(LuaTypes.FUNCTION))");
        AFTER_FUNCTION = (PsiElementPattern.Capture)psiElementPattern;
        ObjectPattern objectPattern = PlatformPatterns.psiElement().andOr(new ElementPattern[]{(ElementPattern)IN_FUNC_NAME, (ElementPattern)AFTER_FUNCTION});
        Intrinsics.checkExpressionValueIsNotNull((Object)objectPattern, (String)"psiElement().andOr(IN_FUNC_NAME, AFTER_FUNCTION)");
        IN_CLASS_METHOD_NAME = (PsiElementPattern.Capture)objectPattern;
        IN_NAME_EXPR = (PsiElementPattern.Capture)PlatformPatterns.psiElement((IElementType)LuaTypes.ID).withParent(LuaNameExpr.class);
        SHOW_OVERRIDE = (PsiElementPattern.Capture)PlatformPatterns.psiElement().withParent(LuaClassMethodName.class);
        IN_CLASS_METHOD = (PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement((IElementType)LuaTypes.ID).withParent(LuaNameExpr.class)).inside(LuaClassMethodDef.class);
        TreeElementPattern treeElementPattern = PlatformPatterns.psiElement((IElementType)LuaTypes.STRING).withParent((ElementPattern)PlatformPatterns.psiElement((IElementType)LuaTypes.LITERAL_EXPR).withParent((ElementPattern)PlatformPatterns.psiElement(LuaArgs.class).afterSibling((ElementPattern)PlatformPatterns.psiElement().withName("require"))));
        Intrinsics.checkExpressionValueIsNotNull((Object)treeElementPattern, (String)"psiElement(LuaTypes.STRI\u2026      )\n                )");
        SHOW_REQUIRE_PATH = (PsiElementPattern.Capture)treeElementPattern;
        GOTO = (PsiElementPattern.Capture)PlatformPatterns.psiElement((IElementType)LuaTypes.ID).withParent(LuaGotoStat.class);
        ObjectPattern objectPattern2 = PlatformPatterns.psiElement().andOr(new ElementPattern[]{(ElementPattern)PlatformPatterns.psiElement().withParent((ElementPattern)PlatformPatterns.psiElement((IElementType)LuaTypes.NAME_EXPR).withParent(LuaTableField.class)), (ElementPattern)PlatformPatterns.psiElement((IElementType)LuaTypes.ID).withParent(LuaTableField.class)});
        Intrinsics.checkExpressionValueIsNotNull((Object)objectPattern2, (String)"psiElement().andOr(\n    \u2026ld::class.java)\n        )");
        IN_TABLE_FIELD = (PsiElementPattern.Capture)objectPattern2;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u001c\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0007\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\n\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\f\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\r\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u000f\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0010\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0011\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/immomo/emmylua/lua/editor/completion/LuaCompletionContributor$Companion;", "", "()V", "AFTER_FUNCTION", "Lcom/intellij/patterns/PsiElementPattern$Capture;", "Lcom/intellij/psi/PsiElement;", "kotlin.jvm.PlatformType", "GOTO", "IGNORE_SET", "Lcom/intellij/psi/tree/TokenSet;", "IN_CLASS_METHOD", "IN_CLASS_METHOD_NAME", "IN_FUNC_NAME", "IN_NAME_EXPR", "IN_TABLE_FIELD", "SHOW_CLASS_FIELD", "SHOW_OVERRIDE", "SHOW_REQUIRE_PATH", "suggestWordsInFile", "", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "MMPaas"})
    public static final class Companion {
        private final void suggestWordsInFile(CompletionParameters parameters) {
            block1: {
                WordsScanner wordsScanner;
                CompletionSession session = CompletionSession.Companion.get(parameters);
                PsiElement originalPosition = parameters.getOriginalPosition();
                if (originalPosition != null) {
                    String string = originalPosition.getText();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"originalPosition.text");
                    session.addWord(string);
                }
                Object object = LanguageFindUsages.INSTANCE.forLanguage((Language)LuaLanguage.INSTANCE);
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"LanguageFindUsages.INSTA\u2026age(LuaLanguage.INSTANCE)");
                WordsScanner wordsScanner2 = wordsScanner = ((FindUsagesProvider)object).getWordsScanner();
                if (wordsScanner2 == null) break block1;
                Editor editor = parameters.getEditor();
                Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"parameters.editor");
                Document document = editor.getDocument();
                Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"parameters.editor.document");
                wordsScanner2.processWords(document.getCharsSequence(), (Processor)new Processor<WordOccurrence>(session){
                    final /* synthetic */ CompletionSession $session;

                    public final boolean process(WordOccurrence it) {
                        WordOccurrence wordOccurrence = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)wordOccurrence, (String)"it");
                        String word = ((Object)wordOccurrence.getBaseText().subSequence(it.getStart(), it.getEnd())).toString();
                        if (word.length() > 2 && LuaRefactoringUtil.INSTANCE.isLuaIdentifier(word) && this.$session.addWord(word)) {
                            this.$session.getResultSet().addElement(PrioritizedLookupElement.withPriority((LookupElement)((LookupElement)LookupElementBuilder.create((String)word).withIcon(LuaIcons.WORD)), (double)-1.0));
                        }
                        return true;
                    }
                    {
                        this.$session = completionSession;
                    }
                });
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

