/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.emmylua.lua.editor.completion;

import com.immomo.emmylua.lua.project.LLuaSettings;
import com.immomo.emmylua.lua.psi.LuaExpr;
import com.immomo.emmylua.lua.psi.LuaParamInfo;
import com.immomo.emmylua.lua.psi.LuaTypes;
import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.TextExpression;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0014J#\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0014\u00a2\u0006\u0002\u0010\u001aJ\u001a\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\nH\u0002J\u0013\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H$\u00a2\u0006\u0002\u0010!J\u0018\u0010\"\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020\u0002H\u0016J\u000e\u0010$\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nR\u0014\u0010\u0004\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/immomo/emmylua/lua/editor/completion/ArgsInsertHandler;", "Lcom/intellij/codeInsight/completion/InsertHandler;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "()V", "autoInsertParameters", "", "getAutoInsertParameters", "()Z", "isVarargs", "mask", "", "appendSignature", "", "insertionContext", "Lcom/intellij/codeInsight/completion/InsertionContext;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "createTemplate", "Lcom/intellij/codeInsight/template/Template;", "manager", "Lcom/intellij/codeInsight/template/TemplateManager;", "paramNameDefList", "", "Lcom/immomo/emmylua/lua/psi/LuaParamInfo;", "(Lcom/intellij/codeInsight/template/TemplateManager;[Lcom/immomo/emmylua/lua/psi/LuaParamInfo;)Lcom/intellij/codeInsight/template/Template;", "findWarpExpr", "Lcom/immomo/emmylua/lua/psi/LuaExpr;", "file", "Lcom/intellij/psi/PsiFile;", "offset", "getParams", "()[Lcom/immomo/emmylua/lua/psi/LuaParamInfo;", "handleInsert", "lookupElement", "withMask", "MMPaas"})
public abstract class ArgsInsertHandler
implements InsertHandler<LookupElement> {
    private final boolean isVarargs = false;
    private final boolean autoInsertParameters = LLuaSettings.Companion.getInstance().getAutoInsertParameters();
    private int mask = -1;

    @NotNull
    protected abstract LuaParamInfo[] getParams();

    protected boolean isVarargs() {
        return this.isVarargs;
    }

    protected boolean getAutoInsertParameters() {
        return this.autoInsertParameters;
    }

    @NotNull
    public final ArgsInsertHandler withMask(int mask) {
        this.mask = mask;
        return this;
    }

    public void handleInsert(@NotNull InsertionContext insertionContext, @NotNull LookupElement lookupElement) {
        Intrinsics.checkParameterIsNotNull((Object)insertionContext, (String)"insertionContext");
        Intrinsics.checkParameterIsNotNull((Object)lookupElement, (String)"lookupElement");
        int startOffset = insertionContext.getStartOffset();
        PsiElement element = insertionContext.getFile().findElementAt(startOffset);
        Editor editor = insertionContext.getEditor();
        Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"insertionContext.editor");
        Editor editor2 = editor;
        boolean needAppendPar = true;
        if (element != null) {
            Editor editor3 = editor2;
            if (editor3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
            }
            EditorEx ex = (EditorEx)editor3;
            HighlighterIterator highlighterIterator = ex.getHighlighter().createIterator(startOffset);
            Intrinsics.checkExpressionValueIsNotNull((Object)highlighterIterator, (String)"ex.highlighter.createIterator(startOffset)");
            HighlighterIterator iterator = highlighterIterator;
            int prevIteratorEnd = iterator.getEnd();
            iterator.advance();
            if (!iterator.atEnd()) {
                IElementType tokenType = iterator.getTokenType();
                while (tokenType == TokenType.WHITE_SPACE) {
                    iterator.advance();
                    if (iterator.atEnd()) break;
                    prevIteratorEnd = iterator.getEnd();
                    tokenType = iterator.getTokenType();
                }
                if (tokenType == LuaTypes.LPAREN) {
                    boolean bl = needAppendPar = prevIteratorEnd != insertionContext.getTailOffset();
                }
            }
        }
        if (needAppendPar) {
            PsiFile psiFile = insertionContext.getFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"insertionContext.file");
            LuaExpr expr = this.findWarpExpr(psiFile, startOffset);
            if (expr != null) {
                ASTNode exprNode;
                ASTNode aSTNode = exprNode = expr.getNode();
                Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"exprNode");
                int endOffset = aSTNode.getStartOffset() + exprNode.getTextLength();
                if (endOffset > insertionContext.getSelectionEndOffset()) {
                    editor2.getDocument().insertString(insertionContext.getSelectionEndOffset(), (CharSequence)"(");
                    editor2.getDocument().insertString(endOffset + 1, (CharSequence)")");
                    editor2.getCaretModel().moveToOffset(endOffset + 2);
                    return;
                }
            }
            this.appendSignature(insertionContext, editor2, element);
        }
    }

    protected void appendSignature(@NotNull InsertionContext insertionContext, @NotNull Editor editor, @Nullable PsiElement element) {
        Intrinsics.checkParameterIsNotNull((Object)insertionContext, (String)"insertionContext");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        if (this.getAutoInsertParameters()) {
            TemplateManager manager;
            LuaParamInfo[] paramNameDefList = this.getParams();
            TemplateManager templateManager = manager = TemplateManager.getInstance((Project)insertionContext.getProject());
            Intrinsics.checkExpressionValueIsNotNull((Object)templateManager, (String)"manager");
            Template template = this.createTemplate(templateManager, paramNameDefList);
            editor.getCaretModel().moveToOffset(insertionContext.getSelectionEndOffset());
            manager.startTemplate(editor, template);
        } else {
            editor.getDocument().insertString(insertionContext.getSelectionEndOffset(), (CharSequence)"()");
            LuaParamInfo[] luaParamInfoArray = this.getParams();
            if (luaParamInfoArray.length == 0 && !this.isVarargs()) {
                editor.getCaretModel().moveToOffset(insertionContext.getSelectionEndOffset());
            } else {
                editor.getCaretModel().moveToOffset(insertionContext.getSelectionEndOffset() - 1);
                AutoPopupController.getInstance((Project)insertionContext.getProject()).autoPopupParameterInfo(editor, element);
            }
        }
    }

    private final LuaExpr findWarpExpr(PsiFile file, int offset) {
        PsiElement parent;
        LuaExpr expr = (LuaExpr)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)offset, LuaExpr.class, (boolean)true);
        while (expr != null && (parent = expr.getParent()) instanceof LuaExpr) {
            ASTNode aSTNode = ((LuaExpr)parent).getNode();
            Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"parent.node");
            if (aSTNode.getStartOffset() != offset) break;
            expr = (LuaExpr)parent;
        }
        return expr;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected Template createTemplate(@NotNull TemplateManager manager, @NotNull LuaParamInfo[] paramNameDefList) {
        Intrinsics.checkParameterIsNotNull((Object)manager, (String)"manager");
        Intrinsics.checkParameterIsNotNull((Object)paramNameDefList, (String)"paramNameDefList");
        Template template = manager.createTemplate("", "");
        template.addTextSegment("(");
        boolean isFirst = true;
        int n = 0;
        int n2 = paramNameDefList.length;
        while (n < n2) {
            void i;
            if ((this.mask & 1 << i) != 0) {
                LuaParamInfo paramNameDef = paramNameDefList[i];
                if (!isFirst) {
                    template.addTextSegment(", ");
                }
                template.addVariable(paramNameDef.getName(), (Expression)new TextExpression(paramNameDef.getName()), (Expression)new TextExpression(paramNameDef.getName()), true);
                isFirst = false;
            }
            ++i;
        }
        template.addTextSegment(")");
        Template template2 = template;
        Intrinsics.checkExpressionValueIsNotNull((Object)template2, (String)"template");
        return template2;
    }
}

