/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.emmylua.lua.editor;

import com.immomo.emmylua.lua.lang.LuaLanguage;
import com.immomo.emmylua.lua.psi.LuaBlock;
import com.immomo.emmylua.lua.psi.LuaIndentRange;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.CharArrayUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JF\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/immomo/emmylua/lua/editor/LuaEnterBetweenRangeBlockHandler;", "Lcom/intellij/codeInsight/editorActions/enter/EnterHandlerDelegateAdapter;", "()V", "preprocessEnter", "Lcom/intellij/codeInsight/editorActions/enter/EnterHandlerDelegate$Result;", "psiFile", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "caretOffsetRef", "Lcom/intellij/openapi/util/Ref;", "", "caretAdvance", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "originalHandler", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "MMPaas"})
public final class LuaEnterBetweenRangeBlockHandler
extends EnterHandlerDelegateAdapter {
    @NotNull
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile psiFile, @NotNull Editor editor, @NotNull Ref<Integer> caretOffsetRef, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, @Nullable EditorActionHandler originalHandler) {
        Intrinsics.checkParameterIsNotNull((Object)psiFile, (String)"psiFile");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull(caretOffsetRef, (String)"caretOffsetRef");
        Intrinsics.checkParameterIsNotNull(caretAdvance, (String)"caretAdvance");
        Intrinsics.checkParameterIsNotNull((Object)dataContext, (String)"dataContext");
        if (!psiFile.getLanguage().is((Language)LuaLanguage.INSTANCE)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        Integer caretOffset = (Integer)caretOffsetRef.get();
        Document document = editor.getDocument();
        Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"editor.document");
        Document document2 = document;
        CharSequence charSequence = document2.getCharsSequence();
        Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"document.charsSequence");
        CharSequence text = charSequence;
        int prevCharOffset = CharArrayUtil.shiftBackward((CharSequence)text, (int)(caretOffset - 1), (String)" \t");
        Integer n = caretOffset;
        Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"caretOffset");
        int nextCharOffset = CharArrayUtil.shiftForward((CharSequence)text, (int)n, (String)" \t");
        PsiElement prev = psiFile.findElementAt(prevCharOffset);
        PsiElement next2 = psiFile.findElementAt(nextCharOffset);
        if (Intrinsics.areEqual((Object)prev, (Object)next2) ^ true && prev != null && next2 != null && Intrinsics.areEqual((Object)prev.getParent(), (Object)next2.getParent()) && prev.getParent() instanceof LuaIndentRange && prev.getNextSibling() instanceof LuaBlock) {
            EditorActionHandler editorActionHandler = originalHandler;
            if (editorActionHandler != null) {
                CaretModel caretModel = editor.getCaretModel();
                Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"editor.caretModel");
                editorActionHandler.execute(editor, caretModel.getCurrentCaret(), dataContext);
            }
            PsiDocumentManager.getInstance((Project)psiFile.getProject()).commitDocument(editor.getDocument());
            try {
                CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)psiFile.getProject());
                CaretModel caretModel = editor.getCaretModel();
                Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"editor.caretModel");
                codeStyleManager.adjustLineIndent(psiFile, caretModel.getOffset());
            }
            catch (IncorrectOperationException incorrectOperationException) {
                // empty catch block
            }
            return EnterHandlerDelegate.Result.DefaultForceIndent;
        }
        return EnterHandlerDelegate.Result.Continue;
    }
}

