/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.emmylua.lua.editor;

import com.immomo.emmylua.lua.lang.LuaLanguage;
import com.immomo.emmylua.lua.project.LLuaSettings;
import com.immomo.emmylua.lua.psi.LuaIndentRange;
import com.immomo.emmylua.lua.psi.LuaTypes;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016JF\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/immomo/emmylua/lua/editor/LuaEnterAfterUnmatchedBraceHandler;", "Lcom/intellij/codeInsight/editorActions/enter/EnterHandlerDelegate;", "()V", "shouldSmartIndent", "", "getEnd", "Lcom/intellij/psi/tree/IElementType;", "range", "postProcessEnter", "Lcom/intellij/codeInsight/editorActions/enter/EnterHandlerDelegate$Result;", "psiFile", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "preprocessEnter", "caretOffsetRef", "Lcom/intellij/openapi/util/Ref;", "", "caretAdvance", "editorActionHandler", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "MMPaas"})
public final class LuaEnterAfterUnmatchedBraceHandler
implements EnterHandlerDelegate {
    private boolean shouldSmartIndent;

    private final IElementType getEnd(IElementType range) {
        IElementType iElementType;
        if (range == LuaTypes.TABLE_EXPR) {
            IElementType iElementType2 = LuaTypes.RCURLY;
            Intrinsics.checkExpressionValueIsNotNull((Object)iElementType2, (String)"LuaTypes.RCURLY");
            return iElementType2;
        }
        if (range == LuaTypes.REPEAT_STAT) {
            IElementType iElementType3 = LuaTypes.UNTIL;
            iElementType = iElementType3;
            Intrinsics.checkExpressionValueIsNotNull((Object)iElementType3, (String)"LuaTypes.UNTIL");
        } else {
            IElementType iElementType4 = LuaTypes.END;
            iElementType = iElementType4;
            Intrinsics.checkExpressionValueIsNotNull((Object)iElementType4, (String)"LuaTypes.END");
        }
        return iElementType;
    }

    @NotNull
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile psiFile, @NotNull Editor editor, @NotNull Ref<Integer> caretOffsetRef, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, @Nullable EditorActionHandler editorActionHandler) {
        Intrinsics.checkParameterIsNotNull((Object)psiFile, (String)"psiFile");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull(caretOffsetRef, (String)"caretOffsetRef");
        Intrinsics.checkParameterIsNotNull(caretAdvance, (String)"caretAdvance");
        Intrinsics.checkParameterIsNotNull((Object)dataContext, (String)"dataContext");
        if (!psiFile.getLanguage().is((Language)LuaLanguage.INSTANCE)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        if (!LLuaSettings.Companion.getInstance().isSmartCloseEnd()) {
            return EnterHandlerDelegate.Result.Continue;
        }
        Integer caretOffset = (Integer)caretOffsetRef.get();
        PsiElement lElement = psiFile.findElementAt(caretOffset - 1);
        Integer n = caretOffset;
        Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"caretOffset");
        PsiElement rElement = psiFile.findElementAt(n.intValue());
        if (lElement != null && Intrinsics.areEqual((Object)lElement, (Object)rElement) ^ true) {
            PsiElement searched;
            boolean shouldClose = false;
            PsiElement range = null;
            PsiElement cur2 = lElement;
            while ((searched = cur2.getParent()) != null && !(searched instanceof PsiFile)) {
                if (searched instanceof LuaIndentRange) {
                    ASTNode aSTNode = ((LuaIndentRange)searched).getNode();
                    Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"searched.node");
                    IElementType iElementType = aSTNode.getElementType();
                    Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"searched.node.elementType");
                    IElementType endType = this.getEnd(iElementType);
                    ASTNode endChild = ((LuaIndentRange)searched).getNode().findChildByType(endType);
                    if (endChild == null) {
                        shouldClose = true;
                        range = searched;
                        break;
                    }
                }
                cur2 = searched;
            }
            if (shouldClose && range != null) {
                ASTNode aSTNode = range.getNode();
                Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"range.node");
                IElementType iElementType = aSTNode.getElementType();
                Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"range.node.elementType");
                IElementType endType = this.getEnd(iElementType);
                Document document = editor.getDocument();
                Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"editor.document");
                Document document2 = document;
                if (!(rElement instanceof PsiWhiteSpace)) {
                    document2.insertString(caretOffset.intValue(), (CharSequence)("" + endType + ' '));
                } else {
                    document2.insertString(caretOffset.intValue(), (CharSequence)String.valueOf(endType));
                }
                EditorActionHandler editorActionHandler2 = editorActionHandler;
                if (editorActionHandler2 != null) {
                    CaretModel caretModel = editor.getCaretModel();
                    Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"editor.caretModel");
                    editorActionHandler2.execute(editor, caretModel.getCurrentCaret(), dataContext);
                }
                Project project = lElement.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"lElement.project");
                Project project2 = project;
                PsiDocumentManager.getInstance((Project)project2).commitDocument(document2);
                this.shouldSmartIndent = true;
                return EnterHandlerDelegate.Result.DefaultForceIndent;
            }
        }
        return EnterHandlerDelegate.Result.Continue;
    }

    @NotNull
    public EnterHandlerDelegate.Result postProcessEnter(@NotNull PsiFile psiFile, @NotNull Editor editor, @NotNull DataContext dataContext) {
        Intrinsics.checkParameterIsNotNull((Object)psiFile, (String)"psiFile");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)dataContext, (String)"dataContext");
        if (!psiFile.getLanguage().is((Language)LuaLanguage.INSTANCE)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        if (this.shouldSmartIndent) {
            this.shouldSmartIndent = false;
            Project project = editor.getProject();
            if (project == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"editor.project!!");
            Project project2 = project;
            Document document = editor.getDocument();
            Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"editor.document");
            Document document2 = document;
            PsiDocumentManager.getInstance((Project)project2).commitDocument(document2);
            CaretModel caretModel = editor.getCaretModel();
            Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"editor.caretModel");
            int caretOffset = caretModel.getOffset();
            LuaIndentRange newRange = (LuaIndentRange)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)psiFile, (int)caretOffset, LuaIndentRange.class, (boolean)false);
            if (newRange != null) {
                TextRange textRange = newRange.getTextRange();
                RangeMarker rangeMarker = document2.createRangeMarker(textRange);
                Intrinsics.checkExpressionValueIsNotNull((Object)rangeMarker, (String)"document.createRangeMarker(textRange)");
                RangeMarker marker = rangeMarker;
                ApplicationManager.getApplication().runWriteAction(new Runnable(editor, psiFile, textRange, document2, marker){
                    final /* synthetic */ Editor $editor;
                    final /* synthetic */ PsiFile $psiFile;
                    final /* synthetic */ TextRange $textRange;
                    final /* synthetic */ Document $document;
                    final /* synthetic */ RangeMarker $marker;

                    public final void run() {
                        Project project = this.$editor.getProject();
                        if (project == null) {
                            Intrinsics.throwNpe();
                        }
                        CodeStyleManager styleManager = CodeStyleManager.getInstance((Project)project);
                        styleManager.adjustLineIndent(this.$psiFile, this.$textRange);
                        int endLine = this.$document.getLineNumber(this.$marker.getEndOffset());
                        int lineEnd = this.$document.getLineEndOffset(endLine - 1);
                        this.$editor.getCaretModel().moveToOffset(lineEnd);
                        styleManager.adjustLineIndent(this.$psiFile, lineEnd);
                    }
                    {
                        this.$editor = editor;
                        this.$psiFile = psiFile;
                        this.$textRange = textRange;
                        this.$document = document;
                        this.$marker = rangeMarker;
                    }
                });
            }
        }
        return EnterHandlerDelegate.Result.Continue;
    }
}

