/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.emmylua.lua.editor;

import com.immomo.emmylua.lua.lang.LuaLanguage;
import com.immomo.emmylua.lua.psi.LuaBlock;
import com.immomo.emmylua.lua.psi.LuaClassMethodDef;
import com.immomo.emmylua.lua.psi.LuaClassMethodName;
import com.immomo.emmylua.lua.psi.LuaClosureExpr;
import com.immomo.emmylua.lua.psi.LuaForAStat;
import com.immomo.emmylua.lua.psi.LuaForBStat;
import com.immomo.emmylua.lua.psi.LuaFuncBody;
import com.immomo.emmylua.lua.psi.LuaFuncDef;
import com.immomo.emmylua.lua.psi.LuaIfStat;
import com.immomo.emmylua.lua.psi.LuaLocalFuncDef;
import com.immomo.emmylua.lua.psi.LuaPsiTreeUtil;
import com.immomo.emmylua.lua.psi.LuaRepeatStat;
import com.immomo.emmylua.lua.psi.LuaTypes;
import com.immomo.emmylua.lua.psi.LuaWhileStat;
import com.intellij.lang.Language;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.breadcrumbs.BreadcrumbsProvider;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0013\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016\u00a2\u0006\u0002\u0010\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/immomo/emmylua/lua/editor/LuaBreadcrumbsProvider;", "Lcom/intellij/ui/breadcrumbs/BreadcrumbsProvider;", "()V", "MAX_LEN", "", "acceptElement", "", "element", "Lcom/intellij/psi/PsiElement;", "cutText", "", "txt", "getElementInfo", "getLanguages", "", "Lcom/intellij/lang/Language;", "()[Lcom/intellij/lang/Language;", "MMPaas"})
public final class LuaBreadcrumbsProvider
implements BreadcrumbsProvider {
    private final int MAX_LEN = 15;

    @NotNull
    public Language[] getLanguages() {
        Language[] languageArray = new Language[1];
        LuaLanguage luaLanguage = LuaLanguage.INSTANCE;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)luaLanguage), (String)"LuaLanguage.INSTANCE");
        languageArray[0] = luaLanguage;
        return languageArray;
    }

    private final String cutText(String txt) {
        String t = txt;
        if (t.length() > this.MAX_LEN) {
            String string = t;
            int n = 0;
            int n2 = this.MAX_LEN;
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n, n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String string4 = string3;
            t = stringBuilder.append(string4).append("...").toString();
        }
        return t;
    }

    @NotNull
    public String getElementInfo(@NotNull PsiElement element) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        PsiElement psiElement = element;
        if (psiElement instanceof LuaBlock) {
            PsiElement blockParent = ((LuaBlock)element).getParent();
            PsiElement psiElement2 = blockParent;
            if (psiElement2 instanceof LuaFuncBody) {
                PsiElement parent2 = ((LuaFuncBody)blockParent).getParent();
                PsiElement psiElement3 = parent2;
                if (psiElement3 instanceof LuaClassMethodDef) {
                    StringBuilder stringBuilder = new StringBuilder();
                    LuaClassMethodName luaClassMethodName = ((LuaClassMethodDef)parent2).getClassMethodName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)luaClassMethodName, (String)"parent2.classMethodName");
                    string = stringBuilder.append(luaClassMethodName.getText()).append(((LuaClassMethodDef)parent2).getParamSignature()).toString();
                } else {
                    string = psiElement3 instanceof LuaClosureExpr ? "function" + ((LuaClosureExpr)parent2).getParamSignature() : (psiElement3 instanceof LuaFuncDef ? "function" + ((LuaFuncDef)parent2).getParamSignature() : (psiElement3 instanceof LuaLocalFuncDef ? "local function " + ((LuaLocalFuncDef)parent2).getName() : "<?>"));
                }
            } else if (psiElement2 instanceof LuaIfStat) {
                IElementType iElementType;
                PsiElement prevVisibleLeaf = PsiTreeUtil.prevVisibleLeaf((PsiElement)element);
                PsiElement psiElement4 = prevVisibleLeaf;
                IElementType iElementType2 = psiElement4 != null && (psiElement4 = psiElement4.getNode()) != null ? psiElement4.getElementType() : (iElementType = null);
                if (Intrinsics.areEqual((Object)iElementType, (Object)LuaTypes.ELSE)) {
                    string = "else";
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)LuaTypes.THEN)) {
                    PsiElement psiElement5 = LuaPsiTreeUtil.skipWhitespacesAndCommentsBackward(prevVisibleLeaf);
                    if (psiElement5 == null) {
                        Intrinsics.throwNpe();
                    }
                    PsiElement expr = psiElement5;
                    PsiElement psiElement6 = LuaPsiTreeUtil.skipWhitespacesAndCommentsBackward(expr);
                    if (psiElement6 == null) {
                        Intrinsics.throwNpe();
                    }
                    PsiElement prefix = psiElement6;
                    StringBuilder stringBuilder = new StringBuilder().append(prefix.getText()).append(' ');
                    String string2 = expr.getText();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"expr.text");
                    string = stringBuilder.append(this.cutText(string2)).append(" then").toString();
                } else {
                    string = "if";
                }
            } else {
                string = psiElement2 instanceof LuaForAStat ? "for" : (psiElement2 instanceof LuaForBStat ? "for" : (psiElement2 instanceof LuaRepeatStat ? "repeat" : (psiElement2 instanceof LuaWhileStat ? "while" : "<?>")));
            }
        } else {
            String string3 = element.getText();
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"element.text");
        }
        return string;
    }

    public boolean acceptElement(@NotNull PsiElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        PsiElement psiElement = element;
        return psiElement instanceof LuaBlock;
    }
}

