/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.emmylua.lua.documentation;

import com.immomo.emmylua.lua.documentation.MarkdownKt;
import com.immomo.emmylua.lua.documentation.MarkdownNode;
import com.intellij.codeInsight.documentation.DocumentationManagerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.flavours.MarkdownFlavourDescriptor;
import org.intellij.markdown.flavours.commonmark.CommonMarkFlavourDescriptor;
import org.intellij.markdown.parser.MarkdownParser;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a\f\u0010\u0003\u001a\u00020\u0001*\u00020\u0001H\u0002\u001a\f\u0010\u0004\u001a\u00020\u0001*\u00020\u0005H\u0002\u001a\u0010\u0010\u0006\u001a\u00020\u0007*\u00060\bj\u0002`\tH\u0002\u001a,\u0010\n\u001a\u00020\u0007*\u00020\u00052\u001e\u0010\u000b\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\r\u0012\u0004\u0012\u00020\u00070\fH\u0002\u00a8\u0006\u000e"}, d2={"markdownToHtml", "", "text", "htmlEscape", "toHtml", "Lcom/immomo/emmylua/lua/documentation/MarkdownNode;", "trimEnd", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "visit", "action", "Lkotlin/Function2;", "Lkotlin/Function0;", "MMPaas"})
public final class MarkdownKt {
    private static final void visit(@NotNull MarkdownNode $receiver, Function2<? super MarkdownNode, ? super Function0<Unit>, Unit> action) {
        action.invoke((Object)$receiver, (Object)new Function0<Unit>($receiver, action){
            final /* synthetic */ MarkdownNode $this_visit;
            final /* synthetic */ Function2 $action;

            public final void invoke() {
                for (MarkdownNode child : this.$this_visit.getChildren()) {
                    MarkdownKt.access$visit(child, this.$action);
                }
            }
            {
                this.$this_visit = markdownNode;
                this.$action = function2;
                super(0);
            }
        });
    }

    @NotNull
    public static final String markdownToHtml(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        ASTNode mdTree = new MarkdownParser((MarkdownFlavourDescriptor)new CommonMarkFlavourDescriptor()).buildMarkdownTreeFromString(text);
        MarkdownNode mdNode = new MarkdownNode(mdTree, null, text);
        return MarkdownKt.toHtml(mdNode);
    }

    private static final String toHtml(@NotNull MarkdownNode $receiver) {
        String string;
        if (Intrinsics.areEqual((Object)$receiver.getNode().getType(), (Object)MarkdownTokenTypes.WHITE_SPACE)) {
            return $receiver.getText();
        }
        StringBuilder sb = new StringBuilder();
        MarkdownKt.visit($receiver, (Function2<? super MarkdownNode, ? super Function0<Unit>, Unit>)((Function2)new Function2<MarkdownNode, Function0<? extends Unit>, Unit>(sb){
            final /* synthetic */ StringBuilder $sb;

            public final void invoke(@NotNull MarkdownNode node, @NotNull Function0<Unit> processChildren) {
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                Intrinsics.checkParameterIsNotNull(processChildren, (String)"processChildren");
                Function2<String, Boolean, Unit> wrapChildren$ = new Function2<String, Boolean, Unit>(this, processChildren){
                    final /* synthetic */ toHtml.1 this$0;
                    final /* synthetic */ Function0 $processChildren;

                    public final void invoke(@NotNull String tag, boolean newline) {
                        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
                        this.this$0.$sb.append('<' + tag + '>');
                        this.$processChildren.invoke();
                        this.this$0.$sb.append("</" + tag + '>');
                        if (newline) {
                            StringsKt.appendln((StringBuilder)this.this$0.$sb);
                        }
                    }

                    public static /* synthetic */ void invoke$default(toHtml.1 var0, String string, boolean bl, int n, Object object) {
                        if ((n & 2) != 0) {
                            bl = false;
                        }
                        var0.invoke(string, bl);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$processChildren = function0;
                        super(2);
                    }
                };
                IElementType nodeType = node.getType();
                String nodeText = node.getText();
                IElementType iElementType = nodeType;
                if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.UNORDERED_LIST)) {
                    wrapChildren$.invoke("ul", true);
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.ORDERED_LIST)) {
                    wrapChildren$.invoke("ol", true);
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.LIST_ITEM)) {
                    toHtml.1.invoke$default(wrapChildren$, "li", false, 2, null);
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.EMPH)) {
                    toHtml.1.invoke$default(wrapChildren$, "em", false, 2, null);
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.STRONG)) {
                    toHtml.1.invoke$default(wrapChildren$, "strong", false, 2, null);
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.ATX_1)) {
                    toHtml.1.invoke$default(wrapChildren$, "h1", false, 2, null);
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.ATX_2)) {
                    toHtml.1.invoke$default(wrapChildren$, "h2", false, 2, null);
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.ATX_3)) {
                    toHtml.1.invoke$default(wrapChildren$, "h3", false, 2, null);
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.ATX_4)) {
                    toHtml.1.invoke$default(wrapChildren$, "h4", false, 2, null);
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.ATX_5)) {
                    toHtml.1.invoke$default(wrapChildren$, "h5", false, 2, null);
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.ATX_6)) {
                    toHtml.1.invoke$default(wrapChildren$, "h6", false, 2, null);
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.BLOCK_QUOTE)) {
                    toHtml.1.invoke$default(wrapChildren$, "blockquote", false, 2, null);
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.PARAGRAPH)) {
                    MarkdownKt.access$trimEnd(this.$sb);
                    wrapChildren$.invoke("p", true);
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.CODE_SPAN)) {
                    String startDelimiter;
                    MarkdownNode markdownNode = node.child(MarkdownTokenTypes.BACKTICK);
                    String string = startDelimiter = markdownNode != null ? markdownNode.getText() : null;
                    if (startDelimiter != null) {
                        String string2 = node.getText();
                        int n = startDelimiter.length();
                        String string3 = string2;
                        if (string3 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string4 = string3.substring(n);
                        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
                        String text = StringsKt.removeSuffix((String)string4, (CharSequence)startDelimiter);
                        this.$sb.append("<code>").append(MarkdownKt.access$htmlEscape(text)).append("</code>");
                    }
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.CODE_BLOCK) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.CODE_FENCE)) {
                    MarkdownKt.access$trimEnd(this.$sb);
                    this.$sb.append("<pre><code>");
                    processChildren.invoke();
                    this.$sb.append("</code></pre>");
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.SHORT_REFERENCE_LINK) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.FULL_REFERENCE_LINK)) {
                    List linkLabelContent;
                    List list;
                    MarkdownNode linkLabelNode = node.child(MarkdownElementTypes.LINK_LABEL);
                    Object object = linkLabelNode;
                    if (object != null && (object = ((MarkdownNode)object).getChildren()) != null) {
                        List $receiver$iv;
                        Iterable iterable = (Iterable)object;
                        boolean yielding$iv = false;
                        ArrayList<T> list$iv = new ArrayList<T>();
                        for (T item$iv : $receiver$iv) {
                            if (yielding$iv) {
                                list$iv.add(item$iv);
                                continue;
                            }
                            MarkdownNode it = (MarkdownNode)item$iv;
                            boolean bl = false;
                            if (Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.LBRACKET)) continue;
                            list$iv.add(item$iv);
                            yielding$iv = true;
                        }
                        $receiver$iv = list$iv;
                        if (!$receiver$iv.isEmpty()) {
                            ListIterator<E> iterator$iv = $receiver$iv.listIterator($receiver$iv.size());
                            while (iterator$iv.hasPrevious()) {
                                MarkdownNode it = (MarkdownNode)iterator$iv.previous();
                                boolean bl = false;
                                if (Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.RBRACKET)) continue;
                                list = CollectionsKt.take((Iterable)$receiver$iv, (int)(iterator$iv.nextIndex() + 1));
                                break;
                            }
                        } else {
                            list = CollectionsKt.emptyList();
                        }
                    } else {
                        list = linkLabelContent = null;
                    }
                    if (linkLabelContent != null) {
                        String label2 = CollectionsKt.joinToString$default((Iterable)linkLabelContent, (CharSequence)"", null, null, (int)0, null, (Function1)toHtml.label.1.INSTANCE, (int)30, null);
                        Object object2 = node.child(MarkdownElementTypes.LINK_TEXT);
                        if (object2 == null || (object2 = MarkdownKt.access$toHtml((MarkdownNode)object2)) == null) {
                            object2 = label2;
                        }
                        Object linkText = object2;
                        DocumentationManagerUtil.createHyperlink((StringBuilder)this.$sb, (String)label2, (String)linkText, (boolean)true);
                    } else {
                        this.$sb.append(node.getText());
                    }
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.INLINE_LINK)) {
                    String destination;
                    MarkdownNode markdownNode = node.child(MarkdownElementTypes.LINK_TEXT);
                    String label3 = markdownNode != null ? MarkdownKt.access$toHtml(markdownNode) : null;
                    MarkdownNode markdownNode2 = node.child(MarkdownElementTypes.LINK_DESTINATION);
                    String string = destination = markdownNode2 != null ? markdownNode2.getText() : null;
                    if (label3 != null && destination != null) {
                        this.$sb.append("<a href=\"" + destination + "\">" + label3 + "</a>");
                    } else {
                        this.$sb.append(node.getText());
                    }
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.TEXT) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.WHITE_SPACE) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.COLON) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.SINGLE_QUOTE) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.DOUBLE_QUOTE) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.LPAREN) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.RPAREN) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.LBRACKET) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.RBRACKET) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.EXCLAMATION_MARK)) {
                    this.$sb.append(nodeText);
                } else if (!Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.CODE_LINE)) {
                    if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.CODE_FENCE_CONTENT)) {
                        this.$sb.append(MarkdownKt.access$htmlEscape(nodeText));
                    } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.EOL)) {
                        IElementType parentType;
                        MarkdownNode markdownNode = node.getParent();
                        Object object = parentType = markdownNode != null ? markdownNode.getType() : null;
                        if (Intrinsics.areEqual((Object)parentType, (Object)MarkdownElementTypes.CODE_BLOCK) || Intrinsics.areEqual((Object)parentType, (Object)MarkdownElementTypes.CODE_FENCE)) {
                            this.$sb.append("\n");
                        } else {
                            this.$sb.append(" ");
                        }
                    } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.GT)) {
                        this.$sb.append("&gt;");
                    } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.LT)) {
                        this.$sb.append("&lt;");
                    } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.LINK_TEXT)) {
                        List childrenWithoutBrackets = CollectionsKt.dropLast((List)CollectionsKt.drop((Iterable)node.getChildren(), (int)1), (int)1);
                        for (MarkdownNode child : childrenWithoutBrackets) {
                            this.$sb.append(MarkdownKt.access$toHtml(child));
                        }
                    } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.EMPH)) {
                        IElementType parentNodeType;
                        MarkdownNode markdownNode = node.getParent();
                        Object object = parentNodeType = markdownNode != null ? markdownNode.getType() : null;
                        if (Intrinsics.areEqual((Object)parentNodeType, (Object)MarkdownElementTypes.EMPH) ^ true && Intrinsics.areEqual((Object)parentNodeType, (Object)MarkdownElementTypes.STRONG) ^ true) {
                            this.$sb.append(node.getText());
                        }
                    } else {
                        processChildren.invoke();
                    }
                }
            }
            {
                this.$sb = stringBuilder;
                super(2);
            }
        }));
        String string2 = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"sb.toString()");
        String string3 = string = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return ((Object)StringsKt.trimEnd((CharSequence)string3)).toString();
    }

    private static final void trimEnd(@NotNull StringBuilder $receiver) {
        while ($receiver.length() > 0 && $receiver.charAt($receiver.length() - 1) == ' ') {
            $receiver.deleteCharAt($receiver.length() - 1);
        }
    }

    private static final String htmlEscape(@NotNull String $receiver) {
        return StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)$receiver, (String)"&", (String)"&amp;", (boolean)false, (int)4, null), (String)"<", (String)"&lt;", (boolean)false, (int)4, null), (String)">", (String)"&gt;", (boolean)false, (int)4, null);
    }

    public static final /* synthetic */ void access$visit(MarkdownNode $receiver, Function2 action) {
        MarkdownKt.visit($receiver, (Function2<? super MarkdownNode, ? super Function0<Unit>, Unit>)action);
    }

    public static final /* synthetic */ void access$trimEnd(StringBuilder $receiver) {
        MarkdownKt.trimEnd($receiver);
    }

    public static final /* synthetic */ String access$htmlEscape(String $receiver) {
        return MarkdownKt.htmlEscape($receiver);
    }

    public static final /* synthetic */ String access$toHtml(MarkdownNode $receiver) {
        return MarkdownKt.toHtml($receiver);
    }
}

