/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.emmylua.lua.debugger.remote.commands;

import com.immomo.emmylua.lua.debugger.DebugLogger;
import com.immomo.emmylua.lua.debugger.LuaExecutionStack;
import com.immomo.emmylua.lua.debugger.remote.LuaMobStackFrame;
import com.immomo.emmylua.lua.debugger.remote.commands.DefaultCommand;
import com.immomo.emmylua.lua.debugger.remote.value.LuaRValue;
import com.immomo.emmylua.lua.psi.LuaFileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.impl.XSourcePositionImpl;
import com.luaj.vm2.Globals;
import com.luaj.vm2.LuaFunction;
import com.luaj.vm2.LuaTable;
import com.luaj.vm2.LuaValue;
import com.luaj.vm2.lib.jse.JsePlatform;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u0006H\u0016J\u0018\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/immomo/emmylua/lua/debugger/remote/commands/GetStackCommand;", "Lcom/immomo/emmylua/lua/debugger/remote/commands/DefaultCommand;", "()V", "errorDataLen", "", "hasError", "", "handle", "", "index", "data", "", "isFinished", "parseValues", "paramsTable", "Lcom/luaj/vm2/LuaTable;", "frame", "Lcom/immomo/emmylua/lua/debugger/remote/LuaMobStackFrame;", "MMPaas"})
public final class GetStackCommand
extends DefaultCommand {
    private boolean hasError;
    private int errorDataLen;

    @Override
    public boolean isFinished() {
        return !this.hasError && super.isFinished();
    }

    @Override
    public int handle(@NotNull String data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        if (this.hasError) {
            this.hasError = false;
            String string = data;
            int n = 0;
            int n2 = this.errorDataLen;
            String string2 = string.substring(n, n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String error2 = string2;
            DebugLogger.DefaultImpls.error$default(this.getDebugProcess(), error2, null, 2, null);
            this.getDebugProcess().runCommand(new DefaultCommand("RUN", 0));
            return this.errorDataLen;
        }
        return super.handle(data);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void handle(int index, @NotNull String data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        if (StringsKt.startsWith$default((String)data, (String)"401", (boolean)false, (int)2, null)) {
            this.hasError = true;
            Pattern pattern = Pattern.compile("(\\d+)([^\\d]+)(\\d+)");
            Matcher matcher = pattern.matcher(data);
            if (matcher.find()) {
                this.errorDataLen = Integer.parseInt(matcher.group(3));
            }
            return;
        }
        if (StringsKt.startsWith$default((String)data, (String)"200 OK", (boolean)false, (int)2, null)) {
            String matcher = data;
            int n = 6;
            String string = matcher.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(this as java.lang.String).substring(startIndex)");
            String stackCode = string;
            Globals standardGlobals = JsePlatform.standardGlobals();
            String strippedCode = DefaultCommand.limitStringSize$default(this, stackCode, 0, 2, null);
            LuaValue code = standardGlobals.load(strippedCode);
            LuaFunction function = code.checkfunction();
            LuaValue value = function.call();
            ArrayList<LuaMobStackFrame> frames = new ArrayList<LuaMobStackFrame>();
            int n2 = 1;
            int n3 = value.length();
            if (n2 <= n3) {
                while (true) {
                    String functionName;
                    void i;
                    LuaValue stackValue = value.get((int)i);
                    LuaValue stackInfo = stackValue.get(1);
                    LuaValue funcName = stackInfo.get(1);
                    LuaValue fileName = stackInfo.get(2);
                    LuaValue line = stackInfo.get(4);
                    XSourcePositionImpl position = null;
                    XDebugSession xDebugSession = this.getDebugProcess().getSession();
                    Intrinsics.checkExpressionValueIsNotNull((Object)xDebugSession, (String)"debugProcess.session");
                    VirtualFile virtualFile = LuaFileUtil.findFile(xDebugSession.getProject(), fileName.toString());
                    if (virtualFile != null) {
                        int nLine = line.toint();
                        position = XSourcePositionImpl.create((VirtualFile)virtualFile, (int)(nLine - 1));
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)funcName.toString(), (String)"funcName.toString()");
                    if (funcName.isnil()) {
                        functionName = "main";
                    }
                    LuaMobStackFrame frame = new LuaMobStackFrame(functionName, (XSourcePosition)position, (int)i, this.getDebugProcess());
                    LuaTable luaTable = stackValue.get(2).checktable();
                    Intrinsics.checkExpressionValueIsNotNull((Object)luaTable, (String)"stackValue.get(2).checktable()");
                    this.parseValues(luaTable, frame);
                    LuaTable luaTable2 = stackValue.get(3).checktable();
                    Intrinsics.checkExpressionValueIsNotNull((Object)luaTable2, (String)"stackValue.get(3).checktable()");
                    this.parseValues(luaTable2, frame);
                    frames.add(frame);
                    if (i == n3) break;
                    ++i;
                }
            }
            this.getDebugProcess().setStack(new LuaExecutionStack((List<? extends XStackFrame>)frames));
        }
    }

    private final void parseValues(LuaTable paramsTable, LuaMobStackFrame frame) {
        LuaValue[] keys;
        for (LuaValue key : keys = paramsTable.keys()) {
            LuaValue luaValue = paramsTable.get(key);
            LuaValue desc = luaValue.get(2);
            String string = key.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"key.toString()");
            LuaValue luaValue2 = luaValue.get(1);
            Intrinsics.checkExpressionValueIsNotNull((Object)luaValue2, (String)"luaValue.get(1)");
            String string2 = desc.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"desc.toString()");
            XDebugSession xDebugSession = this.getDebugProcess().getSession();
            Intrinsics.checkExpressionValueIsNotNull((Object)xDebugSession, (String)"debugProcess.session");
            LuaRValue xValue = LuaRValue.Companion.create(string, luaValue2, string2, xDebugSession);
            frame.addValue(xValue);
        }
    }

    public GetStackCommand() {
        super("STACK --{maxlevel=0}", 1);
    }
}

