/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.emmylua.lua.debugger.remote.commands;

import com.immomo.emmylua.lua.debugger.remote.MobClient;
import com.immomo.emmylua.lua.debugger.remote.commands.DebugCommand;
import com.immomo.emmylua.lua.lexer.LuaLexerAdapter;
import com.immomo.emmylua.lua.psi.LuaTypes;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0001\u001fB\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0012\u001a\u00020\u0005H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0003H\u0014J\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0003H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u001a\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u00032\b\b\u0002\u0010\u001b\u001a\u00020\u0005H\u0004J\u0010\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\u0005X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/immomo/emmylua/lua/debugger/remote/commands/DefaultCommand;", "Lcom/immomo/emmylua/lua/debugger/remote/commands/DebugCommand;", "commandline", "", "requireRespLines", "", "(Ljava/lang/String;I)V", "handleLines", "getHandleLines$MMPaas", "()I", "setHandleLines$MMPaas", "(I)V", "lineBuffer", "Ljava/lang/StringBuffer;", "getLineBuffer", "()Ljava/lang/StringBuffer;", "setLineBuffer", "(Ljava/lang/StringBuffer;)V", "getRequireRespLines", "handle", "", "index", "data", "isFinished", "", "limitStringSize", "code", "limit", "write", "writer", "Lcom/immomo/emmylua/lua/debugger/remote/MobClient;", "StringRange", "MMPaas"})
public class DefaultCommand
extends DebugCommand {
    private int handleLines;
    @NotNull
    private StringBuffer lineBuffer;
    private final String commandline;
    private final int requireRespLines;

    public final int getHandleLines$MMPaas() {
        return this.handleLines;
    }

    public final void setHandleLines$MMPaas(int n) {
        this.handleLines = n;
    }

    @NotNull
    public final StringBuffer getLineBuffer() {
        return this.lineBuffer;
    }

    public final void setLineBuffer(@NotNull StringBuffer stringBuffer) {
        Intrinsics.checkParameterIsNotNull((Object)stringBuffer, (String)"<set-?>");
        this.lineBuffer = stringBuffer;
    }

    @Override
    public void write(@NotNull MobClient writer) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        writer.write(this.commandline);
    }

    @Override
    public int handle(@NotNull String data) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        int lb = StringsKt.indexOf$default((CharSequence)data, (char)'\n', (int)0, (boolean)false, (int)6, null);
        if (lb == -1) {
            this.lineBuffer.append(data, 0, data.length());
            n = data.length();
        } else {
            this.lineBuffer.append(data, 0, lb + 1);
            int n2 = this.handleLines;
            this.handleLines = n2 + 1;
            String string = this.lineBuffer.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"lineBuffer.toString()");
            this.handle(n2, string);
            this.lineBuffer.setLength(0);
            n = lb + 1;
        }
        return n;
    }

    @Override
    public boolean isFinished() {
        return this.requireRespLines <= this.handleLines;
    }

    @Override
    public int getRequireRespLines() {
        return this.requireRespLines;
    }

    protected void handle(int index, @NotNull String data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
    }

    @NotNull
    protected final String limitStringSize(@NotNull String code, int limit) {
        Intrinsics.checkParameterIsNotNull((Object)code, (String)"code");
        LuaLexerAdapter lex = new LuaLexerAdapter(null, 1, null);
        lex.start(code);
        List rangeList = new ArrayList();
        do {
            int len2;
            lex.advance();
            if (!Intrinsics.areEqual((Object)lex.getTokenType(), (Object)LuaTypes.STRING) || (len2 = lex.getTokenEnd() - lex.getTokenStart()) <= limit) continue;
            rangeList.add(new StringRange(lex.getTokenStart(), lex.getTokenEnd()));
        } while (lex.getBufferEnd() != lex.getTokenEnd());
        Object object = rangeList;
        if (!object.isEmpty()) {
            Object $receiver = object = new StringBuilder();
            boolean bl = false;
            int prev = 0;
            Iterable $receiver$iv = rangeList;
            for (Object element$iv : $receiver$iv) {
                String string;
                StringRange range = (StringRange)element$iv;
                boolean bl2 = false;
                String string2 = code;
                int n = prev;
                int n2 = range.getStart() + limit;
                Object object2 = $receiver;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2.substring(n, n2), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                ((StringBuilder)object2).append(string);
                ((StringBuilder)$receiver).append("...(Emmy : stripped size = " + (range.getEnd() - range.getStart() - limit) + ')');
                prev = range.getEnd() - 1;
            }
            String string = code;
            int n = prev;
            Object object3 = $receiver;
            String string3 = string.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            String string4 = string3;
            ((StringBuilder)object3).append(string4);
            String string5 = ((StringBuilder)object).toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"StringBuilder().apply(builderAction).toString()");
            return string5;
        }
        return code;
    }

    @NotNull
    public static /* synthetic */ String limitStringSize$default(DefaultCommand defaultCommand, String string, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: limitStringSize");
        }
        if ((n2 & 2) != 0) {
            n = 1000;
        }
        return defaultCommand.limitStringSize(string, n);
    }

    @JvmOverloads
    public DefaultCommand(@NotNull String commandline, int requireRespLines) {
        Intrinsics.checkParameterIsNotNull((Object)commandline, (String)"commandline");
        this.commandline = commandline;
        this.requireRespLines = requireRespLines;
        this.lineBuffer = new StringBuffer(32768);
    }

    @JvmOverloads
    public /* synthetic */ DefaultCommand(String string, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 1;
        }
        this(string, n);
    }

    @JvmOverloads
    public DefaultCommand(@NotNull String commandline) {
        this(commandline, 0, 2, null);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/immomo/emmylua/lua/debugger/remote/commands/DefaultCommand$StringRange;", "", "start", "", "end", "(II)V", "getEnd", "()I", "getStart", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "MMPaas"})
    public static final class StringRange {
        private final int start;
        private final int end;

        public final int getStart() {
            return this.start;
        }

        public final int getEnd() {
            return this.end;
        }

        public StringRange(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public final int component1() {
            return this.start;
        }

        public final int component2() {
            return this.end;
        }

        @NotNull
        public final StringRange copy(int start, int end) {
            return new StringRange(start, end);
        }

        @NotNull
        public static /* synthetic */ StringRange copy$default(StringRange stringRange, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = stringRange.start;
            }
            if ((n3 & 2) != 0) {
                n2 = stringRange.end;
            }
            return stringRange.copy(n, n2);
        }

        @NotNull
        public String toString() {
            return "StringRange(start=" + this.start + ", end=" + this.end + ")";
        }

        public int hashCode() {
            return this.start * 31 + this.end;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof StringRange)) break block3;
                    StringRange stringRange = (StringRange)object;
                    if (!(this.start == stringRange.start) || !(this.end == stringRange.end)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

