/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.emmylua.lua.debugger.remote;

import com.immomo.emmylua.lua.debugger.LogConsoleType;
import com.immomo.emmylua.lua.debugger.remote.MobClient;
import com.immomo.emmylua.lua.debugger.remote.MobServerListener;
import com.intellij.execution.ui.ConsoleViewContentType;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\r\u001a\u00020\u000eJ\b\u0010\u000f\u001a\u00020\u000eH\u0016J\u000e\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u0011\u001a\u00020\u000eR\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/immomo/emmylua/lua/debugger/remote/MobServer;", "Ljava/lang/Runnable;", "listener", "Lcom/immomo/emmylua/lua/debugger/remote/MobServerListener;", "(Lcom/immomo/emmylua/lua/debugger/remote/MobServerListener;)V", "client", "Lcom/immomo/emmylua/lua/debugger/remote/MobClient;", "isStopped", "", "port", "", "server", "Ljava/nio/channels/ServerSocketChannel;", "restart", "", "run", "start", "stop", "MMPaas"})
public final class MobServer
implements Runnable {
    private ServerSocketChannel server;
    private MobClient client;
    private int port;
    private boolean isStopped;
    private final MobServerListener listener;

    public final void start(int port) throws IOException {
        this.port = port;
        if (this.server == null) {
            this.server = ServerSocketChannel.open();
        }
        ServerSocketChannel serverSocketChannel = this.server;
        if (serverSocketChannel != null) {
            serverSocketChannel.bind(new InetSocketAddress(port));
        }
        Thread thread = new Thread(this);
        thread.start();
    }

    public final void restart() {
        MobClient mobClient = this.client;
        if (mobClient != null) {
            mobClient.stop();
        }
        this.client = null;
    }

    @Override
    public void run() {
        while (!this.isStopped) {
            try {
                ServerSocketChannel serverSocketChannel = this.server;
                if (serverSocketChannel == null) {
                    Intrinsics.throwNpe();
                }
                SocketChannel accept = serverSocketChannel.accept();
                if (this.client != null) {
                    try {
                        accept.close();
                    }
                    catch (Exception exception) {}
                    continue;
                }
                ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.SYSTEM_OUTPUT;
                Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType, (String)"ConsoleViewContentType.SYSTEM_OUTPUT");
                this.listener.println("Connected.", LogConsoleType.NORMAL, consoleViewContentType);
                SocketChannel socketChannel = accept;
                Intrinsics.checkExpressionValueIsNotNull((Object)socketChannel, (String)"accept");
                MobClient mobClient = this.client = new MobClient(socketChannel, this.listener);
                if (mobClient == null) {
                    Intrinsics.throwNpe();
                }
                this.listener.onConnect(mobClient);
            }
            catch (IOException e) {
                break;
            }
        }
    }

    public final void stop() {
        this.isStopped = true;
        MobClient mobClient = this.client;
        if (mobClient != null) {
            mobClient.stop();
        }
        this.client = null;
        try {
            ServerSocketChannel serverSocketChannel = this.server;
            if (serverSocketChannel != null) {
                serverSocketChannel.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public MobServer(@NotNull MobServerListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.listener = listener;
    }
}

