/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.emmylua.lua.debugger.remote;

import com.immomo.emmylua.lua.debugger.DebugLogger;
import com.immomo.emmylua.lua.debugger.LogConsoleType;
import com.immomo.emmylua.lua.debugger.remote.MobServerListener;
import com.immomo.emmylua.lua.debugger.remote.commands.DebugCommand;
import com.immomo.emmylua.lua.debugger.remote.commands.DefaultCommand;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.application.ApplicationManager;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\tJ\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u000eJ\b\u0010\u0019\u001a\u00020\u0015H\u0002J\b\u0010\u001a\u001a\u00020\u0015H\u0002J\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u0017H\u0002J\b\u0010\u001d\u001a\u00020\u0015H\u0002J\u0016\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u000eJ\u0016\u0010!\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u000eJ\u0006\u0010\"\u001a\u00020\u0015J\u000e\u0010#\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u0017R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/immomo/emmylua/lua/debugger/remote/MobClient;", "", "socketChannel", "Ljava/nio/channels/SocketChannel;", "listener", "Lcom/immomo/emmylua/lua/debugger/remote/MobServerListener;", "(Ljava/nio/channels/SocketChannel;Lcom/immomo/emmylua/lua/debugger/remote/MobServerListener;)V", "commands", "Ljava/util/LinkedList;", "Lcom/immomo/emmylua/lua/debugger/remote/commands/DebugCommand;", "currentCommandWaitForResp", "isStopped", "", "receiveBufferSize", "", "socket", "Ljava/net/Socket;", "kotlin.jvm.PlatformType", "streamWriter", "Ljava/io/OutputStreamWriter;", "addCommand", "", "command", "", "rl", "doReceive", "doSend", "onResp", "data", "onSocketClosed", "sendAddBreakpoint", "file", "line", "sendRemoveBreakpoint", "stop", "write", "MMPaas"})
public final class MobClient {
    private boolean isStopped;
    private final LinkedList<DebugCommand> commands;
    private DebugCommand currentCommandWaitForResp;
    private OutputStreamWriter streamWriter;
    private final Socket socket;
    private final int receiveBufferSize = 0x100000;
    private final SocketChannel socketChannel;
    private final MobServerListener listener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void doSend() {
        try {
            this.streamWriter = new OutputStreamWriter(this.socket.getOutputStream(), Charset.forName("UTF-8"));
            while (true) {
                Socket socket = this.socket;
                Intrinsics.checkExpressionValueIsNotNull((Object)socket, (String)"socket");
                if (!socket.isConnected()) break;
                if (this.isStopped) {
                    break;
                }
                DebugCommand command = null;
                while (this.commands.size() > 0 && this.currentCommandWaitForResp == null) {
                    if (this.currentCommandWaitForResp != null) continue;
                    Intrinsics.checkExpressionValueIsNotNull((Object)this.commands.poll(), (String)"commands.poll()");
                    command.setDebugProcess(this.listener.getProcess());
                    command.write(this);
                    OutputStreamWriter outputStreamWriter = this.streamWriter;
                    if (outputStreamWriter == null) {
                        Intrinsics.throwNpe();
                    }
                    outputStreamWriter.write("\n");
                    OutputStreamWriter outputStreamWriter2 = this.streamWriter;
                    if (outputStreamWriter2 == null) {
                        Intrinsics.throwNpe();
                    }
                    outputStreamWriter2.flush();
                    if (command.getRequireRespLines() <= 0) continue;
                    this.currentCommandWaitForResp = command;
                }
                Thread.sleep(5L);
            }
        }
        catch (SocketException command) {
        }
        catch (Exception e) {
            String string = e.getMessage();
            if (string != null) {
                String string2;
                String it = string2 = string;
                boolean bl = false;
                DebugLogger.DefaultImpls.error$default(this.listener, it, null, 2, null);
            }
        }
        finally {
            ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.SYSTEM_OUTPUT;
            Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType, (String)"ConsoleViewContentType.SYSTEM_OUTPUT");
            this.listener.println("Disconnected.", LogConsoleType.NORMAL, consoleViewContentType);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void doReceive() {
        block8: {
            try {
                int readSize = 0;
                ByteBuffer bf = ByteBuffer.allocate(this.receiveBufferSize);
                while (!this.isStopped) {
                    String string;
                    MobClient mobClient;
                    readSize = this.socketChannel.read(bf);
                    if (readSize <= 0) continue;
                    int begin = 0;
                    int n = 1;
                    int n2 = readSize + 1;
                    if (n <= n2) {
                        while (true) {
                            void i;
                            if (bf.get((int)(i - true)) == 10) {
                                byte[] byArray;
                                Intrinsics.checkExpressionValueIsNotNull((Object)bf.array(), (String)"bf.array()");
                                mobClient = this;
                                string = new String(byArray, begin, (int)i, Charsets.UTF_8);
                                mobClient.onResp(string);
                                begin = i;
                            }
                            if (i == n2) break;
                            ++i;
                        }
                    }
                    if (begin < readSize) {
                        byte[] i;
                        Intrinsics.checkExpressionValueIsNotNull((Object)bf.array(), (String)"bf.array()");
                        mobClient = this;
                        string = new String(i, begin, readSize, Charsets.UTF_8);
                        mobClient.onResp(string);
                    }
                    bf.clear();
                }
            }
            catch (IOException e) {
                this.onSocketClosed();
            }
            catch (Exception e) {
                String string;
                String string2 = e.getMessage();
                if (string2 == null) break block8;
                String it = string = string2;
                boolean bl = false;
                DebugLogger.DefaultImpls.error$default(this.listener, it, null, 2, null);
            }
        }
    }

    private final void onResp(String data) {
        int eat;
        DebugCommand cmd = this.currentCommandWaitForResp;
        if (cmd != null && (eat = cmd.handle(data)) > 0) {
            if (cmd.isFinished()) {
                this.currentCommandWaitForResp = null;
            }
            return;
        }
        Pattern pattern = Pattern.compile("(\\d+) (\\w+)( (.+))?");
        Matcher matcher = pattern.matcher(data);
        if (matcher.find()) {
            int code = Integer.parseInt(matcher.group(1));
            String context2 = matcher.group(4);
            this.listener.handleResp(this, code, context2);
        }
    }

    private final void onSocketClosed() {
        this.listener.onDisconnect(this);
    }

    public final void write(@NotNull String data) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        OutputStreamWriter outputStreamWriter = this.streamWriter;
        if (outputStreamWriter == null) {
            Intrinsics.throwNpe();
        }
        outputStreamWriter.write(data);
    }

    public final void stop() {
        try {
            OutputStreamWriter outputStreamWriter = this.streamWriter;
            if (outputStreamWriter != null) {
                outputStreamWriter.write("done\n");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.isStopped = true;
        this.currentCommandWaitForResp = null;
        try {
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void sendAddBreakpoint(@NotNull String file, int line) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        MobClient.addCommand$default(this, "SETB " + file + ' ' + line, 0, 2, null);
    }

    public final void sendRemoveBreakpoint(@NotNull String file, int line) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        MobClient.addCommand$default(this, "DELB " + file + ' ' + line, 0, 2, null);
    }

    public final void addCommand(@NotNull String command, int rl) {
        Intrinsics.checkParameterIsNotNull((Object)command, (String)"command");
        this.addCommand(new DefaultCommand(command, rl));
    }

    public static /* synthetic */ void addCommand$default(MobClient mobClient, String string, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 1;
        }
        mobClient.addCommand(string, n);
    }

    public final void addCommand(@NotNull DebugCommand command) {
        Intrinsics.checkParameterIsNotNull((Object)command, (String)"command");
        this.commands.add(command);
    }

    public MobClient(@NotNull SocketChannel socketChannel, @NotNull MobServerListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)socketChannel, (String)"socketChannel");
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.socketChannel = socketChannel;
        this.listener = listener;
        this.commands = new LinkedList();
        this.socket = this.socketChannel.socket();
        this.receiveBufferSize = 0x100000;
        Socket socket = this.socket;
        Intrinsics.checkExpressionValueIsNotNull((Object)socket, (String)"socket");
        socket.setReceiveBufferSize(this.receiveBufferSize);
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public final void run() {
                this.doReceive();
            }
        });
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public final void run() {
                this.doSend();
            }
        });
    }
}

