/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.emmylua.lua.debugger.remote;

import com.immomo.emmylua.lua.debugger.remote.LuaMobDebugProcess;
import com.immomo.emmylua.lua.debugger.remote.LuaMobDebuggerEvaluator;
import com.intellij.icons.AllIcons;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValueChildrenList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LuaMobStackFrame
extends XStackFrame {
    private String functionName;
    private XSourcePosition position;
    private LuaMobDebugProcess process;
    private XValueChildrenList values = new XValueChildrenList();
    private int stackLevel = 0;

    public LuaMobStackFrame(String functionName, XSourcePosition position, int _stackLevel, LuaMobDebugProcess debugProcess) {
        this.functionName = functionName;
        this.position = position;
        this.stackLevel = _stackLevel;
        this.process = debugProcess;
    }

    @Nullable
    public XDebuggerEvaluator getEvaluator() {
        return new LuaMobDebuggerEvaluator(this.process, this);
    }

    @Nullable
    public XSourcePosition getSourcePosition() {
        return this.position;
    }

    public void addValue(XNamedValue namedValue) {
        this.values.add(namedValue);
    }

    public void computeChildren(@NotNull XCompositeNode node) {
        if (node == null) {
            LuaMobStackFrame.$$$reportNull$$$0(0);
        }
        node.addChildren(this.values, true);
    }

    public void customizePresentation(@NotNull ColoredTextContainer component) {
        if (component == null) {
            LuaMobStackFrame.$$$reportNull$$$0(1);
        }
        XSourcePosition position = this.getSourcePosition();
        String info = this.functionName;
        String positionInfo = "unknown";
        if (position != null) {
            positionInfo = position.getFile().getName() + ":" + (position.getLine() + 1);
        }
        if (this.functionName != null) {
            info = String.format("%s (%s)", this.functionName, positionInfo);
        }
        component.append(info, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        component.setIcon(AllIcons.Debugger.StackFrame);
    }

    public int getStackLevel() {
        return this.stackLevel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        objectArray2[1] = "com/immomo/emmylua/lua/debugger/remote/LuaMobStackFrame";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "computeChildren";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "customizePresentation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

