/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.emmylua.lua.debugger.remote;

import com.immomo.emmylua.lua.debugger.DebugLogger;
import com.immomo.emmylua.lua.debugger.IRemoteConfiguration;
import com.immomo.emmylua.lua.debugger.LogConsoleType;
import com.immomo.emmylua.lua.debugger.LuaDebugProcess;
import com.immomo.emmylua.lua.debugger.LuaDebuggerEditorsProvider;
import com.immomo.emmylua.lua.debugger.remote.MobClient;
import com.immomo.emmylua.lua.debugger.remote.MobServer;
import com.immomo.emmylua.lua.debugger.remote.MobServerListener;
import com.immomo.emmylua.lua.debugger.remote.commands.DebugCommand;
import com.immomo.emmylua.lua.debugger.remote.commands.GetStackCommand;
import com.immomo.emmylua.lua.psi.LuaFileUtil;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.frame.XSuspendContext;
import java.net.BindException;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\"\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\tH\u0016J\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\tH\u0016J\u001c\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001e2\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030 H\u0014J\b\u0010!\u001a\u00020\u0014H\u0014J\u000e\u0010\"\u001a\u00020\u00142\u0006\u0010#\u001a\u00020$J\u0018\u0010%\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010&\u001a\u00020\u0014H\u0016J\b\u0010'\u001a\u00020\u0014H\u0016J\u0012\u0010(\u001a\u00020\u00142\b\u0010)\u001a\u0004\u0018\u00010*H\u0016J\u0012\u0010+\u001a\u00020\u00142\b\u0010)\u001a\u0004\u0018\u00010*H\u0016J\u0012\u0010,\u001a\u00020\u00142\b\u0010)\u001a\u0004\u0018\u00010*H\u0016J\b\u0010-\u001a\u00020\u0014H\u0016J\u001c\u0010.\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001e2\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030 H\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\u00008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/immomo/emmylua/lua/debugger/remote/LuaMobDebugProcess;", "Lcom/immomo/emmylua/lua/debugger/LuaDebugProcess;", "Lcom/immomo/emmylua/lua/debugger/remote/MobServerListener;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "(Lcom/intellij/xdebugger/XDebugSession;)V", "editorsProvider", "Lcom/immomo/emmylua/lua/debugger/LuaDebuggerEditorsProvider;", "mobClient", "Lcom/immomo/emmylua/lua/debugger/remote/MobClient;", "mobServer", "Lcom/immomo/emmylua/lua/debugger/remote/MobServer;", "process", "getProcess", "()Lcom/immomo/emmylua/lua/debugger/remote/LuaMobDebugProcess;", "runProfile", "Lcom/immomo/emmylua/lua/debugger/IRemoteConfiguration;", "getEditorsProvider", "Lcom/intellij/xdebugger/evaluation/XDebuggerEditorsProvider;", "handleResp", "", "client", "code", "", "data", "", "onConnect", "onDisconnect", "registerBreakpoint", "sourcePosition", "Lcom/intellij/xdebugger/XSourcePosition;", "breakpoint", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;", "run", "runCommand", "command", "Lcom/immomo/emmylua/lua/debugger/remote/commands/DebugCommand;", "sendBreakpoint", "sessionInitialized", "startPausing", "startStepInto", "context", "Lcom/intellij/xdebugger/frame/XSuspendContext;", "startStepOut", "startStepOver", "stop", "unregisterBreakpoint", "MMPaas"})
public class LuaMobDebugProcess
extends LuaDebugProcess
implements MobServerListener {
    private final IRemoteConfiguration runProfile;
    private final LuaDebuggerEditorsProvider editorsProvider;
    private final MobServer mobServer;
    private MobClient mobClient;

    @NotNull
    public XDebuggerEditorsProvider getEditorsProvider() {
        return (XDebuggerEditorsProvider)this.editorsProvider;
    }

    @Override
    public void sessionInitialized() {
        block3: {
            super.sessionInitialized();
            try {
                this.mobServer.start(this.runProfile.getPort());
                String string = "Start mobdebug server at port:" + this.runProfile.getPort();
                ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.SYSTEM_OUTPUT;
                Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType, (String)"ConsoleViewContentType.SYSTEM_OUTPUT");
                this.println(string, LogConsoleType.NORMAL, consoleViewContentType);
                ConsoleViewContentType consoleViewContentType2 = ConsoleViewContentType.SYSTEM_OUTPUT;
                Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType2, (String)"ConsoleViewContentType.SYSTEM_OUTPUT");
                this.println("Waiting for process connection...", LogConsoleType.NORMAL, consoleViewContentType2);
            }
            catch (BindException e) {
                DebugLogger.DefaultImpls.error$default(this, "Failed start mobdebug server at port:" + this.runProfile.getPort() + '\n' + e.getMessage(), null, 2, null);
            }
            catch (Exception e) {
                String string;
                String string2 = e.getMessage();
                if (string2 == null) break block3;
                String it = string = string2;
                boolean bl = false;
                DebugLogger.DefaultImpls.error$default(this, it, null, 2, null);
            }
        }
    }

    public void stop() {
        this.mobServer.stop();
    }

    @Override
    protected void run() {
        block0: {
            MobClient mobClient = this.mobClient;
            if (mobClient == null) break block0;
            MobClient.addCommand$default(mobClient, "RUN", 0, 2, null);
        }
    }

    public void startPausing() {
        block0: {
            MobClient mobClient = this.mobClient;
            if (mobClient == null) break block0;
            MobClient.addCommand$default(mobClient, "SUSPEND", 0, 2, null);
        }
    }

    public void startStepOver(@Nullable XSuspendContext context2) {
        block0: {
            MobClient mobClient = this.mobClient;
            if (mobClient == null) break block0;
            MobClient.addCommand$default(mobClient, "OVER", 0, 2, null);
        }
    }

    public void startStepInto(@Nullable XSuspendContext context2) {
        block0: {
            MobClient mobClient = this.mobClient;
            if (mobClient == null) break block0;
            MobClient.addCommand$default(mobClient, "STEP", 0, 2, null);
        }
    }

    @Override
    public void startStepOut(@Nullable XSuspendContext context2) {
        block0: {
            MobClient mobClient = this.mobClient;
            if (mobClient == null) break block0;
            MobClient.addCommand$default(mobClient, "OUT", 0, 2, null);
        }
    }

    private final void sendBreakpoint(MobClient client, XSourcePosition sourcePosition) {
        XDebugSession xDebugSession = this.getSession();
        Intrinsics.checkExpressionValueIsNotNull((Object)xDebugSession, (String)"session");
        Project project = xDebugSession.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"session.project");
        Project project2 = project;
        VirtualFile virtualFile = sourcePosition.getFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"sourcePosition.file");
        VirtualFile file = virtualFile;
        String fileShortUrl = LuaFileUtil.getShortPath(project2, file);
        if (fileShortUrl != null) {
            List<String> list = LuaFileUtil.getAllAvailablePathsForMob(fileShortUrl, file);
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"LuaFileUtil.getAllAvaila\u2026orMob(fileShortUrl, file)");
            Iterable $receiver$iv = list;
            for (Object element$iv : $receiver$iv) {
                String url = (String)element$iv;
                boolean bl = false;
                String string = url;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"url");
                client.sendAddBreakpoint(string, sourcePosition.getLine() + 1);
            }
        }
    }

    @Override
    protected void registerBreakpoint(@NotNull XSourcePosition sourcePosition, @NotNull XLineBreakpoint<?> breakpoint) {
        Intrinsics.checkParameterIsNotNull((Object)sourcePosition, (String)"sourcePosition");
        Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
        super.registerBreakpoint(sourcePosition, breakpoint);
        if (this.mobClient != null) {
            MobClient mobClient = this.mobClient;
            if (mobClient == null) {
                Intrinsics.throwNpe();
            }
            this.sendBreakpoint(mobClient, sourcePosition);
        }
    }

    @Override
    protected void unregisterBreakpoint(@NotNull XSourcePosition sourcePosition, @NotNull XLineBreakpoint<?> breakpoint) {
        Intrinsics.checkParameterIsNotNull((Object)sourcePosition, (String)"sourcePosition");
        Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
        super.unregisterBreakpoint(sourcePosition, breakpoint);
        if (this.mobClient != null) {
            VirtualFile virtualFile = sourcePosition.getFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"sourcePosition.file");
            VirtualFile file = virtualFile;
            XDebugSession xDebugSession = this.getSession();
            Intrinsics.checkExpressionValueIsNotNull((Object)xDebugSession, (String)"session");
            String fileShortUrl = LuaFileUtil.getShortPath(xDebugSession.getProject(), file);
            List<String> list = LuaFileUtil.getAllAvailablePathsForMob(fileShortUrl, file);
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"LuaFileUtil.getAllAvaila\u2026orMob(fileShortUrl, file)");
            Iterable $receiver$iv = list;
            for (Object element$iv : $receiver$iv) {
                String url = (String)element$iv;
                boolean bl = false;
                MobClient mobClient = this.mobClient;
                if (mobClient == null) {
                    Intrinsics.throwNpe();
                }
                String string = url;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"url");
                mobClient.sendRemoveBreakpoint(string, sourcePosition.getLine() + 1);
            }
        }
    }

    @Override
    public void handleResp(@NotNull MobClient client, int code, @Nullable String data) {
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        switch (code) {
            case 202: {
                this.runCommand(new GetStackCommand());
            }
        }
    }

    @Override
    public void onDisconnect(@NotNull MobClient client) {
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        this.mobServer.restart();
    }

    @Override
    public void onConnect(@NotNull MobClient client) {
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        this.mobClient = client;
        MobClient.addCommand$default(client, "DELB * 0", 0, 2, null);
        this.processBreakpoint((Processor)new Processor<XLineBreakpoint<?>>(this, client){
            final /* synthetic */ LuaMobDebugProcess this$0;
            final /* synthetic */ MobClient $client;

            public final boolean process(XLineBreakpoint<?> bp) {
                block0: {
                    XSourcePosition xSourcePosition;
                    XLineBreakpoint<?> xLineBreakpoint = bp;
                    Intrinsics.checkExpressionValueIsNotNull(xLineBreakpoint, (String)"bp");
                    XSourcePosition xSourcePosition2 = xLineBreakpoint.getSourcePosition();
                    if (xSourcePosition2 == null) break block0;
                    XSourcePosition it = xSourcePosition = xSourcePosition2;
                    boolean bl = false;
                    XSourcePosition xSourcePosition3 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)xSourcePosition3, (String)"it");
                    LuaMobDebugProcess.access$sendBreakpoint(this.this$0, this.$client, xSourcePosition3);
                }
                return true;
            }
            {
                this.this$0 = luaMobDebugProcess;
                this.$client = mobClient;
            }
        });
        client.addCommand(new GetStackCommand());
    }

    @Override
    @NotNull
    public LuaMobDebugProcess getProcess() {
        return this;
    }

    public final void runCommand(@NotNull DebugCommand command) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)command, (String)"command");
            MobClient mobClient = this.mobClient;
            if (mobClient == null) break block0;
            mobClient.addCommand(command);
        }
    }

    public LuaMobDebugProcess(@NotNull XDebugSession session) {
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        super(session);
        RunProfile runProfile = session.getRunProfile();
        if (runProfile == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.immomo.emmylua.lua.debugger.IRemoteConfiguration");
        }
        this.runProfile = (IRemoteConfiguration)runProfile;
        this.editorsProvider = new LuaDebuggerEditorsProvider();
        this.mobServer = new MobServer(this);
    }

    public static final /* synthetic */ void access$sendBreakpoint(LuaMobDebugProcess $this, MobClient client, XSourcePosition sourcePosition) {
        $this.sendBreakpoint(client, sourcePosition);
    }
}

