/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.emmylua.lua.debugger.attach.value;

import com.immomo.emmylua.lua.debugger.attach.LoadedScript;
import com.immomo.emmylua.lua.debugger.attach.LuaAttachDebugProcessBase;
import com.immomo.emmylua.lua.debugger.attach.value.LuaXObjectValue;
import com.immomo.emmylua.lua.debugger.attach.value.StackNodeId;
import com.immomo.emmylua.lua.lang.LuaIcons;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import java.io.DataInputStream;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/immomo/emmylua/lua/debugger/attach/value/LuaXFunction;", "Lcom/immomo/emmylua/lua/debugger/attach/value/LuaXObjectValue;", "L", "", "process", "Lcom/immomo/emmylua/lua/debugger/attach/LuaAttachDebugProcessBase;", "(JLcom/immomo/emmylua/lua/debugger/attach/LuaAttachDebugProcessBase;)V", "<set-?>", "", "line", "getLine", "()I", "script", "computePresentation", "", "xValueNode", "Lcom/intellij/xdebugger/frame/XValueNode;", "xValuePlace", "Lcom/intellij/xdebugger/frame/XValuePlace;", "read", "stream", "Ljava/io/DataInputStream;", "MMPaas"})
public final class LuaXFunction
extends LuaXObjectValue {
    private int line;
    private int script;

    public final int getLine() {
        return this.line;
    }

    @Override
    public void read(@NotNull DataInputStream stream) {
        Intrinsics.checkParameterIsNotNull((Object)stream, (String)"stream");
        super.read(stream);
        this.script = stream.readInt();
        this.line = stream.readInt();
    }

    @Override
    public void computePresentation(@NotNull XValueNode xValueNode, @NotNull XValuePlace xValuePlace) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)xValueNode, (String)"xValueNode");
        Intrinsics.checkParameterIsNotNull((Object)xValuePlace, (String)"xValuePlace");
        if (this.line >= 0 && this.script >= 0) {
            LoadedScript loadedScript = this.getProcess().getScript(this.script);
            if (loadedScript != null) {
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string2 = "line:%d, script:%s";
                Object[] objectArray = new Object[]{this.line, loadedScript.getName()};
                String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                string = string3;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(format, *args)");
            } else {
                string = "unknown source";
            }
        } else {
            string = "native";
        }
        String info = string;
        xValueNode.setPresentation(LuaIcons.LOCAL_FUNCTION, info, "function", false);
    }

    public LuaXFunction(long L, @NotNull LuaAttachDebugProcessBase process2) {
        Intrinsics.checkParameterIsNotNull((Object)process2, (String)"process");
        super(StackNodeId.Function, L, process2);
    }
}

