/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.emmylua.lua.debugger.attach;

import com.immomo.emmylua.lua.debugger.attach.DMProfilerCall;
import com.immomo.emmylua.lua.debugger.attach.DMRespProfilerData;
import com.immomo.emmylua.lua.debugger.attach.LuaAttachDebugProcessBase;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.table.TableModel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u000f\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u0012\u0010\u0005\u001a\u00060\u0006R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/immomo/emmylua/lua/debugger/attach/ProfilerPanel;", "Ljavax/swing/JPanel;", "process", "Lcom/immomo/emmylua/lua/debugger/attach/LuaAttachDebugProcessBase;", "(Lcom/immomo/emmylua/lua/debugger/attach/LuaAttachDebugProcessBase;)V", "model", "Lcom/immomo/emmylua/lua/debugger/attach/ProfilerPanel$ProfilerModel;", "getProcess", "()Lcom/immomo/emmylua/lua/debugger/attach/LuaAttachDebugProcessBase;", "table", "Lcom/intellij/ui/table/JBTable;", "updateProfiler", "", "message", "Lcom/immomo/emmylua/lua/debugger/attach/DMRespProfilerData;", "CallColumnInfo", "ProfilerModel", "MMPaas"})
public final class ProfilerPanel
extends JPanel {
    private final ProfilerModel model;
    private final JBTable table;
    @NotNull
    private final LuaAttachDebugProcessBase process;

    public final void updateProfiler(@NotNull DMRespProfilerData message2) {
        Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
        this.model.update(message2.getList().get(0));
    }

    @NotNull
    public final LuaAttachDebugProcessBase getProcess() {
        return this.process;
    }

    public ProfilerPanel(@NotNull LuaAttachDebugProcessBase process2) {
        Intrinsics.checkParameterIsNotNull((Object)process2, (String)"process");
        super(new BorderLayout());
        this.process = process2;
        this.model = new ProfilerModel();
        this.table = new JBTable((TableModel)((Object)this.model));
        this.add((Component)ScrollPaneFactory.createScrollPane((Component)((Component)this.table)), "Center");
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\tH\u0016J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0002H\u0016R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lcom/immomo/emmylua/lua/debugger/attach/ProfilerPanel$CallColumnInfo;", "Lcom/intellij/util/ui/ColumnInfo;", "Lcom/immomo/emmylua/lua/debugger/attach/DMProfilerCall;", "", "name", "index", "", "(Lcom/immomo/emmylua/lua/debugger/attach/ProfilerPanel;Ljava/lang/String;I)V", "comparator", "Ljava/util/Comparator;", "getIndex", "()I", "getComparator", "valueOf", "call", "MMPaas"})
    public final class CallColumnInfo
    extends ColumnInfo<DMProfilerCall, String> {
        private final Comparator<DMProfilerCall> comparator;
        private final int index;

        @NotNull
        public String valueOf(@NotNull DMProfilerCall call) {
            String string;
            Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
            switch (this.index) {
                case 0: {
                    string = call.getFunctionName();
                    break;
                }
                case 1: {
                    string = call.getFile();
                    break;
                }
                case 2: {
                    string = String.valueOf(call.getLine());
                    break;
                }
                case 3: {
                    string = String.valueOf(call.getCount());
                    break;
                }
                case 4: {
                    string = String.valueOf((float)call.getTime() / (float)call.getCount());
                    break;
                }
                default: {
                    string = "unknown";
                }
            }
            return string;
        }

        @NotNull
        public Comparator<DMProfilerCall> getComparator() {
            return this.comparator;
        }

        public final int getIndex() {
            return this.index;
        }

        public CallColumnInfo(String name, int index) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            super(name);
            this.index = index;
            this.comparator = new Comparator<DMProfilerCall>(this){
                final /* synthetic */ CallColumnInfo this$0;

                /*
                 * WARNING - void declaration
                 */
                public final int compare(DMProfilerCall o1, DMProfilerCall o2) {
                    int n;
                    switch (this.this$0.getIndex()) {
                        case 0: {
                            n = o1.getFunctionName().compareTo(o2.getFunctionName());
                            break;
                        }
                        case 1: {
                            void var3_3;
                            int r = o1.getFile().compareTo(o2.getFile());
                            if (r == 0) {
                                r = Intrinsics.compare((int)o1.getLine(), (int)o2.getLine());
                            }
                            n = var3_3;
                            break;
                        }
                        case 2: {
                            n = Intrinsics.compare((int)o1.getLine(), (int)o2.getLine());
                            break;
                        }
                        case 3: {
                            n = Intrinsics.compare((int)o1.getCount(), (int)o2.getCount());
                            break;
                        }
                        case 4: {
                            n = Intrinsics.compare((int)o1.getTime(), (int)o2.getTime());
                            break;
                        }
                        default: {
                            n = 0;
                        }
                    }
                    return n;
                }
                {
                    this.this$0 = callColumnInfo;
                }
            };
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/immomo/emmylua/lua/debugger/attach/ProfilerPanel$ProfilerModel;", "Lcom/intellij/util/ui/ListTableModel;", "Lcom/immomo/emmylua/lua/debugger/attach/DMProfilerCall;", "(Lcom/immomo/emmylua/lua/debugger/attach/ProfilerPanel;)V", "list", "", "update", "", "call", "MMPaas"})
    public final class ProfilerModel
    extends ListTableModel<DMProfilerCall> {
        private final List<DMProfilerCall> list;

        /*
         * WARNING - void declaration
         */
        public final void update(@NotNull DMProfilerCall call) {
            Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
            int n = 0;
            int n2 = this.list.size();
            while (n < n2) {
                void i;
                DMProfilerCall c = this.list.get((int)i);
                if (c.getId() == call.getId()) {
                    c.setCount(call.getCount());
                    c.setTime(call.getTime());
                    this.fireTableRowsUpdated((int)i, (int)i);
                    return;
                }
                ++i;
            }
            this.addRow(call);
        }

        public ProfilerModel() {
            List list;
            super(new ColumnInfo[]{new CallColumnInfo("Function", 0), new CallColumnInfo("File", 1), new CallColumnInfo("Line", 2), new CallColumnInfo("Count", 3), new CallColumnInfo("Average time", 4)});
            ProfilerModel profilerModel = this;
            profilerModel.list = list = (List)new ArrayList();
            this.setItems(this.list);
        }
    }
}

