/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.emmylua.lua.debugger.attach;

import com.immomo.emmylua.lua.debugger.attach.CodeState;
import com.immomo.emmylua.lua.debugger.attach.LuaAttachDebugProcessBase;
import com.immomo.emmylua.lua.debugger.attach.vfs.MemoryDataVirtualFile;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.EditorTabbedContainer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBList;
import com.intellij.util.IconUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0014B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\tJ\u0006\u0010\u0013\u001a\u00020\u0011R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0015"}, d2={"Lcom/immomo/emmylua/lua/debugger/attach/MemoryFilesPanel;", "Ljavax/swing/JPanel;", "project", "Lcom/intellij/openapi/project/Project;", "process", "Lcom/immomo/emmylua/lua/debugger/attach/LuaAttachDebugProcessBase;", "(Lcom/intellij/openapi/project/Project;Lcom/immomo/emmylua/lua/debugger/attach/LuaAttachDebugProcessBase;)V", "list", "Lcom/intellij/ui/components/JBList;", "Lcom/immomo/emmylua/lua/debugger/attach/vfs/MemoryDataVirtualFile;", "model", "Ljavax/swing/DefaultListModel;", "getProcess", "()Lcom/immomo/emmylua/lua/debugger/attach/LuaAttachDebugProcessBase;", "getProject", "()Lcom/intellij/openapi/project/Project;", "addFile", "", "virtualFile", "clear", "VirtualFilesRenderer", "MMPaas"})
public final class MemoryFilesPanel
extends JPanel {
    private final DefaultListModel<MemoryDataVirtualFile> model;
    private final JBList<MemoryDataVirtualFile> list;
    @NotNull
    private final Project project;
    @NotNull
    private final LuaAttachDebugProcessBase process;

    public final void addFile(@NotNull MemoryDataVirtualFile virtualFile) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)virtualFile), (String)"virtualFile");
        this.model.addElement(virtualFile);
    }

    public final void clear() {
        this.model.clear();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final LuaAttachDebugProcessBase getProcess() {
        return this.process;
    }

    public MemoryFilesPanel(@NotNull Project project, @NotNull LuaAttachDebugProcessBase process2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)process2, (String)"process");
        super(new BorderLayout());
        this.project = project;
        this.process = process2;
        this.model = new DefaultListModel();
        this.list = new JBList((ListModel)this.model);
        this.list.setCellRenderer((ListCellRenderer)((Object)new VirtualFilesRenderer()));
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public final void valueChanged(ListSelectionEvent it) {
                MemoryDataVirtualFile file = (MemoryDataVirtualFile)((Object)list.getSelectedValue());
                boolean isOpen = FileEditorManager.getInstance((Project)this.getProject()).isFileOpen((VirtualFile)file);
                if (!isOpen && file.getState() != CodeState.Unavailable) {
                    FileEditorManager.getInstance((Project)this.getProject()).openFile((VirtualFile)file, true);
                }
            }
        });
        this.list.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(@NotNull MouseEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            }

            @Override
            public void mouseEntered(@NotNull MouseEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            }

            @Override
            public void mouseClicked(@NotNull MouseEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            }

            @Override
            public void mouseExited(@NotNull MouseEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            }

            @Override
            public void mousePressed(@NotNull MouseEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            }
        });
        this.add((Component)ScrollPaneFactory.createScrollPane((Component)((Component)this.list)), "Center");
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0080\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J8\u0010\u0004\u001a\u00020\u00052\u000e\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0014\u00a8\u0006\u000e"}, d2={"Lcom/immomo/emmylua/lua/debugger/attach/MemoryFilesPanel$VirtualFilesRenderer;", "Lcom/intellij/ui/ColoredListCellRenderer;", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/immomo/emmylua/lua/debugger/attach/MemoryFilesPanel;)V", "customizeCellRenderer", "", "p0", "Ljavax/swing/JList;", "virtualFile", "index", "", "selected", "", "hasFocus", "MMPaas"})
    public final class VirtualFilesRenderer
    extends ColoredListCellRenderer<VirtualFile> {
        protected void customizeCellRenderer(@NotNull JList<? extends VirtualFile> p0, @NotNull VirtualFile virtualFile, int index, boolean selected, boolean hasFocus) {
            Intrinsics.checkParameterIsNotNull(p0, (String)"p0");
            Intrinsics.checkParameterIsNotNull((Object)virtualFile, (String)"virtualFile");
            this.setIcon(IconUtil.getIcon((VirtualFile)virtualFile, (int)2, (Project)MemoryFilesPanel.this.getProject()));
            String string = EditorTabbedContainer.calcFileName((Project)MemoryFilesPanel.this.getProject(), (VirtualFile)virtualFile);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"EditorTabbedContainer.ca\u2026ame(project, virtualFile)");
            String renderedName = string;
            FileStatus fileStatus = FileStatusManager.getInstance((Project)MemoryFilesPanel.this.getProject()).getStatus(virtualFile);
            boolean hasProblem = WolfTheProblemSolver.getInstance((Project)MemoryFilesPanel.this.getProject()).isProblemFile(virtualFile);
            FileStatus fileStatus2 = fileStatus;
            Intrinsics.checkExpressionValueIsNotNull((Object)fileStatus2, (String)"fileStatus");
            TextAttributes attributes = new TextAttributes(fileStatus2.getColor(), null, (Color)(hasProblem ? JBColor.red : null), EffectType.WAVE_UNDERSCORE, 0);
            this.append(renderedName, SimpleTextAttributes.fromTextAttributes((TextAttributes)attributes));
            Color color = EditorTabbedContainer.calcTabColor((Project)MemoryFilesPanel.this.getProject(), (VirtualFile)virtualFile);
            if (!selected && color != null) {
                this.setBackground(color);
            }
        }
    }
}

