/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.emmylua.lua.debugger.attach;

import com.immomo.emmylua.lua.debugger.attach.DMBreak;
import com.immomo.emmylua.lua.debugger.attach.LuaAttachDebugProcessBase;
import com.immomo.emmylua.lua.debugger.attach.LuaAttachDebuggerEvaluator;
import com.intellij.icons.AllIcons;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValueChildrenList;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\n\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J\n\u0010\u001f\u001a\u0004\u0018\u00010\u0007H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0010\u0010\n\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006 "}, d2={"Lcom/immomo/emmylua/lua/debugger/attach/LuaAttachStackFrame;", "Lcom/intellij/xdebugger/frame/XStackFrame;", "proto", "Lcom/immomo/emmylua/lua/debugger/attach/DMBreak;", "childrenList", "Lcom/intellij/xdebugger/frame/XValueChildrenList;", "position", "Lcom/intellij/xdebugger/XSourcePosition;", "function", "", "scriptName", "stack", "", "(Lcom/immomo/emmylua/lua/debugger/attach/DMBreak;Lcom/intellij/xdebugger/frame/XValueChildrenList;Lcom/intellij/xdebugger/XSourcePosition;Ljava/lang/String;Ljava/lang/String;I)V", "evaluator", "Lcom/immomo/emmylua/lua/debugger/attach/LuaAttachDebuggerEvaluator;", "process", "Lcom/immomo/emmylua/lua/debugger/attach/LuaAttachDebugProcessBase;", "getProto", "()Lcom/immomo/emmylua/lua/debugger/attach/DMBreak;", "getStack", "()I", "computeChildren", "", "node", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "customizePresentation", "component", "Lcom/intellij/ui/ColoredTextContainer;", "getEvaluator", "Lcom/intellij/xdebugger/evaluation/XDebuggerEvaluator;", "getSourcePosition", "MMPaas"})
public final class LuaAttachStackFrame
extends XStackFrame {
    private final LuaAttachDebugProcessBase process;
    private LuaAttachDebuggerEvaluator evaluator;
    @NotNull
    private final DMBreak proto;
    private final XValueChildrenList childrenList;
    private final XSourcePosition position;
    private final String function;
    private final String scriptName;
    private final int stack;

    public void computeChildren(@NotNull XCompositeNode node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        node.addChildren(this.childrenList, true);
    }

    public void customizePresentation(@NotNull ColoredTextContainer component) {
        Intrinsics.checkParameterIsNotNull((Object)component, (String)"component");
        if (this.function != null) {
            component.append(this.function, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            if (this.scriptName != null) {
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string = "(%s)";
                Object[] objectArray = new Object[]{this.scriptName};
                ColoredTextContainer coloredTextContainer = component;
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
                String string3 = string2;
                coloredTextContainer.append(string3, SimpleTextAttributes.GRAY_ATTRIBUTES);
            }
        } else {
            component.append("invalid", SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
        component.setIcon(AllIcons.Debugger.StackFrame);
    }

    @Nullable
    public XDebuggerEvaluator getEvaluator() {
        if (this.evaluator == null && this.scriptName != null) {
            this.evaluator = new LuaAttachDebuggerEvaluator(this.process, this);
        }
        return this.evaluator;
    }

    @Nullable
    public XSourcePosition getSourcePosition() {
        return this.position;
    }

    @NotNull
    public final DMBreak getProto() {
        return this.proto;
    }

    public final int getStack() {
        return this.stack;
    }

    public LuaAttachStackFrame(@NotNull DMBreak proto, @NotNull XValueChildrenList childrenList, @Nullable XSourcePosition position, @Nullable String function, @Nullable String scriptName, int stack) {
        Intrinsics.checkParameterIsNotNull((Object)proto, (String)"proto");
        Intrinsics.checkParameterIsNotNull((Object)childrenList, (String)"childrenList");
        this.proto = proto;
        this.childrenList = childrenList;
        this.position = position;
        this.function = function;
        this.scriptName = scriptName;
        this.stack = stack;
        this.process = this.proto.getProcess();
    }
}

