/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.emmylua.lua.debugger.attach;

import com.immomo.emmylua.lua.debugger.LogConsoleType;
import com.immomo.emmylua.lua.debugger.LuaDebugProcess;
import com.immomo.emmylua.lua.debugger.LuaDebuggerEditorsProvider;
import com.immomo.emmylua.lua.debugger.attach.CodeState;
import com.immomo.emmylua.lua.debugger.attach.DMBreak;
import com.immomo.emmylua.lua.debugger.attach.DMException;
import com.immomo.emmylua.lua.debugger.attach.DMLoadError;
import com.immomo.emmylua.lua.debugger.attach.DMLoadScript;
import com.immomo.emmylua.lua.debugger.attach.DMMessage;
import com.immomo.emmylua.lua.debugger.attach.DMReqReloadScript;
import com.immomo.emmylua.lua.debugger.attach.DMRespProfilerData;
import com.immomo.emmylua.lua.debugger.attach.DMStdin;
import com.immomo.emmylua.lua.debugger.attach.DebugMessageId;
import com.immomo.emmylua.lua.debugger.attach.IncompleteString;
import com.immomo.emmylua.lua.debugger.attach.LoadedScript;
import com.immomo.emmylua.lua.debugger.attach.LuaAttachBridgeBase;
import com.immomo.emmylua.lua.debugger.attach.LuaAttachDebugProcessBase;
import com.immomo.emmylua.lua.debugger.attach.LuaAttachDebugProcessBase$WhenMappings;
import com.immomo.emmylua.lua.debugger.attach.LuaAttachDebugProcessBase$handle$;
import com.immomo.emmylua.lua.debugger.attach.LuaAttachDebugProcessBase$sam$com_intellij_execution_filters_HyperlinkInfo$0;
import com.immomo.emmylua.lua.debugger.attach.LuaAttachDebugProcessBase$sessionInitialized$;
import com.immomo.emmylua.lua.debugger.attach.LuaAttachMessage;
import com.immomo.emmylua.lua.debugger.attach.LuaVMPanel;
import com.immomo.emmylua.lua.debugger.attach.MemoryFilesPanel;
import com.immomo.emmylua.lua.debugger.attach.ProfilerPanel;
import com.immomo.emmylua.lua.debugger.attach.vfs.MemoryDataVirtualFile;
import com.immomo.emmylua.lua.debugger.attach.vfs.MemoryFileSystem;
import com.immomo.emmylua.lua.debugger.attach.vfs.MemoryVirtualFile;
import com.immomo.emmylua.lua.lang.LuaIcons;
import com.immomo.emmylua.lua.project.LLuaSettings;
import com.immomo.emmylua.lua.psi.LuaFileUtil;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.impl.ConsoleState;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.RunContentBuilder;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.content.Content;
import com.intellij.util.PathUtil;
import com.intellij.util.Processor;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.ui.XDebugTabLayouter;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0080\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010.\u001a\u00020/H\u0016J\u0010\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0002J\u0010\u00104\u001a\u0002052\u0006\u00106\u001a\u000207H\u0002J\u0010\u00108\u001a\u0002012\u0006\u00102\u001a\u000203H\u0002J\u0010\u00109\u001a\u0002012\u0006\u00102\u001a\u000203H\u0002J\b\u0010:\u001a\u00020;H\u0016J\u0010\u0010<\u001a\u0002012\u0006\u00102\u001a\u000203H\u0002J\u0012\u0010=\u001a\u0004\u0018\u0001052\b\u0010>\u001a\u0004\u0018\u00010?J\b\u0010@\u001a\u00020AH\u0016J\u0010\u0010B\u001a\u0004\u0018\u00010\u001d2\u0006\u0010C\u001a\u00020\u001cJ\u0010\u0010D\u001a\u0002012\u0006\u0010E\u001a\u00020FH\u0016J\u0010\u0010G\u001a\u0002012\u0006\u0010E\u001a\u00020HH\u0002J\u0010\u0010I\u001a\u0002012\u0006\u0010J\u001a\u00020KH\u0002J\u0010\u0010L\u001a\u0002012\u0006\u0010J\u001a\u00020MH\u0002J\u0010\u0010N\u001a\u0002012\u0006\u0010J\u001a\u000207H\u0002J\u0010\u0010O\u001a\u0002012\u0006\u0010E\u001a\u00020PH\u0002J \u0010Q\u001a\u0002012\u0006\u0010R\u001a\u00020?2\u0006\u0010S\u001a\u00020T2\u0006\u0010U\u001a\u00020VH\u0016J;\u0010W\u001a\u0002012\u0006\u0010R\u001a\u00020?2\u0006\u0010S\u001a\u00020T2!\u0010X\u001a\u001d\u0012\u0013\u0012\u00110Z\u00a2\u0006\f\b[\u0012\b\b>\u0012\u0004\b\b(\\\u0012\u0004\u0012\u0002010YH\u0016J \u0010]\u001a\u0002012\u0006\u0010^\u001a\u00020_2\u0006\u0010`\u001a\u00020_2\u0006\u0010a\u001a\u00020_H\u0016J\u001c\u0010b\u001a\u0002012\u0006\u0010c\u001a\u00020d2\n\u0010e\u001a\u0006\u0012\u0002\b\u00030fH\u0014J\b\u0010g\u001a\u000201H\u0014J\b\u0010h\u001a\u000201H\u0016J\b\u0010i\u001a\u00020\u0007H$J\b\u0010j\u001a\u000201H\u0016J\u0012\u0010k\u001a\u0002012\b\u0010l\u001a\u0004\u0018\u00010mH\u0016J\u0012\u0010n\u001a\u0002012\b\u0010l\u001a\u0004\u0018\u00010mH\u0016J\u0012\u0010o\u001a\u0002012\b\u0010l\u001a\u0004\u0018\u00010mH\u0016J\b\u0010p\u001a\u000201H\u0016J\u001c\u0010q\u001a\u0002012\u0006\u0010c\u001a\u00020d2\n\u0010e\u001a\u0006\u0012\u0002\b\u00030fH\u0014R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u00020\u0015X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082.\u00a2\u0006\u0002\n\u0000R$\u0010%\u001a\u00020\u00152\u0006\u0010$\u001a\u00020\u00158F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b&\u0010\u0017\"\u0004\b'\u0010\u0019R\u000e\u0010(\u001a\u00020)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020-X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006r"}, d2={"Lcom/immomo/emmylua/lua/debugger/attach/LuaAttachDebugProcessBase;", "Lcom/immomo/emmylua/lua/debugger/LuaDebugProcess;", "Lcom/immomo/emmylua/lua/debugger/attach/LuaAttachBridgeBase$ProtoHandler;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "(Lcom/intellij/xdebugger/XDebugSession;)V", "bridge", "Lcom/immomo/emmylua/lua/debugger/attach/LuaAttachBridgeBase;", "getBridge", "()Lcom/immomo/emmylua/lua/debugger/attach/LuaAttachBridgeBase;", "setBridge", "(Lcom/immomo/emmylua/lua/debugger/attach/LuaAttachBridgeBase;)V", "charset", "Ljava/nio/charset/Charset;", "getCharset", "()Ljava/nio/charset/Charset;", "editorsProvider", "Lcom/immomo/emmylua/lua/debugger/LuaDebuggerEditorsProvider;", "emmyConsole", "Lcom/intellij/execution/ui/ConsoleView;", "emmyInputEnabled", "", "getEmmyInputEnabled", "()Z", "setEmmyInputEnabled", "(Z)V", "loadedScriptMap", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/immomo/emmylua/lua/debugger/attach/LoadedScript;", "memoryFileSystem", "Lcom/immomo/emmylua/lua/debugger/attach/vfs/MemoryFileSystem;", "memoryFilesPanel", "Lcom/immomo/emmylua/lua/debugger/attach/MemoryFilesPanel;", "profilerPanel", "Lcom/immomo/emmylua/lua/debugger/attach/ProfilerPanel;", "value", "profilerState", "getProfilerState", "setProfilerState", "stderrIncompleteString", "Lcom/immomo/emmylua/lua/debugger/attach/IncompleteString;", "stdoutIncompleteString", "toggleProfiler", "vmPanel", "Lcom/immomo/emmylua/lua/debugger/attach/LuaVMPanel;", "createConsole", "Lcom/intellij/execution/ui/ExecutionConsole;", "createEmmyConsole", "", "ui", "Lcom/intellij/execution/ui/RunnerLayoutUi;", "createMemoryFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "dm", "Lcom/immomo/emmylua/lua/debugger/attach/DMLoadScript;", "createMemoryFilesPanel", "createProfilerPanel", "createTabLayouter", "Lcom/intellij/xdebugger/ui/XDebugTabLayouter;", "createVMPanel", "findFile", "name", "", "getEditorsProvider", "Lcom/intellij/xdebugger/evaluation/XDebuggerEditorsProvider;", "getScript", "index", "handle", "message", "Lcom/immomo/emmylua/lua/debugger/attach/LuaAttachMessage;", "handleLogMessage", "Lcom/immomo/emmylua/lua/debugger/attach/DMMessage;", "onBreak", "proto", "Lcom/immomo/emmylua/lua/debugger/attach/DMBreak;", "onLoadError", "Lcom/immomo/emmylua/lua/debugger/attach/DMLoadError;", "onLoadScript", "onProfilerData", "Lcom/immomo/emmylua/lua/debugger/attach/DMRespProfilerData;", "print", "text", "consoleType", "Lcom/immomo/emmylua/lua/debugger/LogConsoleType;", "contentType", "Lcom/intellij/execution/ui/ConsoleViewContentType;", "printHyperlink", "handler", "Lkotlin/Function1;", "Lcom/intellij/openapi/project/Project;", "Lkotlin/ParameterName;", "project", "registerAdditionalActions", "leftToolbar", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "topToolbar", "settings", "registerBreakpoint", "sourcePosition", "Lcom/intellij/xdebugger/XSourcePosition;", "breakpoint", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;", "run", "sessionInitialized", "startBridge", "startPausing", "startStepInto", "context", "Lcom/intellij/xdebugger/frame/XSuspendContext;", "startStepOut", "startStepOver", "stop", "unregisterBreakpoint", "MMPaas"})
public abstract class LuaAttachDebugProcessBase
extends LuaDebugProcess
implements LuaAttachBridgeBase.ProtoHandler {
    @NotNull
    public LuaAttachBridgeBase bridge;
    private final LuaDebuggerEditorsProvider editorsProvider;
    private final ConcurrentHashMap<Integer, LoadedScript> loadedScriptMap;
    private LuaVMPanel vmPanel;
    private MemoryFilesPanel memoryFilesPanel;
    private ProfilerPanel profilerPanel;
    private boolean toggleProfiler;
    private final MemoryFileSystem memoryFileSystem;
    private boolean emmyInputEnabled;
    private ConsoleView emmyConsole;
    private IncompleteString stdoutIncompleteString;
    private IncompleteString stderrIncompleteString;

    @NotNull
    public final LuaAttachBridgeBase getBridge() {
        LuaAttachBridgeBase luaAttachBridgeBase = this.bridge;
        if (luaAttachBridgeBase == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bridge");
        }
        return luaAttachBridgeBase;
    }

    public final void setBridge(@NotNull LuaAttachBridgeBase luaAttachBridgeBase) {
        Intrinsics.checkParameterIsNotNull((Object)luaAttachBridgeBase, (String)"<set-?>");
        this.bridge = luaAttachBridgeBase;
    }

    protected final boolean getEmmyInputEnabled() {
        return this.emmyInputEnabled;
    }

    protected final void setEmmyInputEnabled(boolean bl) {
        this.emmyInputEnabled = bl;
    }

    @NotNull
    public Charset getCharset() {
        return LLuaSettings.Companion.getInstance().getAttachDebugDefaultCharset();
    }

    @NotNull
    protected abstract LuaAttachBridgeBase startBridge();

    @Override
    public void sessionInitialized() {
        Application application;
        super.sessionInitialized();
        this.bridge = this.startBridge();
        Application $receiver = application = ApplicationManager.getApplication();
        boolean bl = false;
        $receiver.invokeLater(new Runnable($receiver, this){
            final /* synthetic */ Application $this_with;
            final /* synthetic */ LuaAttachDebugProcessBase this$0;
            {
                this.$this_with = application;
                this.this$0 = luaAttachDebugProcessBase;
            }

            public final void run() {
                this.$this_with.runWriteAction(new Runnable(this){
                    final /* synthetic */ sessionInitialized$$inlined$with$lambda$1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final void run() {
                        VirtualFile[] $receiver$iv;
                        FileEditorManager fileEditorManager;
                        int n;
                        XBreakpoint[] $receiver$iv2;
                        XDebuggerManager manager;
                        XDebugSession xDebugSession = this.this$0.this$0.getSession();
                        Intrinsics.checkExpressionValueIsNotNull((Object)xDebugSession, (String)"session");
                        XDebuggerManager xDebuggerManager = manager = XDebuggerManager.getInstance((Project)xDebugSession.getProject());
                        Intrinsics.checkExpressionValueIsNotNull((Object)xDebuggerManager, (String)"manager");
                        XBreakpointManager xBreakpointManager = xDebuggerManager.getBreakpointManager();
                        Intrinsics.checkExpressionValueIsNotNull((Object)xBreakpointManager, (String)"manager.breakpointManager");
                        XBreakpoint[] xBreakpointArray = xBreakpointManager.getAllBreakpoints();
                        Intrinsics.checkExpressionValueIsNotNull((Object)xBreakpointArray, (String)"manager.breakpointManager.allBreakpoints");
                        XBreakpoint[] xBreakpointArray2 = $receiver$iv2 = xBreakpointArray;
                        int n2 = xBreakpointArray2.length;
                        for (n = 0; n < n2; ++n) {
                            XBreakpoint element$iv;
                            XBreakpoint it = element$iv = xBreakpointArray2[n];
                            boolean bl = false;
                            if (!(it instanceof XLineBreakpoint)) continue;
                            String string = ((XLineBreakpoint)it).getFileUrl();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.fileUrl");
                            if (!StringsKt.startsWith$default((String)string, (String)"llua-dummy", (boolean)false, (int)2, null)) continue;
                            manager.getBreakpointManager().removeBreakpoint(it);
                        }
                        XDebugSession xDebugSession2 = this.this$0.this$0.getSession();
                        Intrinsics.checkExpressionValueIsNotNull((Object)xDebugSession2, (String)"session");
                        FileEditorManager fileEditorManager2 = fileEditorManager = FileEditorManager.getInstance((Project)xDebugSession2.getProject());
                        Intrinsics.checkExpressionValueIsNotNull((Object)fileEditorManager2, (String)"fileEditorManager");
                        VirtualFile[] virtualFileArray = fileEditorManager2.getOpenFiles();
                        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFileArray, (String)"fileEditorManager.openFiles");
                        VirtualFile[] virtualFileArray2 = $receiver$iv = virtualFileArray;
                        n = virtualFileArray2.length;
                        for (int i = 0; i < n; ++i) {
                            VirtualFile element$iv;
                            VirtualFile it = element$iv = virtualFileArray2[i];
                            boolean bl = false;
                            if (!(it instanceof MemoryVirtualFile)) continue;
                            fileEditorManager.closeFile(it);
                        }
                        LuaAttachDebugProcessBase.access$getMemoryFileSystem$p(this.this$0.this$0).clear();
                        LuaAttachDebugProcessBase.access$getMemoryFilesPanel$p(this.this$0.this$0).clear();
                    }
                });
            }
        });
    }

    @NotNull
    public XDebuggerEditorsProvider getEditorsProvider() {
        return (XDebuggerEditorsProvider)this.editorsProvider;
    }

    public void startStepOver(@Nullable XSuspendContext context2) {
        LuaAttachBridgeBase luaAttachBridgeBase = this.bridge;
        if (luaAttachBridgeBase == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bridge");
        }
        luaAttachBridgeBase.send(new LuaAttachMessage(DebugMessageId.StepOver));
    }

    public void startStepInto(@Nullable XSuspendContext context2) {
        LuaAttachBridgeBase luaAttachBridgeBase = this.bridge;
        if (luaAttachBridgeBase == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bridge");
        }
        luaAttachBridgeBase.send(new LuaAttachMessage(DebugMessageId.StepInto));
    }

    @Override
    public void startStepOut(@Nullable XSuspendContext context2) {
        LuaAttachBridgeBase luaAttachBridgeBase = this.bridge;
        if (luaAttachBridgeBase == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bridge");
        }
        luaAttachBridgeBase.send(new LuaAttachMessage(DebugMessageId.StepOut));
    }

    public void startPausing() {
    }

    public void stop() {
        LuaAttachBridgeBase luaAttachBridgeBase = this.bridge;
        if (luaAttachBridgeBase == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bridge");
        }
        luaAttachBridgeBase.stop();
    }

    @Override
    protected void run() {
        LuaAttachBridgeBase luaAttachBridgeBase = this.bridge;
        if (luaAttachBridgeBase == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bridge");
        }
        luaAttachBridgeBase.sendRun();
    }

    public final boolean getProfilerState() {
        return this.toggleProfiler;
    }

    public final void setProfilerState(boolean value) {
        LuaAttachMessage dm = value ? new LuaAttachMessage(DebugMessageId.ReqProfilerBegin) : new LuaAttachMessage(DebugMessageId.ReqProfilerEnd);
        LuaAttachBridgeBase luaAttachBridgeBase = this.bridge;
        if (luaAttachBridgeBase == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bridge");
        }
        luaAttachBridgeBase.send(dm);
    }

    @Override
    public void handle(@NotNull LuaAttachMessage message2) {
        Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
        LuaAttachMessage luaAttachMessage = message2;
        if (luaAttachMessage instanceof DMLoadScript) {
            Application application;
            Application $receiver = application = ApplicationManager.getApplication();
            boolean bl = false;
            $receiver.invokeLater(new Runnable($receiver, this, message2){
                final /* synthetic */ Application $this_with;
                final /* synthetic */ LuaAttachDebugProcessBase this$0;
                final /* synthetic */ LuaAttachMessage $message$inlined;
                {
                    this.$this_with = application;
                    this.this$0 = luaAttachDebugProcessBase;
                    this.$message$inlined = luaAttachMessage;
                }

                public final void run() {
                    this.$this_with.runWriteAction(new Runnable(this){
                        final /* synthetic */ handle$$inlined$with$lambda$1 this$0;
                        {
                            this.this$0 = var1_1;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public final void run() {
                            try {
                                LuaAttachDebugProcessBase.access$onLoadScript(this.this$0.this$0, (DMLoadScript)this.this$0.$message$inlined);
                            }
                            finally {
                                this.this$0.this$0.getBridge().sendDone();
                            }
                        }
                    });
                }
            });
        } else if (luaAttachMessage instanceof DMBreak) {
            this.onBreak((DMBreak)message2);
        } else if (luaAttachMessage instanceof DMException) {
            ((DMException)message2).print();
        } else if (luaAttachMessage instanceof DMMessage) {
            this.handleLogMessage((DMMessage)message2);
        } else if (luaAttachMessage instanceof DMRespProfilerData) {
            this.onProfilerData((DMRespProfilerData)message2);
        } else if (luaAttachMessage instanceof DMLoadError) {
            this.onLoadError((DMLoadError)message2);
        } else {
            switch (LuaAttachDebugProcessBase$WhenMappings.$EnumSwitchMapping$0[message2.getId().ordinal()]) {
                case 1: {
                    LuaAttachBridgeBase luaAttachBridgeBase = this.bridge;
                    if (luaAttachBridgeBase == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"bridge");
                    }
                    luaAttachBridgeBase.stop();
                    this.getSession().stop();
                    break;
                }
                case 2: {
                    LuaVMPanel luaVMPanel = this.vmPanel;
                    if (luaVMPanel == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"vmPanel");
                    }
                    luaVMPanel.addVM(message2);
                    break;
                }
                case 3: {
                    LuaVMPanel luaVMPanel = this.vmPanel;
                    if (luaVMPanel == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"vmPanel");
                    }
                    luaVMPanel.removeVM(message2);
                    break;
                }
                case 4: {
                    this.toggleProfiler = true;
                    break;
                }
                case 5: {
                    this.toggleProfiler = false;
                    break;
                }
                default: {
                    String string = "unknown message : " + (Object)((Object)message2.getId());
                    System.out.println((Object)string);
                }
            }
        }
    }

    private final void handleLogMessage(DMMessage message2) {
        switch (message2.getType()) {
            case 3: {
                this.stdoutIncompleteString.append(message2.getBytes());
                String text = this.stdoutIncompleteString.decode(this.getCharset());
                ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.NORMAL_OUTPUT;
                Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType, (String)"ConsoleViewContentType.NORMAL_OUTPUT");
                this.print(text, LogConsoleType.NORMAL, consoleViewContentType);
                break;
            }
            case 4: {
                this.stderrIncompleteString.append(message2.getBytes());
                String text = this.stderrIncompleteString.decode(this.getCharset());
                ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.ERROR_OUTPUT;
                Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType, (String)"ConsoleViewContentType.ERROR_OUTPUT");
                this.print(text, LogConsoleType.NORMAL, consoleViewContentType);
                break;
            }
            default: {
                message2.print();
            }
        }
    }

    private final void onProfilerData(DMRespProfilerData message2) {
        ProfilerPanel profilerPanel = this.profilerPanel;
        if (profilerPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"profilerPanel");
        }
        profilerPanel.updateProfiler(message2);
    }

    @Nullable
    public final VirtualFile findFile(@Nullable String name) {
        String path;
        if (name == null) {
            return null;
        }
        String string = path = PathUtil.getCanonicalPath((String)name);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"path");
        VirtualFile f = this.memoryFileSystem.findMemoryFile(string);
        if (f != null) {
            return f;
        }
        XDebugSession xDebugSession = this.getSession();
        Intrinsics.checkExpressionValueIsNotNull((Object)xDebugSession, (String)"session");
        return LuaFileUtil.findFile(xDebugSession.getProject(), path);
    }

    private final void onBreak(DMBreak proto) {
        VirtualFile file = this.findFile(proto.getName());
        if (file == null) {
            LuaAttachBridgeBase luaAttachBridgeBase = this.bridge;
            if (luaAttachBridgeBase == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bridge");
            }
            luaAttachBridgeBase.sendRun();
            return;
        }
        this.setStack(proto.getStack());
    }

    private final void onLoadScript(DMLoadScript proto) {
        String virtualFile;
        Object object = this.loadedScriptMap;
        for (Map.Entry entry : object.entrySet()) {
            if (!Intrinsics.areEqual((Object)((LoadedScript)entry.getValue()).getName(), (Object)proto.getFileName())) continue;
            this.loadedScriptMap.remove(entry.getKey());
            break;
        }
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = this.findFile(proto.getFileName());
        if ((VirtualFile)objectRef.element == null) {
            if (proto.getState() != CodeState.Unavailable) {
                objectRef.element = this.createMemoryFile(proto);
                ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.SYSTEM_OUTPUT;
                Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType, (String)"ConsoleViewContentType.SYSTEM_OUTPUT");
                this.print("[\u2714] Load memory file : ", LogConsoleType.EMMY, consoleViewContentType);
                virtualFile = (VirtualFile)objectRef.element;
                this.printHyperlink(proto.getFileName(), LogConsoleType.EMMY, (Function1<? super Project, Unit>)((Function1)new Function1<Project, Unit>((VirtualFile)virtualFile){
                    final /* synthetic */ VirtualFile $virtualFile;

                    public final void invoke(@NotNull Project it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        FileEditorManager.getInstance((Project)it).openFile(this.$virtualFile, true);
                    }
                    {
                        this.$virtualFile = virtualFile;
                        super(1);
                    }
                }));
                ConsoleViewContentType consoleViewContentType2 = ConsoleViewContentType.SYSTEM_OUTPUT;
                Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType2, (String)"ConsoleViewContentType.SYSTEM_OUTPUT");
                this.print("\n", LogConsoleType.EMMY, consoleViewContentType2);
            }
        } else {
            if ((VirtualFile)objectRef.element instanceof MemoryDataVirtualFile) {
                virtualFile = proto.getSource();
                VirtualFile virtualFile2 = (VirtualFile)objectRef.element;
                object = Charsets.UTF_8;
                String string = virtualFile;
                if (string == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                byte[] byArray = string.getBytes((Charset)object);
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                byte[] byArray2 = byArray;
                virtualFile2.setBinaryContent(byArray2);
                ((MemoryDataVirtualFile)((VirtualFile)objectRef.element)).setState(proto.getState());
            }
            ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.SYSTEM_OUTPUT;
            Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType, (String)"ConsoleViewContentType.SYSTEM_OUTPUT");
            this.print("[\u2714] File was loaded :", LogConsoleType.EMMY, consoleViewContentType);
            virtualFile = (VirtualFile)objectRef.element;
            this.printHyperlink(proto.getFileName(), LogConsoleType.EMMY, (Function1<? super Project, Unit>)((Function1)new Function1<Project, Unit>((VirtualFile)virtualFile){
                final /* synthetic */ VirtualFile $virtualFile;

                public final void invoke(@NotNull Project it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    FileEditorManager.getInstance((Project)it).openFile(this.$virtualFile, true);
                }
                {
                    this.$virtualFile = virtualFile;
                    super(1);
                }
            }));
            ConsoleViewContentType consoleViewContentType3 = ConsoleViewContentType.SYSTEM_OUTPUT;
            Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType3, (String)"ConsoleViewContentType.SYSTEM_OUTPUT");
            this.print("\n", LogConsoleType.EMMY, consoleViewContentType3);
        }
        if ((VirtualFile)objectRef.element != null) {
            LoadedScript script = new LoadedScript((VirtualFile)objectRef.element, proto.getIndex(), proto.getFileName(), proto.getState());
            object = this.loadedScriptMap;
            Integer n = proto.getIndex();
            LoadedScript loadedScript = script;
            object.put(n, loadedScript);
            this.processBreakpoint((Processor)new Processor<XLineBreakpoint<?>>(this, objectRef, proto){
                final /* synthetic */ LuaAttachDebugProcessBase this$0;
                final /* synthetic */ Ref.ObjectRef $file;
                final /* synthetic */ DMLoadScript $proto;

                public final boolean process(XLineBreakpoint<?> it) {
                    XLineBreakpoint<?> xLineBreakpoint = it;
                    Intrinsics.checkExpressionValueIsNotNull(xLineBreakpoint, (String)"it");
                    XSourcePosition pos = xLineBreakpoint.getSourcePosition();
                    if (pos != null && LuaFileUtil.fileEquals((VirtualFile)this.$file.element, pos.getFile())) {
                        this.this$0.getBridge().addBreakpoint(this.$proto.getIndex(), it);
                    }
                    return true;
                }
                {
                    this.this$0 = luaAttachDebugProcessBase;
                    this.$file = objectRef;
                    this.$proto = dMLoadScript;
                }
            });
        } else {
            ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.SYSTEM_OUTPUT;
            Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType, (String)"ConsoleViewContentType.SYSTEM_OUTPUT");
            this.print("[\u2718] File not found ", LogConsoleType.EMMY, consoleViewContentType);
            this.printHyperlink("[TRY MEMORY FILE]", LogConsoleType.EMMY, (Function1<? super Project, Unit>)((Function1)new Function1<Project, Unit>(this, proto){
                final /* synthetic */ LuaAttachDebugProcessBase this$0;
                final /* synthetic */ DMLoadScript $proto;

                public final void invoke(@NotNull Project it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    this.this$0.getBridge().send(new DMReqReloadScript(this.$proto.getIndex()));
                }
                {
                    this.this$0 = luaAttachDebugProcessBase;
                    this.$proto = dMLoadScript;
                    super(1);
                }
            }));
            String string = ": " + proto.getFileName() + '\n';
            ConsoleViewContentType consoleViewContentType4 = ConsoleViewContentType.SYSTEM_OUTPUT;
            Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType4, (String)"ConsoleViewContentType.SYSTEM_OUTPUT");
            this.print(string, LogConsoleType.EMMY, consoleViewContentType4);
        }
    }

    private final void onLoadError(DMLoadError proto) {
        this.error(proto.getMessage(), LogConsoleType.NORMAL);
    }

    private final VirtualFile createMemoryFile(DMLoadScript dm) {
        VirtualFile virtualFile = this.memoryFileSystem.createChildFile(this, this.memoryFileSystem.getRoot(), dm.getFileName());
        if (virtualFile == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.immomo.emmylua.lua.debugger.attach.vfs.MemoryDataVirtualFile");
        }
        MemoryDataVirtualFile childFile = (MemoryDataVirtualFile)virtualFile;
        childFile.setIndex(dm.getIndex());
        childFile.setState(dm.getState());
        String string = dm.getSource();
        MemoryDataVirtualFile memoryDataVirtualFile = childFile;
        Charset charset = Charsets.UTF_8;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        memoryDataVirtualFile.setBinaryContent(byArray2);
        MemoryFilesPanel memoryFilesPanel = this.memoryFilesPanel;
        if (memoryFilesPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"memoryFilesPanel");
        }
        memoryFilesPanel.addFile(childFile);
        return childFile;
    }

    @Override
    protected void registerBreakpoint(@NotNull XSourcePosition sourcePosition, @NotNull XLineBreakpoint<?> breakpoint) {
        Intrinsics.checkParameterIsNotNull((Object)sourcePosition, (String)"sourcePosition");
        Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
        super.registerBreakpoint(sourcePosition, breakpoint);
        for (LoadedScript script : this.loadedScriptMap.values()) {
            if (!LuaFileUtil.fileEquals(sourcePosition.getFile(), script.getFile())) continue;
            LuaAttachBridgeBase luaAttachBridgeBase = this.bridge;
            if (luaAttachBridgeBase == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bridge");
            }
            luaAttachBridgeBase.addBreakpoint(script.getIndex(), breakpoint);
            break;
        }
    }

    @Override
    protected void unregisterBreakpoint(@NotNull XSourcePosition sourcePosition, @NotNull XLineBreakpoint<?> breakpoint) {
        Intrinsics.checkParameterIsNotNull((Object)sourcePosition, (String)"sourcePosition");
        Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
        super.unregisterBreakpoint(sourcePosition, breakpoint);
        VirtualFile virtualFile = sourcePosition.getFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"sourcePosition.file");
        VirtualFile sourceFile = virtualFile;
        for (LoadedScript script : this.loadedScriptMap.values()) {
            VirtualFile scriptFile = script.getFile();
            if (!LuaFileUtil.fileEquals(sourceFile, scriptFile)) continue;
            LuaAttachBridgeBase luaAttachBridgeBase = this.bridge;
            if (luaAttachBridgeBase == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bridge");
            }
            luaAttachBridgeBase.removeBreakpoint(script.getIndex(), breakpoint);
            break;
        }
    }

    @Nullable
    public final LoadedScript getScript(int index) {
        return this.loadedScriptMap.get(index);
    }

    @Override
    public void registerAdditionalActions(@NotNull DefaultActionGroup leftToolbar, @NotNull DefaultActionGroup topToolbar, @NotNull DefaultActionGroup settings) {
        Intrinsics.checkParameterIsNotNull((Object)leftToolbar, (String)"leftToolbar");
        Intrinsics.checkParameterIsNotNull((Object)topToolbar, (String)"topToolbar");
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        super.registerAdditionalActions(leftToolbar, topToolbar, settings);
        topToolbar.add((AnAction)new ToggleAction(this, "Lua profiler!", null, LuaIcons.Debugger.Actions.PROFILER){
            final /* synthetic */ LuaAttachDebugProcessBase this$0;

            public boolean isSelected(@NotNull AnActionEvent event) {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                return this.this$0.getProfilerState();
            }

            public void setSelected(@NotNull AnActionEvent event, boolean state2) {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                this.this$0.setProfilerState(state2);
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3);
            }
        });
    }

    @NotNull
    public XDebugTabLayouter createTabLayouter() {
        return new XDebugTabLayouter(this){
            final /* synthetic */ LuaAttachDebugProcessBase this$0;

            public void registerAdditionalContent(@NotNull RunnerLayoutUi ui) {
                Intrinsics.checkParameterIsNotNull((Object)ui, (String)"ui");
                super.registerAdditionalContent(ui);
                LuaAttachDebugProcessBase.access$createVMPanel(this.this$0, ui);
                LuaAttachDebugProcessBase.access$createMemoryFilesPanel(this.this$0, ui);
                LuaAttachDebugProcessBase.access$createProfilerPanel(this.this$0, ui);
                LuaAttachDebugProcessBase.access$createEmmyConsole(this.this$0, ui);
            }
            {
                this.this$0 = $outer;
            }
        };
    }

    private final void createEmmyConsole(RunnerLayoutUi ui) {
        TextConsoleBuilderFactory textConsoleBuilderFactory = TextConsoleBuilderFactory.getInstance();
        XDebugSession xDebugSession = this.getSession();
        Intrinsics.checkExpressionValueIsNotNull((Object)xDebugSession, (String)"session");
        TextConsoleBuilder textConsoleBuilder = textConsoleBuilderFactory.createBuilder(xDebugSession.getProject());
        Intrinsics.checkExpressionValueIsNotNull((Object)textConsoleBuilder, (String)"TextConsoleBuilderFactor\u2026eBuilder(session.project)");
        ConsoleView consoleView = textConsoleBuilder.getConsole();
        Intrinsics.checkExpressionValueIsNotNull((Object)consoleView, (String)"TextConsoleBuilderFactor\u2026(session.project).console");
        ConsoleView console = consoleView;
        String name = "Emmy.log";
        Content content = ui.createContent(name, console.getComponent(), name, AllIcons.Debugger.Console_log, null);
        Intrinsics.checkExpressionValueIsNotNull((Object)content, (String)"ui.createContent(name, c\u2026bugger.Console_log, null)");
        Content consoleContent = content;
        consoleContent.setCloseable(false);
        consoleContent.setPinnable(false);
        consoleContent.setDisplayName(name);
        ui.addContent(consoleContent, 2, PlaceInGrid.center, false);
        RunContentBuilder.addAdditionalConsoleEditorActions((ExecutionConsole)((ExecutionConsole)console), (Content)consoleContent);
        this.emmyConsole = console;
    }

    private final void createVMPanel(RunnerLayoutUi ui) {
        XDebugSession xDebugSession = this.getSession();
        Intrinsics.checkExpressionValueIsNotNull((Object)xDebugSession, (String)"session");
        Project project = xDebugSession.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"session.project");
        LuaVMPanel luaVMPanel = this.vmPanel = new LuaVMPanel(project);
        if (luaVMPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"vmPanel");
        }
        Content content = ui.createContent("FrameContent", (JComponent)luaVMPanel, "Lua VM", AllIcons.Debugger.Frame, null);
        Intrinsics.checkExpressionValueIsNotNull((Object)content, (String)"ui.createContent(Debugge\u2026ons.Debugger.Frame, null)");
        Content content2 = content;
        content2.setCloseable(false);
        ui.addContent(content2, 0, PlaceInGrid.left, false);
    }

    private final void createMemoryFilesPanel(RunnerLayoutUi ui) {
        XDebugSession xDebugSession = this.getSession();
        Intrinsics.checkExpressionValueIsNotNull((Object)xDebugSession, (String)"session");
        Project project = xDebugSession.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"session.project");
        MemoryFilesPanel memoryFilesPanel = this.memoryFilesPanel = new MemoryFilesPanel(project, this);
        if (memoryFilesPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"memoryFilesPanel");
        }
        Content content = ui.createContent("FrameContent", (JComponent)memoryFilesPanel, "Memory files", AllIcons.Debugger.Frame, null);
        Intrinsics.checkExpressionValueIsNotNull((Object)content, (String)"ui.createContent(Debugge\u2026ons.Debugger.Frame, null)");
        Content content2 = content;
        content2.setCloseable(false);
        ui.addContent(content2, 0, PlaceInGrid.left, false);
    }

    private final void createProfilerPanel(RunnerLayoutUi ui) {
        ProfilerPanel profilerPanel = this.profilerPanel = new ProfilerPanel(this);
        if (profilerPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"profilerPanel");
        }
        Content content = ui.createContent("FrameContent", (JComponent)profilerPanel, "Profiler", AllIcons.Debugger.Frame, null);
        Intrinsics.checkExpressionValueIsNotNull((Object)content, (String)"ui.createContent(Debugge\u2026ons.Debugger.Frame, null)");
        Content content2 = content;
        content2.setCloseable(false);
        ui.addContent(content2, 0, PlaceInGrid.left, false);
    }

    @Override
    public void print(@NotNull String text, @NotNull LogConsoleType consoleType, @NotNull ConsoleViewContentType contentType) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)((Object)consoleType), (String)"consoleType");
        Intrinsics.checkParameterIsNotNull((Object)contentType, (String)"contentType");
        if (consoleType == LogConsoleType.EMMY) {
            ConsoleView consoleView = this.emmyConsole;
            if (consoleView != null) {
                consoleView.print(text, contentType);
            }
        } else {
            super.print(text, consoleType, contentType);
        }
    }

    @Override
    public void printHyperlink(@NotNull String text, @NotNull LogConsoleType consoleType, @NotNull Function1<? super Project, Unit> handler2) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)((Object)consoleType), (String)"consoleType");
        Intrinsics.checkParameterIsNotNull(handler2, (String)"handler");
        if (consoleType == LogConsoleType.EMMY) {
            ConsoleView consoleView = this.emmyConsole;
            if (consoleView != null) {
                Function1<? super Project, Unit> function1 = handler2;
                consoleView.printHyperlink(text, (HyperlinkInfo)new LuaAttachDebugProcessBase$sam$com_intellij_execution_filters_HyperlinkInfo$0(function1));
            }
        } else {
            super.printHyperlink(text, consoleType, handler2);
        }
    }

    @NotNull
    public ExecutionConsole createConsole() {
        XDebugSession xDebugSession = this.getSession();
        Intrinsics.checkExpressionValueIsNotNull((Object)xDebugSession, (String)"session");
        Project project = xDebugSession.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"session.project");
        Project project2 = project;
        ConsoleState.NotStartedStated state2 = new ConsoleState.NotStartedStated(this){
            final /* synthetic */ LuaAttachDebugProcessBase this$0;

            @NotNull
            public ConsoleState attachTo(@NotNull ConsoleViewImpl viewImpl, @Nullable ProcessHandler handler2) {
                Intrinsics.checkParameterIsNotNull((Object)viewImpl, (String)"viewImpl");
                return (ConsoleState)this;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean isRunning() {
                if (!this.this$0.getEmmyInputEnabled()) return false;
                XDebugSession xDebugSession = this.this$0.getSession();
                Intrinsics.checkExpressionValueIsNotNull((Object)xDebugSession, (String)"session");
                if (xDebugSession.isStopped()) return false;
                return true;
            }

            public void sendUserInput(@NotNull String input) {
                Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
                this.this$0.getBridge().send(new DMStdin(StringsKt.replace$default((String)input, (String)"\n", (String)"\r\n", (boolean)false, (int)4, null)));
            }
            {
                this.this$0 = $outer;
            }
        };
        return (ExecutionConsole)new ConsoleViewImpl(project2, state2, project2, GlobalSearchScope.allScope((Project)project2), false, (ConsoleState)state2, true){
            final /* synthetic */ Project $project;
            final /* synthetic */ createConsole.state.1 $state;
            {
                this.$project = $captured_local_variable$0;
                this.$state = $captured_local_variable$1;
                super($super_call_param$2, $super_call_param$3, $super_call_param$4, $super_call_param$5, $super_call_param$6);
            }
        };
    }

    protected LuaAttachDebugProcessBase(@NotNull XDebugSession session) {
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        super(session);
        this.loadedScriptMap = new ConcurrentHashMap();
        this.memoryFileSystem = MemoryFileSystem.Companion.getInstance();
        session.setPauseActionSupported(false);
        this.editorsProvider = new LuaDebuggerEditorsProvider();
        this.stdoutIncompleteString = new IncompleteString();
        this.stderrIncompleteString = new IncompleteString();
    }

    public static final /* synthetic */ MemoryFileSystem access$getMemoryFileSystem$p(LuaAttachDebugProcessBase $this) {
        return $this.memoryFileSystem;
    }

    public static final /* synthetic */ MemoryFilesPanel access$getMemoryFilesPanel$p(LuaAttachDebugProcessBase $this) {
        MemoryFilesPanel memoryFilesPanel = $this.memoryFilesPanel;
        if (memoryFilesPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"memoryFilesPanel");
        }
        return memoryFilesPanel;
    }

    public static final /* synthetic */ void access$setMemoryFilesPanel$p(LuaAttachDebugProcessBase $this, MemoryFilesPanel memoryFilesPanel) {
        $this.memoryFilesPanel = memoryFilesPanel;
    }

    public static final /* synthetic */ void access$onLoadScript(LuaAttachDebugProcessBase $this, DMLoadScript proto) {
        $this.onLoadScript(proto);
    }

    public static final /* synthetic */ void access$createVMPanel(LuaAttachDebugProcessBase $this, RunnerLayoutUi ui) {
        $this.createVMPanel(ui);
    }

    public static final /* synthetic */ void access$createMemoryFilesPanel(LuaAttachDebugProcessBase $this, RunnerLayoutUi ui) {
        $this.createMemoryFilesPanel(ui);
    }

    public static final /* synthetic */ void access$createProfilerPanel(LuaAttachDebugProcessBase $this, RunnerLayoutUi ui) {
        $this.createProfilerPanel(ui);
    }

    public static final /* synthetic */ void access$createEmmyConsole(LuaAttachDebugProcessBase $this, RunnerLayoutUi ui) {
        $this.createEmmyConsole(ui);
    }
}

