/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.emmylua.lua.debugger.attach;

import com.immomo.emmylua.lua.debugger.DebugLogger;
import com.immomo.emmylua.lua.debugger.LogConsoleType;
import com.immomo.emmylua.lua.debugger.attach.DMAddBreakpoint;
import com.immomo.emmylua.lua.debugger.attach.DMDelBreakpoint;
import com.immomo.emmylua.lua.debugger.attach.DMReqEvaluate;
import com.immomo.emmylua.lua.debugger.attach.DMReqInitialize;
import com.immomo.emmylua.lua.debugger.attach.DMRespEvaluate;
import com.immomo.emmylua.lua.debugger.attach.DebugMessageId;
import com.immomo.emmylua.lua.debugger.attach.ErrorCode;
import com.immomo.emmylua.lua.debugger.attach.LuaAttachBridgeBase$WhenMappings;
import com.immomo.emmylua.lua.debugger.attach.LuaAttachDebugProcessBase;
import com.immomo.emmylua.lua.debugger.attach.LuaAttachMessage;
import com.immomo.emmylua.lua.debugger.attach.LuaAttachMessagesKt;
import com.immomo.emmylua.lua.debugger.attach.value.LuaXValue;
import com.immomo.emmylua.lua.project.LLuaSettings;
import com.immomo.emmylua.lua.psi.LuaFileUtil;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\r\b&\u0018\u00002\u00020\u0001:\u0003JKLB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\t2\n\u0010,\u001a\u0006\u0012\u0002\b\u00030-J\u0010\u0010.\u001a\u00020*2\u0006\u0010/\u001a\u00020\tH\u0004J.\u00100\u001a\u00020*2\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u00152\u0006\u00104\u001a\u00020\t2\u0006\u00105\u001a\u00020\t2\u0006\u00106\u001a\u000207J\u0010\u00108\u001a\u00020*2\u0006\u00109\u001a\u00020:H\u0002J\u0010\u0010;\u001a\u00020*2\u0006\u0010<\u001a\u00020=H\u0014J\u0010\u0010>\u001a\u00020*2\u0006\u0010?\u001a\u00020@H\u0002J\u0010\u0010A\u001a\u00020*2\u0006\u0010B\u001a\u00020\tH\u0004J\b\u0010C\u001a\u00020*H\u0002J\u001a\u0010D\u001a\u00020*2\u0006\u0010+\u001a\u00020\t2\n\u0010,\u001a\u0006\u0012\u0002\b\u00030-J\u000e\u0010E\u001a\u00020*2\u0006\u0010<\u001a\u00020=J\u0006\u0010F\u001a\u00020*J\u0006\u0010G\u001a\u00020*J\u000e\u0010H\u001a\u00020*2\u0006\u0010!\u001a\u00020\"J\u0006\u0010I\u001a\u00020*R\u001e\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t\u0012\b\u0012\u00060\nR\u00020\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000e\"\u0004\b\u0013\u0010\u0010R\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u00158DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0010\u0010!\u001a\u0004\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u000e\u0010%\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010'\u001a\u0004\u0018\u00010(X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006M"}, d2={"Lcom/immomo/emmylua/lua/debugger/attach/LuaAttachBridgeBase;", "", "process", "Lcom/immomo/emmylua/lua/debugger/attach/LuaAttachDebugProcessBase;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "(Lcom/immomo/emmylua/lua/debugger/attach/LuaAttachDebugProcessBase;Lcom/intellij/xdebugger/XDebugSession;)V", "callbackMap", "Ljava/util/HashMap;", "", "Lcom/immomo/emmylua/lua/debugger/attach/LuaAttachBridgeBase$EvalInfo;", "captureOutput", "", "getCaptureOutput", "()Z", "setCaptureOutput", "(Z)V", "captureStd", "getCaptureStd", "setCaptureStd", "emmyLua", "", "getEmmyLua", "()Ljava/lang/String;", "evalIdCounter", "handler", "Lcom/intellij/execution/process/OSProcessHandler;", "getHandler", "()Lcom/intellij/execution/process/OSProcessHandler;", "setHandler", "(Lcom/intellij/execution/process/OSProcessHandler;)V", "getProcess", "()Lcom/immomo/emmylua/lua/debugger/attach/LuaAttachDebugProcessBase;", "protoHandler", "Lcom/immomo/emmylua/lua/debugger/attach/LuaAttachBridgeBase$ProtoHandler;", "getSession", "()Lcom/intellij/xdebugger/XDebugSession;", "socket", "Ljava/net/Socket;", "writer", "Ljava/io/DataOutputStream;", "addBreakpoint", "", "index", "breakpoint", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;", "connect", "port", "eval", "L", "", "expr", "stack", "depth", "callback", "Lcom/immomo/emmylua/lua/debugger/attach/LuaAttachBridgeBase$EvalCallback;", "handleEvalCallback", "proto", "Lcom/immomo/emmylua/lua/debugger/attach/DMRespEvaluate;", "handleMessage", "message", "Lcom/immomo/emmylua/lua/debugger/attach/LuaAttachMessage;", "handleMsg", "byteArray", "", "onDebugHelperExit", "code", "processPack", "removeBreakpoint", "send", "sendDone", "sendRun", "setProtoHandler", "stop", "EvalCallback", "EvalInfo", "ProtoHandler", "MMPaas"})
public abstract class LuaAttachBridgeBase {
    @Nullable
    private OSProcessHandler handler;
    private DataOutputStream writer;
    private ProtoHandler protoHandler;
    private int evalIdCounter;
    private final HashMap<Integer, EvalInfo> callbackMap;
    private Socket socket;
    private boolean captureStd;
    private boolean captureOutput;
    @NotNull
    private final LuaAttachDebugProcessBase process;
    @NotNull
    private final XDebugSession session;

    @Nullable
    protected final OSProcessHandler getHandler() {
        return this.handler;
    }

    protected final void setHandler(@Nullable OSProcessHandler oSProcessHandler) {
        this.handler = oSProcessHandler;
    }

    public final boolean getCaptureStd() {
        return this.captureStd;
    }

    public final void setCaptureStd(boolean bl) {
        this.captureStd = bl;
    }

    public final boolean getCaptureOutput() {
        return this.captureOutput;
    }

    public final void setCaptureOutput(boolean bl) {
        this.captureOutput = bl;
    }

    @Nullable
    protected final String getEmmyLua() {
        return LuaFileUtil.getPluginVirtualFile("debugger/Emmy.lua");
    }

    public final void setProtoHandler(@NotNull ProtoHandler protoHandler) {
        Intrinsics.checkParameterIsNotNull((Object)protoHandler, (String)"protoHandler");
        this.protoHandler = protoHandler;
    }

    protected final void onDebugHelperExit(int code) {
        ErrorCode errorCode = LuaAttachMessagesKt.getDebugHelperExitCode(code);
        switch (LuaAttachBridgeBase$WhenMappings.$EnumSwitchMapping$0[errorCode.ordinal()]) {
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                DebugLogger.DefaultImpls.error$default(this.process, "Error: emmy.backend.dll could not be loaded into the process", null, 2, null);
                this.process.stop();
                break;
            }
            case 4: {
                DebugLogger.DefaultImpls.error$default(this.process, "Error: Backend couldn't be initialized", null, 2, null);
                this.process.stop();
                break;
            }
            case 5: {
                DebugLogger.DefaultImpls.error$default(this.process, "Error: The process could not be opened", null, 2, null);
                this.process.stop();
                break;
            }
            default: {
                this.process.stop();
            }
        }
    }

    protected void handleMessage(@NotNull LuaAttachMessage message2) {
        Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
        switch (LuaAttachBridgeBase$WhenMappings.$EnumSwitchMapping$1[message2.getId().ordinal()]) {
            case 1: {
                this.handleEvalCallback((DMRespEvaluate)message2);
                break;
            }
            default: {
                ProtoHandler protoHandler = this.protoHandler;
                if (protoHandler == null) break;
                protoHandler.handle(message2);
                break;
            }
        }
    }

    private final void handleEvalCallback(DMRespEvaluate proto) {
        block1: {
            EvalInfo info = this.callbackMap.remove(proto.getEvalId());
            if (info == null) break block1;
            LuaXValue xValue = proto.getResultNode().getValue();
            xValue.setName(info.getExpr());
            EvalCallback evalCallback = info.getCallback();
            if (evalCallback != null) {
                evalCallback.onResult(proto);
            }
        }
    }

    protected final void connect(int port) {
        try {
            this.socket = new Socket();
            this.socket.setTcpNoDelay(true);
            this.socket.connect(new InetSocketAddress("localhost", port));
            this.writer = new DataOutputStream(this.socket.getOutputStream());
            ApplicationManager.getApplication().executeOnPooledThread(new Runnable(this){
                final /* synthetic */ LuaAttachBridgeBase this$0;

                public final void run() {
                    String string = this.this$0.getEmmyLua();
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    this.this$0.send(new DMReqInitialize("", string, this.this$0.getCaptureStd(), this.this$0.getCaptureOutput()));
                    LuaAttachBridgeBase.access$processPack(this.this$0);
                }
                {
                    this.this$0 = luaAttachBridgeBase;
                }
            });
        }
        catch (Exception e) {
            String string = e.getMessage();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            DebugLogger.DefaultImpls.error$default(this.process, string, null, 2, null);
        }
    }

    private final void processPack() {
        try {
            InputStream inputStream = this.socket.getInputStream();
            while (true) {
                int r;
                byte[] lenBytes = new byte[4];
                inputStream.read(lenBytes);
                int len2 = new DataInputStream(new ByteArrayInputStream(lenBytes)).readInt();
                byte[] bytes = new byte[len2];
                for (int read = 0; read < len2; read += r) {
                    r = inputStream.read(bytes, read, len2 - read);
                }
                this.handleMsg(bytes);
            }
        }
        catch (SocketException e) {
            ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.SYSTEM_OUTPUT;
            Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType, (String)"ConsoleViewContentType.SYSTEM_OUTPUT");
            this.process.println("debugger disconnected.", LogConsoleType.NORMAL, consoleViewContentType);
            this.session.stop();
        }
        catch (Exception e) {
            String string = e.getMessage();
            if (string != null) {
                String string2;
                String it = string2 = string;
                boolean bl = false;
                this.process.error(it, LogConsoleType.NORMAL);
            }
            this.session.stop();
        }
    }

    private final void handleMsg(byte[] byteArray) {
        DataInputStream reader = new DataInputStream(new ByteArrayInputStream(byteArray));
        LuaAttachMessage message2 = LuaAttachMessage.Companion.parseMessage(reader, this.process);
        this.handleMessage(message2);
    }

    public final void stop() {
        this.writer = null;
        OSProcessHandler oSProcessHandler = this.handler;
        if (oSProcessHandler != null) {
            oSProcessHandler.destroyProcess();
        }
        this.handler = null;
        this.socket.close();
    }

    public final void send(@NotNull LuaAttachMessage message2) {
        Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream stream = new DataOutputStream(byteArrayOutputStream);
        message2.write(stream);
        byte[] byteArray = byteArrayOutputStream.toByteArray();
        ByteArrayOutputStream byte2 = new ByteArrayOutputStream();
        DataOutputStream stream2 = new DataOutputStream(byte2);
        stream2.writeInt(byteArray.length);
        stream2.write(byteArray);
        this.socket.getOutputStream().write(byte2.toByteArray());
        this.socket.getOutputStream().flush();
    }

    public final void eval(long L, @NotNull String expr, int stack, int depth, @NotNull EvalCallback callback) {
        Intrinsics.checkParameterIsNotNull((Object)expr, (String)"expr");
        Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
        int n = this.evalIdCounter;
        this.evalIdCounter = n + 1;
        int id = n;
        EvalInfo info = new EvalInfo();
        info.setCallback(callback);
        info.setExpr(expr);
        Map map = this.callbackMap;
        Integer n2 = id;
        EvalInfo evalInfo = info;
        map.put(n2, evalInfo);
        this.send(new DMReqEvaluate(L, id, stack, depth, expr));
    }

    public final void addBreakpoint(int index, @NotNull XLineBreakpoint<?> breakpoint) {
        Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
        XExpression expression = breakpoint.getConditionExpression();
        Object object = expression;
        if (object == null || (object = object.getExpression()) == null) {
            object = "";
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"expression?.expression ?: \"\"");
        Object exp2 = object;
        this.send(new DMAddBreakpoint(index, breakpoint.getLine(), (String)exp2));
    }

    public final void removeBreakpoint(int index, @NotNull XLineBreakpoint<?> breakpoint) {
        Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
        this.send(new DMDelBreakpoint(index, breakpoint.getLine()));
    }

    public final void sendDone() {
        this.send(new LuaAttachMessage(DebugMessageId.LoadDone));
    }

    public final void sendRun() {
        this.send(new LuaAttachMessage(DebugMessageId.Continue));
    }

    @NotNull
    public final LuaAttachDebugProcessBase getProcess() {
        return this.process;
    }

    @NotNull
    public final XDebugSession getSession() {
        return this.session;
    }

    public LuaAttachBridgeBase(@NotNull LuaAttachDebugProcessBase process2, @NotNull XDebugSession session) {
        Intrinsics.checkParameterIsNotNull((Object)process2, (String)"process");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        this.process = process2;
        this.session = session;
        this.callbackMap = new HashMap();
        this.socket = new Socket();
        this.captureStd = LLuaSettings.Companion.getInstance().getAttachDebugCaptureStd();
        this.captureOutput = LLuaSettings.Companion.getInstance().getAttachDebugCaptureOutput();
    }

    public static final /* synthetic */ void access$processPack(LuaAttachBridgeBase $this) {
        $this.processPack();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/immomo/emmylua/lua/debugger/attach/LuaAttachBridgeBase$ProtoHandler;", "", "handle", "", "message", "Lcom/immomo/emmylua/lua/debugger/attach/LuaAttachMessage;", "MMPaas"})
    public static interface ProtoHandler {
        public void handle(@NotNull LuaAttachMessage var1);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/immomo/emmylua/lua/debugger/attach/LuaAttachBridgeBase$EvalCallback;", "", "onResult", "", "result", "Lcom/immomo/emmylua/lua/debugger/attach/DMRespEvaluate;", "MMPaas"})
    public static interface EvalCallback {
        public void onResult(@NotNull DMRespEvaluate var1);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/immomo/emmylua/lua/debugger/attach/LuaAttachBridgeBase$EvalInfo;", "", "(Lcom/immomo/emmylua/lua/debugger/attach/LuaAttachBridgeBase;)V", "callback", "Lcom/immomo/emmylua/lua/debugger/attach/LuaAttachBridgeBase$EvalCallback;", "getCallback", "()Lcom/immomo/emmylua/lua/debugger/attach/LuaAttachBridgeBase$EvalCallback;", "setCallback", "(Lcom/immomo/emmylua/lua/debugger/attach/LuaAttachBridgeBase$EvalCallback;)V", "expr", "", "getExpr", "()Ljava/lang/String;", "setExpr", "(Ljava/lang/String;)V", "MMPaas"})
    public final class EvalInfo {
        @Nullable
        private EvalCallback callback;
        @Nullable
        private String expr;

        @Nullable
        public final EvalCallback getCallback() {
            return this.callback;
        }

        public final void setCallback(@Nullable EvalCallback evalCallback) {
            this.callback = evalCallback;
        }

        @Nullable
        public final String getExpr() {
            return this.expr;
        }

        public final void setExpr(@Nullable String string) {
            this.expr = string;
        }
    }
}

