/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.emmylua.lua.debugger.attach;

import com.immomo.emmylua.lua.LuaBundle;
import com.immomo.emmylua.lua.debugger.LogConsoleType;
import com.immomo.emmylua.lua.debugger.attach.LuaAttachBridge;
import com.immomo.emmylua.lua.debugger.attach.LuaAttachBridgeBase;
import com.immomo.emmylua.lua.debugger.attach.LuaAttachDebugProcessBase;
import com.immomo.emmylua.lua.psi.LuaFileUtil;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XDebugSession;
import java.nio.charset.Charset;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000+\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u0010\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006\u000e"}, d2={"Lcom/immomo/emmylua/lua/debugger/attach/LuaAttachBridge;", "Lcom/immomo/emmylua/lua/debugger/attach/LuaAttachBridgeBase;", "process", "Lcom/immomo/emmylua/lua/debugger/attach/LuaAttachDebugProcessBase;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "(Lcom/immomo/emmylua/lua/debugger/attach/LuaAttachDebugProcessBase;Lcom/intellij/xdebugger/XDebugSession;)V", "processListener", "com/immomo/emmylua/lua/debugger/attach/LuaAttachBridge$processListener$1", "Lcom/immomo/emmylua/lua/debugger/attach/LuaAttachBridge$processListener$1;", "attach", "", "processInfo", "Lcom/intellij/execution/process/ProcessInfo;", "MMPaas"})
public final class LuaAttachBridge
extends LuaAttachBridgeBase {
    private final processListener.1 processListener;

    public final void attach(@NotNull ProcessInfo processInfo) {
        Intrinsics.checkParameterIsNotNull((Object)processInfo, (String)"processInfo");
        String pid = String.valueOf(processInfo.getPid());
        VirtualFile pluginVirtualDirectory = LuaFileUtil.getPluginVirtualDirectory();
        try {
            if (pluginVirtualDirectory != null) {
                String archExe = LuaFileUtil.getArchExeFile();
                String[] stringArray = new String[1];
                String string = archExe;
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                stringArray[0] = string;
                ProcessBuilder processBuilder = new ProcessBuilder(stringArray);
                boolean isX86 = false;
                Process archChecker = processBuilder.command(archExe, "arch", "-pid", pid).start();
                archChecker.waitFor();
                int exitValue = archChecker.exitValue();
                isX86 = exitValue == 1;
                String archType = isX86 ? "x86" : "x64";
                LuaAttachDebugProcessBase luaAttachDebugProcessBase = this.getProcess();
                String string2 = LuaBundle.message("run.attach.start_info", processInfo.getExecutableName(), pid, archType);
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"LuaBundle.message(\"run.a\u2026tableName, pid, archType)");
                ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.SYSTEM_OUTPUT;
                Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType, (String)"ConsoleViewContentType.SYSTEM_OUTPUT");
                luaAttachDebugProcessBase.println(string2, LogConsoleType.NORMAL, consoleViewContentType);
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string3 = "debugger/windows/%s/emmy.tool.exe";
                Object[] objectArray = new Object[]{archType};
                String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"java.lang.String.format(format, *args)");
                String exe = LuaFileUtil.getPluginVirtualFile(string4);
                String[] stringArray2 = new String[1];
                String string5 = exe;
                if (string5 == null) {
                    Intrinsics.throwNpe();
                }
                stringArray2[0] = string5;
                GeneralCommandLine commandLine = new GeneralCommandLine(stringArray2);
                commandLine.addParameters(new String[]{"-m", "attach", "-p", pid, "-e", this.getEmmyLua()});
                commandLine.setCharset(Charset.forName("UTF-8"));
                this.setHandler(new OSProcessHandler(commandLine));
                OSProcessHandler oSProcessHandler = this.getHandler();
                if (oSProcessHandler != null) {
                    oSProcessHandler.addProcessListener((ProcessListener)this.processListener);
                }
                OSProcessHandler oSProcessHandler2 = this.getHandler();
                if (oSProcessHandler2 != null) {
                    oSProcessHandler2.startNotify();
                }
            }
        }
        catch (Exception e) {
            LuaAttachDebugProcessBase luaAttachDebugProcessBase = this.getProcess();
            String string = e.getMessage();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            luaAttachDebugProcessBase.error(string, LogConsoleType.EMMY);
            this.getSession().stop();
        }
    }

    public LuaAttachBridge(@NotNull LuaAttachDebugProcessBase process2, @NotNull XDebugSession session) {
        Intrinsics.checkParameterIsNotNull((Object)process2, (String)"process");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        super(process2, session);
        this.processListener = new ProcessListener(this, process2){
            final /* synthetic */ LuaAttachBridge this$0;
            final /* synthetic */ LuaAttachDebugProcessBase $process;

            public void startNotified(@NotNull ProcessEvent processEvent) {
                Intrinsics.checkParameterIsNotNull((Object)processEvent, (String)"processEvent");
            }

            public void processTerminated(@NotNull ProcessEvent processEvent) {
                Intrinsics.checkParameterIsNotNull((Object)processEvent, (String)"processEvent");
                this.this$0.onDebugHelperExit(processEvent.getExitCode());
            }

            public void processWillTerminate(@NotNull ProcessEvent processEvent, boolean b) {
                Intrinsics.checkParameterIsNotNull((Object)processEvent, (String)"processEvent");
            }

            public void onTextAvailable(@NotNull ProcessEvent processEvent, @NotNull Key<?> key) {
                String text;
                Intrinsics.checkParameterIsNotNull((Object)processEvent, (String)"processEvent");
                Intrinsics.checkParameterIsNotNull(key, (String)"key");
                if (Intrinsics.areEqual(key, (Object)ProcessOutputTypes.SYSTEM)) {
                    return;
                }
                String string = text = processEvent.getText();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"text");
                if (StringsKt.startsWith$default((String)string, (String)"port:", (boolean)false, (int)2, null)) {
                    Regex reg = new Regex("port:(\\d+)");
                    MatchResult matchResult = Regex.find$default((Regex)reg, (CharSequence)text, (int)0, (int)2, null);
                    if (matchResult != null) {
                        MatchResult matchResult2;
                        MatchResult it = matchResult2 = matchResult;
                        boolean bl = false;
                        MatchGroup matchGroup = it.getGroups().get(1);
                        if (matchGroup == null) {
                            Intrinsics.throwNpe();
                        }
                        String string2 = matchGroup.getValue();
                        int p = Integer.parseInt(string2);
                        this.this$0.connect(p);
                    }
                }
                String string3 = processEvent.getText();
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"processEvent.text");
                ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.SYSTEM_OUTPUT;
                Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType, (String)"ConsoleViewContentType.SYSTEM_OUTPUT");
                this.$process.print(string3, LogConsoleType.EMMY, consoleViewContentType);
            }
            {
                this.this$0 = $outer;
                this.$process = $captured_local_variable$1;
            }
        };
    }
}

