/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.emmylua.lua.debugger.attach;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.MalformedInputException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/immomo/emmylua/lua/debugger/attach/IncompleteString;", "", "()V", "buffer", "", "append", "", "bytes", "decode", "", "charset", "Ljava/nio/charset/Charset;", "tryDecode", "decoder", "Ljava/nio/charset/CharsetDecoder;", "len", "", "MMPaas"})
public final class IncompleteString {
    private byte[] buffer = new byte[0];

    public final void append(@NotNull byte[] bytes) {
        Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
        this.buffer = ArraysKt.plus((byte[])this.buffer, (byte[])bytes);
    }

    @NotNull
    public final String decode(@NotNull Charset charset) {
        Intrinsics.checkParameterIsNotNull((Object)charset, (String)"charset");
        String result = null;
        CharsetDecoder decoder = charset.newDecoder();
        try {
            CharsetDecoder charsetDecoder = decoder;
            Intrinsics.checkExpressionValueIsNotNull((Object)charsetDecoder, (String)"decoder");
            result = this.tryDecode(charsetDecoder, this.buffer.length);
        }
        catch (MalformedInputException e) {
            try {
                CharsetDecoder charsetDecoder = decoder;
                Intrinsics.checkExpressionValueIsNotNull((Object)charsetDecoder, (String)"decoder");
                result = this.tryDecode(charsetDecoder, this.buffer.length - e.getInputLength());
            }
            catch (Exception e2) {
                byte[] byArray = this.buffer;
                result = new String(byArray, Charsets.UTF_8);
                this.buffer = new byte[0];
            }
        }
        return result;
    }

    private final String tryDecode(CharsetDecoder decoder, int len2) {
        ByteBuffer buf = ByteBuffer.wrap(this.buffer, 0, len2);
        String string = decoder.decode(buf).toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"decoder.decode(buf).toString()");
        String result = string;
        byte[] byArray = this.buffer;
        int n = buf.position();
        int n2 = this.buffer.length;
        IncompleteString incompleteString = this;
        byte[] byArray2 = ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)n2);
        incompleteString.buffer = byArray2;
        return result;
    }
}

