/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.emmylua.lua.debugger.attach;

import com.immomo.emmylua.lua.debugger.LuaExecutionStack;
import com.immomo.emmylua.lua.debugger.attach.DebugMessageId;
import com.immomo.emmylua.lua.debugger.attach.LoadedScript;
import com.immomo.emmylua.lua.debugger.attach.LuaAttachMessage;
import com.immomo.emmylua.lua.debugger.attach.LuaAttachStackFrame;
import com.immomo.emmylua.lua.debugger.attach.value.IStackNode;
import com.immomo.emmylua.lua.debugger.attach.value.LuaXValue;
import com.immomo.emmylua.lua.debugger.attach.value.StackNodeContainer;
import com.immomo.emmylua.lua.debugger.attach.value.StackNodeKt;
import com.immomo.emmylua.lua.debugger.attach.value.StackRootNode;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.impl.XSourcePositionImpl;
import java.io.DataInputStream;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u001e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\"\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\u0003\u001a\u0004\u0018\u00010\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001e\u0010\r\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\f@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/immomo/emmylua/lua/debugger/attach/DMBreak;", "Lcom/immomo/emmylua/lua/debugger/attach/LuaAttachMessage;", "()V", "<set-?>", "", "line", "getLine", "()I", "", "name", "getName", "()Ljava/lang/String;", "Lcom/immomo/emmylua/lua/debugger/LuaExecutionStack;", "stack", "getStack", "()Lcom/immomo/emmylua/lua/debugger/LuaExecutionStack;", "stacks", "Lcom/immomo/emmylua/lua/debugger/attach/value/StackNodeContainer;", "read", "", "stream", "Ljava/io/DataInputStream;", "MMPaas"})
public final class DMBreak
extends LuaAttachMessage {
    private StackNodeContainer stacks;
    @NotNull
    private LuaExecutionStack stack;
    @Nullable
    private String name;
    private int line;

    @NotNull
    public final LuaExecutionStack getStack() {
        LuaExecutionStack luaExecutionStack = this.stack;
        if (luaExecutionStack == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"stack");
        }
        return luaExecutionStack;
    }

    @Nullable
    public final String getName() {
        return this.name;
    }

    public final int getLine() {
        return this.line;
    }

    @Override
    public void read(@NotNull DataInputStream stream) {
        Intrinsics.checkParameterIsNotNull((Object)stream, (String)"stream");
        super.read(stream);
        List frames = new ArrayList();
        IStackNode iStackNode = StackNodeKt.readNode(stream, this.getL(), this.getProcess());
        if (iStackNode == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.immomo.emmylua.lua.debugger.attach.value.StackNodeContainer");
        }
        this.stacks = (StackNodeContainer)iStackNode;
        int stackIndex = 0;
        StackNodeContainer stackNodeContainer = this.stacks;
        if (stackNodeContainer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"stacks");
        }
        Iterable $receiver$iv = stackNodeContainer.getChildren();
        for (Object element$iv : $receiver$iv) {
            VirtualFile file;
            IStackNode it = (IStackNode)element$iv;
            boolean bl = false;
            IStackNode iStackNode2 = it;
            if (iStackNode2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.immomo.emmylua.lua.debugger.attach.value.StackRootNode");
            }
            StackRootNode stack = (StackRootNode)iStackNode2;
            XValueChildrenList childList = new XValueChildrenList();
            Iterable $receiver$iv2 = stack.getChildren();
            for (Object element$iv2 : $receiver$iv2) {
                IStackNode it2 = (IStackNode)element$iv2;
                boolean bl2 = false;
                IStackNode iStackNode3 = it2;
                if (iStackNode3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.immomo.emmylua.lua.debugger.attach.value.LuaXValue");
                }
                LuaXValue value = (LuaXValue)((Object)iStackNode3);
                childList.add(value.getName(), (XValue)value);
            }
            LoadedScript script = this.getProcess().getScript(stack.getScriptIndex());
            XSourcePosition position = null;
            if (script != null && (file = this.getProcess().findFile(script.getName())) != null) {
                position = (XSourcePosition)XSourcePositionImpl.create((VirtualFile)file, (int)stack.getLine());
                if (this.name == null) {
                    this.line = stack.getLine();
                    this.name = script.getName();
                }
            }
            LoadedScript loadedScript = script;
            int n = stackIndex;
            stackIndex = n + 1;
            LuaAttachStackFrame frame = new LuaAttachStackFrame(this, childList, position, stack.getFunctionName(), loadedScript != null ? loadedScript.getName() : null, n);
            frames.add(frame);
        }
        this.stack = new LuaExecutionStack(frames);
    }

    public DMBreak() {
        super(DebugMessageId.Break);
    }
}

