/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.emmylua.lua.debugger.app;

import com.immomo.emmylua.lua.debugger.DebuggerType;
import com.immomo.emmylua.lua.debugger.app.LuaAppRunConfiguration;
import com.immomo.emmylua.lua.lang.LuaFileType;
import com.immomo.emmylua.lua.lang.LuaIcons;
import com.immomo.emmylua.lua.psi.LuaFileUtil;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.execution.configuration.EnvironmentVariablesTextFieldWithBrowseButton;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.ui.HoverHyperlinkLabel;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.TextFieldCompletionProvider;
import com.intellij.util.textCompletion.TextCompletionProvider;
import com.intellij.util.textCompletion.TextFieldWithCompletion;
import java.awt.Component;
import java.awt.Insets;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.SortedMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;

public class LuaAppSettingsEditor
extends SettingsEditor<LuaAppRunConfiguration> {
    private TextFieldWithBrowseButton myProgram;
    private JPanel myPanel;
    private ComboBox<DebuggerType> myDebugger;
    private TextFieldWithCompletion myFile;
    private TextFieldWithBrowseButton myWorkingDir;
    private RawCommandLineEditor parameters;
    private HoverHyperlinkLabel mobdebugLink;
    private EnvironmentVariablesTextFieldWithBrowseButton myEnvironments;
    private ComboBox<String> outputCharset;
    private JCheckBox showConsoleWindowCheckBox;
    private Project project;

    LuaAppSettingsEditor(Project project) {
        this.project = project;
        this.$$$setupUI$$$();
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor();
        this.myProgram.addBrowseFolderListener("Choose Program", "Choose program file", project, descriptor);
        descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        this.myWorkingDir.addBrowseFolderListener("Choose Working Dir", "Choose working dir", project, descriptor);
        DebuggerType[] debuggerTypes = SystemInfoRt.isWindows ? new DebuggerType[]{DebuggerType.Attach, DebuggerType.Mob} : new DebuggerType[]{DebuggerType.Mob};
        DefaultComboBoxModel<DebuggerType> debuggerDataModel = new DefaultComboBoxModel<DebuggerType>(debuggerTypes);
        this.myDebugger.setModel(debuggerDataModel);
        this.myDebugger.addItemListener(e -> {
            DebuggerType debuggerType = (DebuggerType)((Object)((Object)this.myDebugger.getSelectedItem()));
            this.mobdebugLink.setVisible(debuggerType == DebuggerType.Mob);
            this.showConsoleWindowCheckBox.setVisible(debuggerType == DebuggerType.Attach);
            this.fireEditorStateChanged();
        });
        SortedMap<String, Charset> charsetSortedMap = Charset.availableCharsets();
        DefaultComboBoxModel<String> outputCharsetModel = new DefaultComboBoxModel<String>(ArrayUtil.toStringArray(charsetSortedMap.keySet()));
        this.outputCharset.setModel(outputCharsetModel);
        this.outputCharset.addItemListener(e -> this.fireEditorStateChanged());
    }

    protected void resetEditorFrom(@NotNull LuaAppRunConfiguration luaAppRunConfiguration) {
        if (luaAppRunConfiguration == null) {
            LuaAppSettingsEditor.$$$reportNull$$$0(0);
        }
        this.myProgram.setText(luaAppRunConfiguration.getProgram());
        this.myWorkingDir.setText(luaAppRunConfiguration.getWorkingDir());
        this.myFile.setText(luaAppRunConfiguration.getFile());
        this.myDebugger.setSelectedItem((Object)luaAppRunConfiguration.getDebuggerType());
        this.parameters.setText(luaAppRunConfiguration.getParameters());
        this.myEnvironments.setEnvs(luaAppRunConfiguration.getEnvs());
        this.mobdebugLink.setVisible(luaAppRunConfiguration.getDebuggerType() == DebuggerType.Mob);
        this.outputCharset.setSelectedItem((Object)luaAppRunConfiguration.getCharset());
        this.showConsoleWindowCheckBox.setSelected(luaAppRunConfiguration.getShowConsole());
    }

    protected void applyEditorTo(@NotNull LuaAppRunConfiguration luaAppRunConfiguration) {
        if (luaAppRunConfiguration == null) {
            LuaAppSettingsEditor.$$$reportNull$$$0(1);
        }
        luaAppRunConfiguration.setProgram(this.myProgram.getText());
        luaAppRunConfiguration.setWorkingDir(this.myWorkingDir.getText());
        luaAppRunConfiguration.setFile(this.myFile.getText());
        luaAppRunConfiguration.setDebuggerType((DebuggerType)((Object)Objects.requireNonNull(this.myDebugger.getSelectedItem())));
        luaAppRunConfiguration.setParameters(this.parameters.getText());
        luaAppRunConfiguration.setEnvs(this.myEnvironments.getEnvs());
        luaAppRunConfiguration.setCharset((String)Objects.requireNonNull(this.outputCharset.getSelectedItem()));
        luaAppRunConfiguration.setShowConsole(this.showConsoleWindowCheckBox.isSelected());
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            LuaAppSettingsEditor.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    private void createUIComponents() {
        this.myFile = new TextFieldWithCompletion(this.project, (TextCompletionProvider)new LuaFileCompletionProvider(), "", true, true, true, true);
        this.mobdebugLink = new HoverHyperlinkLabel("Get mobdebug.lua 0.7+");
        this.mobdebugLink.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(HyperlinkEvent hyperlinkEvent) {
                BrowserUtil.browse((String)"https://github.com/pkulchenko/MobDebug/releases");
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "luaAppRunConfiguration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/immomo/emmylua/lua/debugger/app/LuaAppSettingsEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/immomo/emmylua/lua/debugger/app/LuaAppSettingsEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        ComboBox comboBox;
        EnvironmentVariablesTextFieldWithBrowseButton environmentVariablesTextFieldWithBrowseButton;
        RawCommandLineEditor rawCommandLineEditor;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        ComboBox comboBox2;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(10, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(9, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Parameters:");
        jLabel.setDisplayedMnemonic('P');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Entry file:");
        jPanel.add((Component)jLabel2, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDebugger = comboBox2 = new ComboBox();
        jPanel.add((Component)comboBox2, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Debugger:");
        jPanel.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        TextFieldWithCompletion textFieldWithCompletion = this.myFile;
        jPanel.add((Component)textFieldWithCompletion, new GridConstraints(4, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myWorkingDir = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton2, new GridConstraints(3, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Working directory:");
        jLabel4.setDisplayedMnemonic('W');
        jLabel4.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel4, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myProgram = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton.setEditable(true);
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(2, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("Program:");
        jLabel5.setDisplayedMnemonic('P');
        jLabel5.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel5, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.parameters = rawCommandLineEditor = new RawCommandLineEditor();
        jPanel.add((Component)rawCommandLineEditor, new GridConstraints(5, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        HoverHyperlinkLabel hoverHyperlinkLabel = this.mobdebugLink;
        jPanel.add((Component)hoverHyperlinkLabel, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 3, null, null, null));
        JLabel jLabel6 = new JLabel();
        jLabel6.setText("Environment variables:");
        jPanel.add((Component)jLabel6, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myEnvironments = environmentVariablesTextFieldWithBrowseButton = new EnvironmentVariablesTextFieldWithBrowseButton();
        jPanel.add((Component)environmentVariablesTextFieldWithBrowseButton, new GridConstraints(6, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        JLabel jLabel7 = new JLabel();
        jLabel7.setText("Output charset:");
        jLabel7.setDisplayedMnemonic('O');
        jLabel7.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel7, new GridConstraints(7, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.outputCharset = comboBox = new ComboBox();
        comboBox.setEditable(true);
        jPanel.add((Component)comboBox, new GridConstraints(7, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.showConsoleWindowCheckBox = jCheckBox = new JCheckBox();
        ((Component)jCheckBox).setEnabled(true);
        jCheckBox.setSelected(true);
        jCheckBox.setText("Show console window");
        jPanel.add((Component)jCheckBox, new GridConstraints(8, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        jLabel.setLabelFor((Component)rawCommandLineEditor);
        jLabel3.setLabelFor((Component)comboBox2);
        jLabel4.setLabelFor((Component)textFieldWithBrowseButton2);
        jLabel5.setLabelFor((Component)textFieldWithBrowseButton);
        jLabel7.setLabelFor((Component)comboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    class LuaFileCompletionProvider
    extends TextFieldCompletionProvider {
        LuaFileCompletionProvider() {
        }

        protected void addCompletionVariants(@NotNull String text, int offset, @NotNull String prefix, @NotNull CompletionResultSet result) {
            if (text == null) {
                LuaFileCompletionProvider.$$$reportNull$$$0(0);
            }
            if (prefix == null) {
                LuaFileCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                LuaFileCompletionProvider.$$$reportNull$$$0(2);
            }
            ProjectRootManager.getInstance((Project)LuaAppSettingsEditor.this.project).getFileIndex().iterateContent(virtualFile -> {
                if (!virtualFile.isDirectory() && virtualFile.getFileType() == LuaFileType.INSTANCE) {
                    String url = LuaFileUtil.getShortPath(LuaAppSettingsEditor.this.project, virtualFile);
                    result.addElement((LookupElement)LookupElementBuilder.create((String)url).withIcon(LuaIcons.FILE));
                }
                return true;
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "prefix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/immomo/emmylua/lua/debugger/app/LuaAppSettingsEditor$LuaFileCompletionProvider";
            objectArray[2] = "addCompletionVariants";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

