/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.emmylua.lua.debugger.app;

import com.immomo.emmylua.lua.debugger.DebuggerType;
import com.immomo.emmylua.lua.debugger.IRemoteConfiguration;
import com.immomo.emmylua.lua.debugger.LuaCommandLineState;
import com.immomo.emmylua.lua.debugger.LuaRunConfiguration;
import com.immomo.emmylua.lua.debugger.app.LuaAppSettingsEditor;
import com.immomo.emmylua.lua.psi.LuaFileUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.execution.ParametersListUtil;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u00104\u001a\u000205H\u0016J\b\u00106\u001a\u000207H\u0016J\u0010\u00108\u001a\n\u0012\u0006\b\u0001\u0012\u00020:09H\u0016J\u001a\u0010;\u001a\u0004\u0018\u00010<2\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020@H\u0016J\u000e\u0010A\u001a\b\u0012\u0004\u0012\u00020C0BH\u0016J\u0010\u0010D\u001a\u0002052\u0006\u0010E\u001a\u00020FH\u0016J\u0010\u0010G\u001a\u0002052\u0006\u0010E\u001a\u00020FH\u0016R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u00020\u000f8FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\u0004\u0018\u00010\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000bR\u001c\u0010\u0016\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u000b\"\u0004\b\u0018\u0010\rR\u001c\u0010\u0019\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u000b\"\u0004\b\u001b\u0010\rR\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\t0\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020!X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u001a\u0010$\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u000b\"\u0004\b&\u0010\rR\u001a\u0010'\u001a\u00020(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u0013\u0010-\u001a\u0004\u0018\u00010.8F\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u001e\u00101\u001a\u0004\u0018\u00010\t8FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010\u000b\"\u0004\b3\u0010\r\u00a8\u0006H"}, d2={"Lcom/immomo/emmylua/lua/debugger/app/LuaAppRunConfiguration;", "Lcom/immomo/emmylua/lua/debugger/LuaRunConfiguration;", "Lcom/immomo/emmylua/lua/debugger/IRemoteConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "factory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/execution/configurations/ConfigurationFactory;)V", "charset", "", "getCharset", "()Ljava/lang/String;", "setCharset", "(Ljava/lang/String;)V", "debuggerType", "Lcom/immomo/emmylua/lua/debugger/DebuggerType;", "getDebuggerType", "()Lcom/immomo/emmylua/lua/debugger/DebuggerType;", "setDebuggerType", "(Lcom/immomo/emmylua/lua/debugger/DebuggerType;)V", "defaultWorkingDir", "getDefaultWorkingDir", "file", "getFile", "setFile", "parameters", "getParameters", "setParameters", "parametersArray", "", "getParametersArray", "()[Ljava/lang/String;", "port", "", "getPort", "()I", "program", "getProgram", "setProgram", "showConsole", "", "getShowConsole", "()Z", "setShowConsole", "(Z)V", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getVirtualFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "workingDir", "getWorkingDir", "setWorkingDir", "checkConfiguration", "", "createCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "getConfigurationEditor", "Lcom/intellij/openapi/options/SettingsEditor;", "Lcom/intellij/execution/configurations/RunConfiguration;", "getState", "Lcom/intellij/execution/configurations/RunProfileState;", "executor", "Lcom/intellij/execution/Executor;", "executionEnvironment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "getValidModules", "", "Lcom/intellij/openapi/module/Module;", "readExternal", "element", "Lorg/jdom/Element;", "writeExternal", "MMPaas"})
public final class LuaAppRunConfiguration
extends LuaRunConfiguration
implements IRemoteConfiguration {
    @NotNull
    private String program;
    @Nullable
    private String file;
    @Nullable
    private String parameters;
    @NotNull
    private String charset;
    private boolean showConsole;
    @NotNull
    private DebuggerType debuggerType;
    private final int port = 8172;
    @Nullable
    private String workingDir;

    @NotNull
    public final String getProgram() {
        return this.program;
    }

    public final void setProgram(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.program = string;
    }

    @Nullable
    public final String getFile() {
        return this.file;
    }

    public final void setFile(@Nullable String string) {
        this.file = string;
    }

    @Nullable
    public final String getParameters() {
        return this.parameters;
    }

    public final void setParameters(@Nullable String string) {
        this.parameters = string;
    }

    @NotNull
    public final String getCharset() {
        return this.charset;
    }

    public final void setCharset(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.charset = string;
    }

    public final boolean getShowConsole() {
        return this.showConsole;
    }

    public final void setShowConsole(boolean bl) {
        this.showConsole = bl;
    }

    @NotNull
    public final DebuggerType getDebuggerType() {
        if (!SystemInfoRt.isWindows && this.debuggerType == DebuggerType.Attach) {
            this.debuggerType = DebuggerType.Mob;
        }
        return this.debuggerType;
    }

    public final void setDebuggerType(@NotNull DebuggerType debuggerType) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)debuggerType), (String)"<set-?>");
        this.debuggerType = debuggerType;
    }

    @NotNull
    public Collection<Module> getValidModules() {
        return CollectionsKt.emptyList();
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        SettingsEditorGroup group = new SettingsEditorGroup();
        group.addEditor("program", (SettingsEditor)new LuaAppSettingsEditor(this.getProject()));
        return (SettingsEditor)group;
    }

    @Nullable
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment executionEnvironment) throws ExecutionException {
        Intrinsics.checkParameterIsNotNull((Object)executor, (String)"executor");
        Intrinsics.checkParameterIsNotNull((Object)executionEnvironment, (String)"executionEnvironment");
        return (RunProfileState)new LuaCommandLineState(executionEnvironment);
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        super.writeExternal(element);
        JDOMExternalizerUtil.writeField((Element)element, (String)"program", (String)this.program);
        JDOMExternalizerUtil.writeField((Element)element, (String)"file", (String)this.file);
        JDOMExternalizerUtil.writeField((Element)element, (String)"workingDir", (String)this.getWorkingDir());
        JDOMExternalizerUtil.writeField((Element)element, (String)"debuggerType", (String)String.valueOf(this.getDebuggerType().value()));
        JDOMExternalizerUtil.writeField((Element)element, (String)"params", (String)this.parameters);
        JDOMExternalizerUtil.writeField((Element)element, (String)"charset", (String)this.charset);
        JDOMExternalizerUtil.writeField((Element)element, (String)"showConsole", (String)(this.showConsole ? "true" : "false"));
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        String it;
        String string;
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        super.readExternal(element);
        String string2 = JDOMExternalizerUtil.readField((Element)element, (String)"program");
        if (string2 != null) {
            it = string = string2;
            boolean bl = false;
            String string3 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"it");
            this.program = string3;
        }
        this.file = JDOMExternalizerUtil.readField((Element)element, (String)"file");
        this.workingDir = JDOMExternalizerUtil.readField((Element)element, (String)"workingDir");
        String string4 = JDOMExternalizerUtil.readField((Element)element, (String)"debuggerType");
        if (string4 != null) {
            it = string = string4;
            boolean bl = false;
            DebuggerType debuggerType = DebuggerType.valueOf(Integer.parseInt(it));
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)debuggerType), (String)"DebuggerType.valueOf(Integer.parseInt(it))");
            this.debuggerType = debuggerType;
        }
        this.parameters = JDOMExternalizerUtil.readField((Element)element, (String)"params");
        String string5 = JDOMExternalizerUtil.readField((Element)element, (String)"charset");
        if (string5 == null) {
            string5 = "UTF-8";
        }
        this.charset = string5;
        this.showConsole = Intrinsics.areEqual((Object)JDOMExternalizerUtil.readField((Element)element, (String)"showConsole"), (Object)"true");
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Nullable
    public final VirtualFile getVirtualFile() {
        return LuaFileUtil.findFile(this.getProject(), this.file);
    }

    @NotNull
    public final String[] getParametersArray() {
        Collection $receiver$iv;
        CharSequence charSequence;
        String file;
        ArrayList<String> list = new ArrayList<String>();
        String string = this.parameters;
        if (string != null) {
            boolean bl;
            CharSequence charSequence2 = string;
            boolean bl2 = false;
            boolean bl3 = bl = charSequence2.length() == 0;
            if (bl2 == bl) {
                String string2 = this.parameters;
                if (string2 == null) {
                    Intrinsics.throwNpe();
                }
                String[] stringArray = ParametersListUtil.parseToArray((String)string2);
                Intrinsics.checkExpressionValueIsNotNull((Object)stringArray, (String)"ParametersListUtil.parseToArray(parameters!!)");
                String[] strings = stringArray;
                list.addAll((Collection)Arrays.asList(Arrays.copyOf(strings, strings.length)));
            }
        }
        if ((file = this.file) != null && (charSequence = (CharSequence)file).length() > 0) {
            list.add(file);
        }
        Collection thisCollection$iv = $receiver$iv = (Collection)list;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return stringArray;
    }

    @Nullable
    public final String getWorkingDir() {
        CharSequence charSequence;
        String wd = this.workingDir;
        if (wd == null || (charSequence = (CharSequence)wd).length() == 0) {
            this.workingDir = this.getDefaultWorkingDir();
            return this.getDefaultWorkingDir();
        }
        return wd;
    }

    public final void setWorkingDir(@Nullable String string) {
        this.workingDir = string;
    }

    private final String getDefaultWorkingDir() {
        Module[] modules;
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.getProject());
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
        Module[] moduleArray = moduleManager.getModules();
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleArray, (String)"ModuleManager.getInstance(project).modules");
        for (Module module : modules = moduleArray) {
            VirtualFile[] sourceRoots;
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(module)");
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleRootManager.getSourceRoots(), (String)"ModuleRootManager.getInstance(module).sourceRoots");
            VirtualFile[] virtualFileArray = sourceRoots;
            int n = virtualFileArray.length;
            for (int i = 0; i < n; ++i) {
                VirtualFile sourceRoot;
                VirtualFile virtualFile = sourceRoot = virtualFileArray[i];
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"sourceRoot");
                String path = virtualFile.getCanonicalPath();
                if (path == null) continue;
                return path;
            }
        }
        return null;
    }

    public void checkConfiguration() {
        super.checkConfiguration();
        String program = this.program;
        CharSequence charSequence = program;
        if (charSequence.length() == 0) {
            throw (Throwable)new RuntimeConfigurationError("Program doesn't exist.");
        }
        String workingDir = this.getWorkingDir();
        if (workingDir == null || !new File(workingDir).exists()) {
            throw (Throwable)new RuntimeConfigurationError("Working dir doesn't exist.");
        }
    }

    @Override
    @NotNull
    public GeneralCommandLine createCommandLine() {
        String[] stringArray = this.getParametersArray();
        GeneralCommandLine generalCommandLine = new GeneralCommandLine().withExePath(this.program).withEnvironment(this.getEnvs()).withParameters(Arrays.copyOf(stringArray, stringArray.length)).withWorkDirectory(this.getWorkingDir()).withCharset(Charset.forName(this.charset));
        Intrinsics.checkExpressionValueIsNotNull((Object)generalCommandLine, (String)"GeneralCommandLine().wit\u2026Charset.forName(charset))");
        return generalCommandLine;
    }

    public LuaAppRunConfiguration(@NotNull Project project, @NotNull ConfigurationFactory factory) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)factory, (String)"factory");
        super(project, factory);
        Object object = PathEnvironmentVariableUtil.findInPath((String)"llua");
        if (object == null || (object = ((File)object).getAbsolutePath()) == null) {
            object = SystemInfoRt.isWindows ? "lua.exe" : "lua";
        }
        this.program = object;
        this.charset = "UTF-8";
        this.showConsole = true;
        this.debuggerType = DebuggerType.Attach;
        this.port = 8172;
    }
}

