/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.emmylua.lua.debugger.app;

import com.immomo.emmylua.lua.debugger.DebugLogger;
import com.immomo.emmylua.lua.debugger.LogConsoleType;
import com.immomo.emmylua.lua.debugger.app.LuaAppRunConfiguration;
import com.immomo.emmylua.lua.debugger.remote.LuaMobDebugProcess;
import com.immomo.emmylua.lua.psi.LuaFileUtil;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XDebugSession;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/immomo/emmylua/lua/debugger/app/LuaAppMobProcess;", "Lcom/immomo/emmylua/lua/debugger/remote/LuaMobDebugProcess;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "(Lcom/intellij/xdebugger/XDebugSession;)V", "configuration", "Lcom/immomo/emmylua/lua/debugger/app/LuaAppRunConfiguration;", "isStopped", "", "sessionInitialized", "", "stop", "MMPaas"})
public final class LuaAppMobProcess
extends LuaMobDebugProcess {
    private final LuaAppRunConfiguration configuration;
    private boolean isStopped;

    @Override
    public void sessionInitialized() {
        String string;
        String[] stringArray;
        super.sessionInitialized();
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string2 = "%s/?.lua;";
        Object[] objectArray = new Object[]{LuaFileUtil.getPluginVirtualFile("debugger/mobdebug")};
        String[] stringArray2 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)stringArray2, (String)"java.lang.String.format(format, *args)");
        String[] stringArray3 = stringArray = stringArray2;
        StringBuilder setupPackagePath = new StringBuilder((String)stringArray3);
        XDebugSession xDebugSession = this.getSession();
        Intrinsics.checkExpressionValueIsNotNull((Object)xDebugSession, (String)"session");
        ModuleManager moduleManager = ModuleManager.getInstance((Project)xDebugSession.getProject());
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleManager, (String)"ModuleManager.getInstance(session.project)");
        Module[] moduleArray = moduleManager.getModules();
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleArray, (String)"ModuleManager.getInstance(session.project).modules");
        Module[] modules = moduleArray;
        for (Module module : modules) {
            VirtualFile[] sourceRoots;
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(module)");
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleRootManager.getSourceRoots(), (String)"ModuleRootManager.getInstance(module).sourceRoots");
            VirtualFile[] virtualFileArray = sourceRoots;
            int n = virtualFileArray.length;
            for (int i = 0; i < n; ++i) {
                VirtualFile sourceRoot;
                VirtualFile virtualFile = sourceRoot = virtualFileArray[i];
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"sourceRoot");
                String path = virtualFile.getCanonicalPath();
                if (path == null) continue;
                setupPackagePath.append(path).append("/?.lua;");
            }
        }
        GeneralCommandLine commandLine = new GeneralCommandLine(new String[]{this.configuration.getProgram()});
        String[] stringArray4 = new String[2];
        stringArray4[0] = "-e";
        StringCompanionObject stringCompanionObject2 = StringCompanionObject.INSTANCE;
        Object object = "package.path = package.path .. ';%s' require('mobdebug').start()";
        Object object2 = new Object[]{setupPackagePath.toString()};
        int n = 1;
        stringArray = stringArray4;
        String[] stringArray5 = stringArray4;
        GeneralCommandLine generalCommandLine = commandLine;
        String string3 = String.format((String)object, Arrays.copyOf(object2, ((Object[])object2).length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(format, *args)");
        stringArray[n] = string = string3;
        generalCommandLine.addParameters(stringArray5);
        String[] stringArray6 = new String[1];
        String string4 = this.configuration.getFile();
        if (string4 == null) {
            Intrinsics.throwNpe();
        }
        stringArray6[0] = string4;
        commandLine.addParameters(stringArray6);
        String dir = this.configuration.getWorkingDir();
        if (dir != null && !((object = (CharSequence)dir).length() == 0)) {
            commandLine.setWorkDirectory(dir);
        }
        try {
            OSProcessHandler handler2 = new OSProcessHandler(commandLine);
            handler2.addProcessListener(new ProcessListener(this){
                final /* synthetic */ LuaAppMobProcess this$0;

                public void startNotified(@NotNull ProcessEvent processEvent) {
                    Intrinsics.checkParameterIsNotNull((Object)processEvent, (String)"processEvent");
                }

                public void processTerminated(@NotNull ProcessEvent processEvent) {
                    Intrinsics.checkParameterIsNotNull((Object)processEvent, (String)"processEvent");
                    if (!LuaAppMobProcess.access$isStopped$p(this.this$0)) {
                        this.this$0.getSession().stop();
                    }
                }

                public void processWillTerminate(@NotNull ProcessEvent processEvent, boolean b) {
                    Intrinsics.checkParameterIsNotNull((Object)processEvent, (String)"processEvent");
                }

                public void onTextAvailable(@NotNull ProcessEvent processEvent, @NotNull Key<?> key) {
                    Intrinsics.checkParameterIsNotNull((Object)processEvent, (String)"processEvent");
                    Intrinsics.checkParameterIsNotNull(key, (String)"key");
                    if (key == ProcessOutputTypes.STDOUT) {
                        String string = processEvent.getText();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"processEvent.text");
                        ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.NORMAL_OUTPUT;
                        Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType, (String)"ConsoleViewContentType.NORMAL_OUTPUT");
                        this.this$0.print(string, LogConsoleType.NORMAL, consoleViewContentType);
                    } else if (key == ProcessOutputTypes.STDERR) {
                        String string = processEvent.getText();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"processEvent.text");
                        DebugLogger.DefaultImpls.error$default(this.this$0, string, null, 2, null);
                    }
                }
                {
                    this.this$0 = $outer;
                }
            });
            handler2.startNotify();
        }
        catch (Exception e) {
            String string5 = e.getMessage();
            if (string5 != null) {
                Object it = object2 = string5;
                boolean bl = false;
                DebugLogger.DefaultImpls.error$default(this, (String)it, null, 2, null);
            }
            this.getSession().stop();
        }
    }

    @Override
    public void stop() {
        this.isStopped = true;
        super.stop();
    }

    public LuaAppMobProcess(@NotNull XDebugSession session) {
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        super(session);
        RunProfile runProfile = session.getRunProfile();
        if (runProfile == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.immomo.emmylua.lua.debugger.app.LuaAppRunConfiguration");
        }
        this.configuration = (LuaAppRunConfiguration)runProfile;
    }

    public static final /* synthetic */ boolean access$isStopped$p(LuaAppMobProcess $this) {
        return $this.isStopped;
    }

    public static final /* synthetic */ void access$setStopped$p(LuaAppMobProcess $this, boolean bl) {
        $this.isStopped = bl;
    }
}

