/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.emmylua.lua.debugger.app;

import com.immomo.emmylua.lua.LuaBundle;
import com.immomo.emmylua.lua.debugger.LogConsoleType;
import com.immomo.emmylua.lua.debugger.app.LuaAppAttachBridge;
import com.immomo.emmylua.lua.debugger.app.LuaAppAttachBridge$WhenMappings;
import com.immomo.emmylua.lua.debugger.app.LuaAppRunConfiguration;
import com.immomo.emmylua.lua.debugger.attach.LuaAttachBridgeBase;
import com.immomo.emmylua.lua.debugger.attach.LuaAttachDebugProcessBase;
import com.immomo.emmylua.lua.debugger.attach.LuaAttachMessage;
import com.immomo.emmylua.lua.psi.LuaFileUtil;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XDebugSession;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.Charsets;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00009\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0016\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012R\u0010\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006\u0013"}, d2={"Lcom/immomo/emmylua/lua/debugger/app/LuaAppAttachBridge;", "Lcom/immomo/emmylua/lua/debugger/attach/LuaAttachBridgeBase;", "process", "Lcom/immomo/emmylua/lua/debugger/attach/LuaAttachDebugProcessBase;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "(Lcom/immomo/emmylua/lua/debugger/attach/LuaAttachDebugProcessBase;Lcom/intellij/xdebugger/XDebugSession;)V", "processListener", "com/immomo/emmylua/lua/debugger/app/LuaAppAttachBridge$processListener$1", "Lcom/immomo/emmylua/lua/debugger/app/LuaAppAttachBridge$processListener$1;", "handleMessage", "", "message", "Lcom/immomo/emmylua/lua/debugger/attach/LuaAttachMessage;", "launch", "program", "", "configuration", "Lcom/immomo/emmylua/lua/debugger/app/LuaAppRunConfiguration;", "MMPaas"})
public final class LuaAppAttachBridge
extends LuaAttachBridgeBase {
    private final processListener.1 processListener;

    public final void launch(@NotNull String program, @NotNull LuaAppRunConfiguration configuration) {
        Intrinsics.checkParameterIsNotNull((Object)program, (String)"program");
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        VirtualFile pluginVirtualDirectory = LuaFileUtil.getPluginVirtualDirectory();
        String workingDir = configuration.getWorkingDir();
        try {
            if (pluginVirtualDirectory != null) {
                CharSequence charSequence;
                if (workingDir == null || (charSequence = (CharSequence)workingDir).length() == 0) {
                    throw (Throwable)new Exception("Working directory not found.");
                }
                String archExe = LuaFileUtil.getArchExeFile();
                String[] stringArray = new String[1];
                String string = archExe;
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                stringArray[0] = string;
                ProcessBuilder processBuilder = new ProcessBuilder(stringArray);
                boolean isX86 = false;
                Process archChecker = processBuilder.command(archExe, "arch", "-file", program).start();
                archChecker.waitFor();
                int exitValue = archChecker.exitValue();
                if (exitValue == -1) {
                    String string2;
                    StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                    String string3 = "Program [%s] not found.";
                    Object[] objectArray = new Object[]{program};
                    String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"java.lang.String.format(format, *args)");
                    String string5 = string2 = string4;
                    throw (Throwable)new Exception(string5);
                }
                isX86 = exitValue == 1;
                String archType = isX86 ? "x86" : "x64";
                LuaAttachDebugProcessBase luaAttachDebugProcessBase = this.getProcess();
                String string6 = LuaBundle.message("run.attach.launch_info", program, archType);
                Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"LuaBundle.message(\"run.a\u2026info\", program, archType)");
                ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.SYSTEM_OUTPUT;
                Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType, (String)"ConsoleViewContentType.SYSTEM_OUTPUT");
                luaAttachDebugProcessBase.println(string6, LogConsoleType.NORMAL, consoleViewContentType);
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string7 = "debugger/windows/%s/emmy.tool.exe";
                Object[] objectArray = new Object[]{archType};
                String string8 = String.format(string7, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"java.lang.String.format(format, *args)");
                String exe = LuaFileUtil.getPluginVirtualFile(string8);
                String[] stringArray2 = new String[1];
                String string9 = exe;
                if (string9 == null) {
                    Intrinsics.throwNpe();
                }
                stringArray2[0] = string9;
                GeneralCommandLine commandLine = new GeneralCommandLine(stringArray2);
                commandLine.withEnvironment(configuration.getEnvs());
                commandLine.setCharset(Charset.forName("UTF-8"));
                commandLine.addParameters(new String[]{"-m", "run", "--cmd", program, "-e", this.getEmmyLua(), "-w", workingDir, "--console", configuration.getShowConsole() ? "true" : "false"});
                Object[] args = configuration.getParametersArray();
                String argString = ArraysKt.joinToString$default((Object[])args, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
                CharSequence charSequence2 = argString;
                if (!(charSequence2.length() == 0)) {
                    commandLine.addParameters(new String[]{"-a", argString});
                }
                this.setHandler(new OSProcessHandler(commandLine));
                OSProcessHandler oSProcessHandler = this.getHandler();
                if (oSProcessHandler == null) {
                    Intrinsics.throwNpe();
                }
                oSProcessHandler.addProcessListener((ProcessListener)this.processListener);
                OSProcessHandler oSProcessHandler2 = this.getHandler();
                if (oSProcessHandler2 == null) {
                    Intrinsics.throwNpe();
                }
                oSProcessHandler2.startNotify();
            }
        }
        catch (Exception e) {
            LuaAttachDebugProcessBase luaAttachDebugProcessBase = this.getProcess();
            String string = e.getMessage();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            luaAttachDebugProcessBase.error(string, LogConsoleType.EMMY);
            this.getSession().stop();
        }
    }

    @Override
    protected void handleMessage(@NotNull LuaAttachMessage message2) {
        Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
        switch (LuaAppAttachBridge$WhenMappings.$EnumSwitchMapping$0[message2.getId().ordinal()]) {
            case 1: {
                Object object = this.getHandler();
                if (object != null && (object = object.getProcess()) != null && (object = ((Process)object).getOutputStream()) != null) {
                    Object object2;
                    Object it = object2 = object;
                    boolean bl = false;
                    String string = "resume\n";
                    Object object3 = it;
                    Charset charset = Charsets.UTF_8;
                    byte[] byArray = string.getBytes(charset);
                    Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                    byte[] byArray2 = byArray;
                    ((OutputStream)object3).write(byArray2);
                    ((OutputStream)it).flush();
                }
                break;
            }
            default: {
                super.handleMessage(message2);
            }
        }
    }

    public LuaAppAttachBridge(@NotNull LuaAttachDebugProcessBase process2, @NotNull XDebugSession session) {
        Intrinsics.checkParameterIsNotNull((Object)process2, (String)"process");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        super(process2, session);
        this.processListener = new ProcessListener(this){
            final /* synthetic */ LuaAppAttachBridge this$0;

            public void startNotified(@NotNull ProcessEvent processEvent) {
                Intrinsics.checkParameterIsNotNull((Object)processEvent, (String)"processEvent");
            }

            public void processTerminated(@NotNull ProcessEvent processEvent) {
                Intrinsics.checkParameterIsNotNull((Object)processEvent, (String)"processEvent");
                LuaAppAttachBridge.access$onDebugHelperExit(this.this$0, processEvent.getExitCode());
                this.this$0.stop();
            }

            public void processWillTerminate(@NotNull ProcessEvent processEvent, boolean b) {
                Intrinsics.checkParameterIsNotNull((Object)processEvent, (String)"processEvent");
            }

            public void onTextAvailable(@NotNull ProcessEvent processEvent, @NotNull Key<?> key) {
                block3: {
                    String text;
                    Intrinsics.checkParameterIsNotNull((Object)processEvent, (String)"processEvent");
                    Intrinsics.checkParameterIsNotNull(key, (String)"key");
                    if (Intrinsics.areEqual(key, (Object)ProcessOutputTypes.SYSTEM)) {
                        return;
                    }
                    String string = text = processEvent.getText();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"text");
                    if (!StringsKt.startsWith$default((String)string, (String)"port:", (boolean)false, (int)2, null)) break block3;
                    Regex reg = new Regex("port:(\\d+)");
                    MatchResult matchResult = Regex.find$default((Regex)reg, (CharSequence)text, (int)0, (int)2, null);
                    if (matchResult != null) {
                        MatchResult matchResult2;
                        MatchResult it = matchResult2 = matchResult;
                        boolean bl = false;
                        MatchGroup matchGroup = it.getGroups().get(1);
                        if (matchGroup == null) {
                            Intrinsics.throwNpe();
                        }
                        String string2 = matchGroup.getValue();
                        int p = Integer.parseInt(string2);
                        LuaAppAttachBridge.access$connect(this.this$0, p);
                    }
                }
            }
            {
                this.this$0 = $outer;
            }
        };
    }

    public static final /* synthetic */ void access$onDebugHelperExit(LuaAppAttachBridge $this, int code) {
        $this.onDebugHelperExit(code);
    }

    public static final /* synthetic */ void access$connect(LuaAppAttachBridge $this, int port) {
        $this.connect(port);
    }
}

