/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.emmylua.lua.debugger;

import com.immomo.emmylua.lua.psi.LuaFileUtil;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/immomo/emmylua/lua/debugger/LuaTracebackFilter;", "Lcom/intellij/execution/filters/Filter;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "applyFilter", "Lcom/intellij/execution/filters/Filter$Result;", "line", "", "entireLength", "", "MMPaas"})
public final class LuaTracebackFilter
implements Filter {
    private final Project project;

    @Nullable
    public Filter.Result applyFilter(@NotNull String line, int entireLength) {
        Intrinsics.checkParameterIsNotNull((Object)line, (String)"line");
        Pattern pattern = Pattern.compile("\\s*((/+)?[^<>\\\\|:\"*? ]+):(\\d+):");
        Matcher matcher = pattern.matcher(line);
        if (matcher.find()) {
            String fileName = matcher.group(1);
            int lineNumber = Integer.parseInt(matcher.group(3));
            VirtualFile file = LuaFileUtil.findFile(this.project, fileName);
            if (file != null) {
                OpenFileHyperlinkInfo hyperlink = new OpenFileHyperlinkInfo(this.project, file, lineNumber - 1);
                int textStartOffset = entireLength - line.length();
                int startPos = matcher.start(1);
                int endPos = matcher.end(3) + 1;
                return new Filter.Result(startPos + textStartOffset, endPos + textStartOffset, (HyperlinkInfo)hyperlink);
            }
        }
        return null;
    }

    public LuaTracebackFilter(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
    }
}

