/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.emmylua.lua.debugger;

import com.immomo.emmylua.lua.debugger.app.LuaAppConfigurationType;
import com.immomo.emmylua.lua.debugger.app.LuaAppRunConfiguration;
import com.immomo.emmylua.lua.lang.LuaFileType;
import com.immomo.emmylua.lua.project.LLuaSourceRootManager;
import com.immomo.emmylua.lua.psi.LuaFileUtil;
import com.immomo.emmylua.lua.psi.LuaPsiFile;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016J&\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0014\u00a8\u0006\r"}, d2={"Lcom/immomo/emmylua/lua/debugger/LuaRunConfigurationProducer;", "Lcom/intellij/execution/actions/RunConfigurationProducer;", "Lcom/immomo/emmylua/lua/debugger/app/LuaAppRunConfiguration;", "()V", "isConfigurationFromContext", "", "luaAppRunConfiguration", "configurationContext", "Lcom/intellij/execution/actions/ConfigurationContext;", "setupConfigurationFromContext", "ref", "Lcom/intellij/openapi/util/Ref;", "Lcom/intellij/psi/PsiElement;", "MMPaas"})
public final class LuaRunConfigurationProducer
extends RunConfigurationProducer<LuaAppRunConfiguration> {
    protected boolean setupConfigurationFromContext(@NotNull LuaAppRunConfiguration luaAppRunConfiguration, @NotNull ConfigurationContext configurationContext, @NotNull Ref<PsiElement> ref) {
        PsiElement element;
        Intrinsics.checkParameterIsNotNull((Object)luaAppRunConfiguration, (String)"luaAppRunConfiguration");
        Intrinsics.checkParameterIsNotNull((Object)configurationContext, (String)"configurationContext");
        Intrinsics.checkParameterIsNotNull(ref, (String)"ref");
        PsiElement psiElement = element = (PsiElement)ref.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"element");
        PsiFile psiFile = psiElement.getContainingFile();
        if (!(psiFile instanceof LuaPsiFile)) {
            psiFile = null;
        }
        LuaPsiFile luaPsiFile = (LuaPsiFile)psiFile;
        if (luaPsiFile == null) {
            return false;
        }
        LuaPsiFile containingFile = luaPsiFile;
        luaAppRunConfiguration.setFile(LuaFileUtil.getShortPath(element.getProject(), containingFile.getVirtualFile()));
        luaAppRunConfiguration.setName(containingFile.getName());
        PsiDirectory psiDirectory = containingFile.getParent();
        VirtualFile dir = psiDirectory != null ? psiDirectory.getVirtualFile() : null;
        Module module = configurationContext.getModule();
        if (dir != null && module != null) {
            Project project = element.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"element.project");
            LLuaSourceRootManager rootManager = LLuaSourceRootManager.Companion.getInstance(project);
            for (VirtualFile root : rootManager.getSourceRoots()) {
                String string = root.getUrl();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"root.url");
                String string2 = dir.getUrl();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"dir.url");
                if (!StringsKt.startsWith$default((String)string, (String)string2, (boolean)false, (int)2, null)) continue;
                luaAppRunConfiguration.setWorkingDir(root.getCanonicalPath());
                break;
            }
        }
        return true;
    }

    public boolean isConfigurationFromContext(@NotNull LuaAppRunConfiguration luaAppRunConfiguration, @NotNull ConfigurationContext configurationContext) {
        Intrinsics.checkParameterIsNotNull((Object)luaAppRunConfiguration, (String)"luaAppRunConfiguration");
        Intrinsics.checkParameterIsNotNull((Object)configurationContext, (String)"configurationContext");
        PsiElement psiElement = configurationContext.getPsiLocation();
        if (psiElement == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"configurationContext.psiLocation ?: return false");
        PsiElement element = psiElement;
        PsiFile psiFile = element.getContainingFile();
        if (psiFile == null || psiFile.getFileType() != LuaFileType.INSTANCE) {
            return false;
        }
        VirtualFile file = luaAppRunConfiguration.getVirtualFile();
        return Intrinsics.areEqual((Object)psiFile.getVirtualFile(), (Object)file);
    }

    public LuaRunConfigurationProducer() {
        super((ConfigurationType)LuaAppConfigurationType.getInstance());
    }
}

