/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.emmylua.lua.codeInsight.intention;

import com.immomo.emmylua.lua.codeInsight.intention.FunctionIntention;
import com.immomo.emmylua.lua.codeInsight.template.macro.SuggestTypeMacro;
import com.immomo.emmylua.lua.psi.LuaCommentOwner;
import com.immomo.emmylua.lua.psi.LuaFuncBody;
import com.immomo.emmylua.lua.psi.LuaFuncBodyOwner;
import com.immomo.emmylua.lua.psi.LuaParamNameDef;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.impl.TextExpression;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0017J\b\u0010\u0005\u001a\u00020\u0004H\u0016J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/immomo/emmylua/lua/codeInsight/intention/CreateFunctionDocIntention;", "Lcom/immomo/emmylua/lua/codeInsight/intention/FunctionIntention;", "()V", "getFamilyName", "", "getText", "invoke", "", "bodyOwner", "Lcom/immomo/emmylua/lua/psi/LuaFuncBodyOwner;", "editor", "Lcom/intellij/openapi/editor/Editor;", "isAvailable", "", "MMPaas"})
public final class CreateFunctionDocIntention
extends FunctionIntention {
    @Override
    public boolean isAvailable(@NotNull LuaFuncBodyOwner bodyOwner, @NotNull Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)bodyOwner, (String)"bodyOwner");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        if (bodyOwner instanceof LuaCommentOwner) {
            return ((LuaCommentOwner)((Object)bodyOwner)).getComment() == null || bodyOwner.getFuncBody() == null;
        }
        return false;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @NotNull
    public String getText() {
        return "Create LuaDoc";
    }

    @Override
    public void invoke(@NotNull LuaFuncBodyOwner bodyOwner, @NotNull Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)bodyOwner, (String)"bodyOwner");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        LuaFuncBody funcBody = bodyOwner.getFuncBody();
        if (funcBody != null) {
            TemplateManager templateManager = TemplateManager.getInstance((Project)bodyOwner.getProject());
            Template template = templateManager.createTemplate("", "");
            StringBuilder stringBuilder = new StringBuilder().append("---");
            String string = bodyOwner.getName();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            template.addTextSegment(stringBuilder.append(string).toString());
            MacroCallNode typeSuggest = new MacroCallNode((Macro)new SuggestTypeMacro());
            List<LuaParamNameDef> list = funcBody.getParamNameDefList();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"funcBody.paramNameDefList");
            List<LuaParamNameDef> parDefList = list;
            for (LuaParamNameDef parDef : parDefList) {
                String string2;
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string3 = "\n---@param %s ";
                Object[] objectArray = new Object[1];
                LuaParamNameDef luaParamNameDef = parDef;
                Intrinsics.checkExpressionValueIsNotNull((Object)luaParamNameDef, (String)"parDef");
                objectArray[0] = luaParamNameDef.getName();
                Object[] objectArray2 = objectArray;
                Template template2 = template;
                Intrinsics.checkExpressionValueIsNotNull((Object)String.format(string3, Arrays.copyOf(objectArray2, objectArray2.length)), (String)"java.lang.String.format(format, *args)");
                template2.addTextSegment(string2);
                template.addVariable(parDef.getName(), (Expression)typeSuggest, (Expression)new TextExpression("table"), false);
            }
            template.addEndVariable();
            template.addTextSegment("\n");
            ASTNode aSTNode = bodyOwner.getNode();
            Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"bodyOwner.node");
            int textOffset = aSTNode.getStartOffset();
            editor.getCaretModel().moveToOffset(textOffset);
            templateManager.startTemplate(editor, template);
        }
    }
}

