/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.emmylua.lua.codeInsight.inspection;

import com.immomo.emmylua.lua.lang.LuaLanguageLevel;
import com.immomo.emmylua.lua.lang.LuaParserDefinition;
import com.immomo.emmylua.lua.project.LLuaSettings;
import com.immomo.emmylua.lua.project.StdLibraryProvider;
import com.immomo.emmylua.lua.psi.LuaBinaryOp;
import com.immomo.emmylua.lua.psi.LuaPsiElementKt;
import com.immomo.emmylua.lua.psi.LuaUnaryOp;
import com.immomo.emmylua.lua.psi.LuaVisitor;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.TokenSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u000f"}, d2={"Lcom/immomo/emmylua/lua/codeInsight/inspection/LLuaLanguageLevelInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "registerOperatorProblem", "", "o", "Lcom/intellij/psi/PsiElement;", "desc", "", "MMPaas"})
public final class LLuaLanguageLevelInspection
extends LocalInspectionTool {
    private final void registerOperatorProblem(PsiElement o, String desc, ProblemsHolder holder) {
        holder.registerProblem(o, desc, new LocalQuickFix[]{new LocalQuickFix(){

            @NotNull
            public String getFamilyName() {
                return "Upgrade language level to Lua 5.2";
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
                LLuaSettings.Companion.getInstance().setLanguageLevel(LuaLanguageLevel.LUA52);
                StdLibraryProvider.Companion.reload();
            }
        }});
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        return new LuaVisitor(this, holder){
            final /* synthetic */ LLuaLanguageLevelInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;

            public void visitBinaryOp(@NotNull LuaBinaryOp o) {
                Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
                if (LuaPsiElementKt.getLanguageLevel(o).compareTo((Enum)LuaLanguageLevel.LUA52) < 0) {
                    TokenSet tokenSet = LuaParserDefinition.Companion.getLUA52_BIN_OP_SET();
                    ASTNode aSTNode = o.getNode();
                    Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"o.node");
                    ASTNode aSTNode2 = aSTNode.getFirstChildNode();
                    Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode2, (String)"o.node.firstChildNode");
                    if (tokenSet.contains(aSTNode2.getElementType())) {
                        String desc = "The binary operator '" + o.getText() + "' only available in Lua 5.2 or above";
                        LLuaLanguageLevelInspection.access$registerOperatorProblem(this.this$0, (PsiElement)o, desc, this.$holder);
                    }
                }
            }

            public void visitUnaryOp(@NotNull LuaUnaryOp o) {
                Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
                if (LuaPsiElementKt.getLanguageLevel(o).compareTo((Enum)LuaLanguageLevel.LUA52) < 0) {
                    TokenSet tokenSet = LuaParserDefinition.Companion.getLUA52_UNARY_OP_SET();
                    ASTNode aSTNode = o.getNode();
                    Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"o.node");
                    ASTNode aSTNode2 = aSTNode.getFirstChildNode();
                    Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode2, (String)"o.node.firstChildNode");
                    if (tokenSet.contains(aSTNode2.getElementType())) {
                        String desc = "The unary operator '" + o.getText() + "' only available in Lua 5.2 or above";
                        LLuaLanguageLevelInspection.access$registerOperatorProblem(this.this$0, (PsiElement)o, desc, this.$holder);
                    }
                }
            }
            {
                this.this$0 = $outer;
                this.$holder = $captured_local_variable$1;
            }
        };
    }

    public static final /* synthetic */ void access$registerOperatorProblem(LLuaLanguageLevelInspection $this, PsiElement o, String desc, ProblemsHolder holder) {
        $this.registerOperatorProblem(o, desc, holder);
    }
}

