/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.emmylua.lua.annotator;

import com.immomo.emmylua.lua.comment.psi.LuaDocClassNameRef;
import com.immomo.emmylua.lua.comment.psi.LuaDocParamNameRef;
import com.immomo.emmylua.lua.comment.psi.LuaDocPsiElement;
import com.immomo.emmylua.lua.comment.psi.LuaDocTagAlias;
import com.immomo.emmylua.lua.comment.psi.LuaDocTagClass;
import com.immomo.emmylua.lua.comment.psi.LuaDocTagField;
import com.immomo.emmylua.lua.comment.psi.LuaDocVisitor;
import com.immomo.emmylua.lua.highlighting.LuaHighlightingData;
import com.immomo.emmylua.lua.psi.LuaCallExpr;
import com.immomo.emmylua.lua.psi.LuaClassMethodName;
import com.immomo.emmylua.lua.psi.LuaExpr;
import com.immomo.emmylua.lua.psi.LuaExprCodeFragment;
import com.immomo.emmylua.lua.psi.LuaExprStat;
import com.immomo.emmylua.lua.psi.LuaFileUtil;
import com.immomo.emmylua.lua.psi.LuaFuncDef;
import com.immomo.emmylua.lua.psi.LuaIndexExpr;
import com.immomo.emmylua.lua.psi.LuaLocalDef;
import com.immomo.emmylua.lua.psi.LuaLocalFuncDef;
import com.immomo.emmylua.lua.psi.LuaNameDef;
import com.immomo.emmylua.lua.psi.LuaNameExpr;
import com.immomo.emmylua.lua.psi.LuaNameList;
import com.immomo.emmylua.lua.psi.LuaParamNameDef;
import com.immomo.emmylua.lua.psi.LuaPsiElement;
import com.immomo.emmylua.lua.psi.LuaPsiFile;
import com.immomo.emmylua.lua.psi.LuaPsiResolveUtilKt;
import com.immomo.emmylua.lua.psi.LuaTableField;
import com.immomo.emmylua.lua.psi.LuaVisitor;
import com.immomo.emmylua.lua.psi.PsiExtensionKt;
import com.immomo.emmylua.lua.search.SearchContext;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 \u00152\u00020\u0001:\u0003\u0015\u0016\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nH\u0016J\u001c\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000e2\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002R\u0012\u0010\u0003\u001a\u00060\u0004R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00060\bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/immomo/emmylua/lua/annotator/LuaAnnotator;", "Lcom/intellij/lang/annotation/Annotator;", "()V", "docVisitor", "Lcom/immomo/emmylua/lua/annotator/LuaAnnotator$LuaDocElementVisitor;", "isModuleFile", "", "luaVisitor", "Lcom/immomo/emmylua/lua/annotator/LuaAnnotator$LuaElementVisitor;", "myHolder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "annotate", "", "psiElement", "Lcom/intellij/psi/PsiElement;", "annotationHolder", "createInfoAnnotation", "Lcom/intellij/lang/annotation/Annotation;", "psi", "msg", "", "Companion", "LuaDocElementVisitor", "LuaElementVisitor", "MMPaas"})
public final class LuaAnnotator
implements Annotator {
    private AnnotationHolder myHolder;
    private final LuaElementVisitor luaVisitor = new LuaElementVisitor();
    private final LuaDocElementVisitor docVisitor = new LuaDocElementVisitor();
    private boolean isModuleFile;
    private static final Key<Boolean> STD_MARKER;
    private static final HighlightSeverity UPVALUE;
    public static final Companion Companion;

    public void annotate(@NotNull PsiElement psiElement, @NotNull AnnotationHolder annotationHolder) {
        Intrinsics.checkParameterIsNotNull((Object)psiElement, (String)"psiElement");
        Intrinsics.checkParameterIsNotNull((Object)annotationHolder, (String)"annotationHolder");
        this.myHolder = annotationHolder;
        if (psiElement instanceof LuaDocPsiElement) {
            psiElement.accept((PsiElementVisitor)this.docVisitor);
        } else if (psiElement instanceof LuaPsiElement) {
            PsiFile psiFile = ((LuaPsiElement)psiElement).getContainingFile();
            this.isModuleFile = psiFile instanceof LuaPsiFile ? ((LuaPsiFile)psiFile).getModuleName() != null : false;
            psiElement.accept((PsiElementVisitor)this.luaVisitor);
        }
        this.myHolder = null;
    }

    private final Annotation createInfoAnnotation(PsiElement psi, String msg) {
        AnnotationHolder annotationHolder = this.myHolder;
        if (annotationHolder == null) {
            Intrinsics.throwNpe();
        }
        Annotation annotation = annotationHolder.createInfoAnnotation(psi, msg);
        Intrinsics.checkExpressionValueIsNotNull((Object)annotation, (String)"myHolder!!.createInfoAnnotation(psi, msg)");
        return annotation;
    }

    static /* synthetic */ Annotation createInfoAnnotation$default(LuaAnnotator luaAnnotator, PsiElement psiElement, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        return luaAnnotator.createInfoAnnotation(psiElement, string);
    }

    static {
        Companion = new Companion(null);
        Key key = Key.create((String)"llua.std.marker");
        Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"Key.create<Boolean>(\"llua.std.marker\")");
        STD_MARKER = key;
        UPVALUE = new HighlightSeverity("UPVALUE", HighlightSeverity.INFORMATION.myVal + 1);
    }

    public static final /* synthetic */ void access$setMyHolder$p(LuaAnnotator $this, AnnotationHolder annotationHolder) {
        $this.myHolder = annotationHolder;
    }

    public static final /* synthetic */ void access$setModuleFile$p(LuaAnnotator $this, boolean bl) {
        $this.isModuleFile = bl;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0017H\u0016\u00a8\u0006\u0018"}, d2={"Lcom/immomo/emmylua/lua/annotator/LuaAnnotator$LuaElementVisitor;", "Lcom/immomo/emmylua/lua/psi/LuaVisitor;", "(Lcom/immomo/emmylua/lua/annotator/LuaAnnotator;)V", "checkUpValue", "", "o", "Lcom/immomo/emmylua/lua/psi/LuaNameExpr;", "visitClassMethodName", "Lcom/immomo/emmylua/lua/psi/LuaClassMethodName;", "visitExprStat", "Lcom/immomo/emmylua/lua/psi/LuaExprStat;", "visitFuncDef", "Lcom/immomo/emmylua/lua/psi/LuaFuncDef;", "visitIndexExpr", "Lcom/immomo/emmylua/lua/psi/LuaIndexExpr;", "visitLocalDef", "Lcom/immomo/emmylua/lua/psi/LuaLocalDef;", "visitLocalFuncDef", "Lcom/immomo/emmylua/lua/psi/LuaLocalFuncDef;", "visitNameExpr", "visitParamNameDef", "Lcom/immomo/emmylua/lua/psi/LuaParamNameDef;", "visitTableField", "Lcom/immomo/emmylua/lua/psi/LuaTableField;", "MMPaas"})
    public final class LuaElementVisitor
    extends LuaVisitor {
        @Override
        public void visitExprStat(@NotNull LuaExprStat o) {
            Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
            if (!(o.getExpr() instanceof LuaCallExpr)) {
                if (!(o.getContainingFile() instanceof LuaExprCodeFragment)) {
                    AnnotationHolder annotationHolder = LuaAnnotator.this.myHolder;
                    if (annotationHolder == null) {
                        Intrinsics.throwNpe();
                    }
                    annotationHolder.createErrorAnnotation((PsiElement)o, "syntax error");
                }
            } else {
                super.visitExprStat(o);
            }
        }

        @Override
        public void visitLocalFuncDef(@NotNull LuaLocalFuncDef o) {
            Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
            PsiElement name = o.getNameIdentifier();
            if (name != null) {
                Annotation annotation = LuaAnnotator.this.createInfoAnnotation(name, "Local function \"" + o.getName() + '\"');
                annotation.setTextAttributes(LuaHighlightingData.INSTANCE.getLOCAL_VAR());
            }
        }

        @Override
        public void visitLocalDef(@NotNull LuaLocalDef o) {
            Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
            LuaNameList nameList = o.getNameList();
            if (nameList != null) {
                for (PsiElement child = nameList.getFirstChild(); child != null; child = child.getNextSibling()) {
                    if (!(child instanceof LuaNameDef)) continue;
                    Annotation annotation = LuaAnnotator.this.createInfoAnnotation(child, "Local variable \"" + ((LuaNameDef)child).getName() + '\"');
                    annotation.setTextAttributes(LuaHighlightingData.INSTANCE.getLOCAL_VAR());
                }
            }
            super.visitLocalDef(o);
        }

        @Override
        public void visitTableField(@NotNull LuaTableField o) {
            Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
            super.visitTableField(o);
            PsiElement id = o.getId();
            if (id != null) {
                Annotation annotation = LuaAnnotator.createInfoAnnotation$default(LuaAnnotator.this, id, null, 2, null);
                annotation.setTextAttributes(LuaHighlightingData.INSTANCE.getFIELD());
            }
        }

        @Override
        public void visitFuncDef(@NotNull LuaFuncDef o) {
            Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
            PsiElement name = o.getNameIdentifier();
            if (name != null && PsiExtensionKt.getForwardDeclaration(o) == null) {
                if (LuaAnnotator.this.isModuleFile) {
                    Annotation annotation = LuaAnnotator.this.createInfoAnnotation(name, "Module function \"" + o.getName() + '\"');
                    annotation.setTextAttributes(LuaHighlightingData.INSTANCE.getINSTANCE_METHOD());
                } else {
                    Annotation annotation = LuaAnnotator.this.createInfoAnnotation(name, "Global function \"" + o.getName() + '\"');
                    annotation.setTextAttributes(LuaHighlightingData.INSTANCE.getGLOBAL_FUNCTION());
                }
            }
        }

        @Override
        public void visitClassMethodName(@NotNull LuaClassMethodName o) {
            Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
            PsiElement psiElement = o.getId();
            if (psiElement == null) {
                return;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"o.id ?: return");
            PsiElement id = psiElement;
            Annotation annotation = LuaAnnotator.createInfoAnnotation$default(LuaAnnotator.this, id, null, 2, null);
            if (o.getDot() != null) {
                annotation.setTextAttributes(LuaHighlightingData.INSTANCE.getSTATIC_METHOD());
            } else {
                annotation.setTextAttributes(LuaHighlightingData.INSTANCE.getINSTANCE_METHOD());
            }
        }

        @Override
        public void visitParamNameDef(@NotNull LuaParamNameDef o) {
            Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
            Annotation annotation = LuaAnnotator.this.createInfoAnnotation((PsiElement)o, "Parameter : \"" + o.getName() + '\"');
            annotation.setTextAttributes(LuaHighlightingData.INSTANCE.getPARAMETER());
        }

        @Override
        public void visitNameExpr(@NotNull LuaNameExpr o) {
            Annotation annotation;
            Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
            PsiElement id = o.getFirstChild();
            Project project = o.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"o.project");
            PsiElement res = LuaPsiResolveUtilKt.resolve(o, SearchContext.Companion.get(project));
            if (res != null) {
                PsiFile containingFile;
                PsiFile psiFile = containingFile = res.getContainingFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"containingFile");
                if (LuaFileUtil.isStdLibFile(psiFile.getVirtualFile(), o.getProject())) {
                    Annotation annotation2 = LuaAnnotator.this.createInfoAnnotation((PsiElement)o, "Std apis");
                    annotation2.setTextAttributes(LuaHighlightingData.INSTANCE.getSTD_API());
                    o.putUserData(STD_MARKER, true);
                    return;
                }
            }
            if (res instanceof LuaParamNameDef) {
                annotation = LuaAnnotator.this.createInfoAnnotation((PsiElement)o, "Parameter : \"" + ((LuaParamNameDef)res).getName() + '\"');
                annotation.setTextAttributes(LuaHighlightingData.INSTANCE.getPARAMETER());
                this.checkUpValue(o);
            } else if (res instanceof LuaFuncDef) {
                PsiFile resolvedFile = ((LuaFuncDef)res).getContainingFile();
                if (!(resolvedFile instanceof LuaPsiFile) || ((LuaPsiFile)resolvedFile).getModuleName() == null) {
                    Annotation annotation3 = LuaAnnotator.this.createInfoAnnotation((PsiElement)o, "Global function : \"" + ((LuaFuncDef)res).getName() + '\"');
                    annotation3.setTextAttributes(LuaHighlightingData.INSTANCE.getGLOBAL_FUNCTION());
                } else {
                    LuaAnnotator.this.createInfoAnnotation((PsiElement)o, "Module function : \"" + ((LuaFuncDef)res).getName() + '\"');
                }
            } else if (id.textMatches((CharSequence)"self")) {
                annotation = LuaAnnotator.createInfoAnnotation$default(LuaAnnotator.this, (PsiElement)o, null, 2, null);
                annotation.setTextAttributes(LuaHighlightingData.INSTANCE.getSELF());
                this.checkUpValue(o);
            } else if (res instanceof LuaNameDef) {
                annotation = LuaAnnotator.this.createInfoAnnotation((PsiElement)o, "Local variable \"" + o.getName() + '\"');
                annotation.setTextAttributes(LuaHighlightingData.INSTANCE.getLOCAL_VAR());
                this.checkUpValue(o);
            } else if (res instanceof LuaLocalFuncDef) {
                annotation = LuaAnnotator.this.createInfoAnnotation((PsiElement)o, "Local function \"" + o.getName() + '\"');
                annotation.setTextAttributes(LuaHighlightingData.INSTANCE.getLOCAL_VAR());
                this.checkUpValue(o);
            } else if (LuaAnnotator.this.isModuleFile) {
                annotation = LuaAnnotator.this.createInfoAnnotation((PsiElement)o, "Module field \"" + o.getName() + '\"');
                annotation.setTextAttributes(LuaHighlightingData.INSTANCE.getFIELD());
            } else {
                annotation = LuaAnnotator.this.createInfoAnnotation((PsiElement)o, "Global variable \"" + o.getName() + '\"');
                annotation.setTextAttributes(LuaHighlightingData.INSTANCE.getGLOBAL_VAR());
            }
        }

        private final void checkUpValue(LuaNameExpr o) {
            block1: {
                Annotation annotation;
                Project project = o.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"o.project");
                boolean upValue = LuaPsiResolveUtilKt.isUpValue(o, SearchContext.Companion.get(project));
                if (!upValue) break block1;
                AnnotationHolder annotationHolder = LuaAnnotator.this.myHolder;
                Annotation annotation2 = annotation = annotationHolder != null ? annotationHolder.createAnnotation(UPVALUE, o.getTextRange(), "Up-value \"" + o.getName() + '\"') : null;
                if (annotation2 != null) {
                    annotation2.setTextAttributes(LuaHighlightingData.INSTANCE.getUP_VALUE());
                }
            }
        }

        @Override
        public void visitIndexExpr(@NotNull LuaIndexExpr o) {
            Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
            super.visitIndexExpr(o);
            LuaExpr prefix = PsiExtensionKt.getPrefixExpr(o);
            if (prefix instanceof LuaNameExpr && prefix.getUserData(STD_MARKER) != null) {
                Annotation annotation = LuaAnnotator.this.createInfoAnnotation((PsiElement)o, "Std apis");
                annotation.setTextAttributes(LuaHighlightingData.INSTANCE.getSTD_API());
                o.putUserData(STD_MARKER, true);
            } else {
                PsiElement id = o.getId();
                if (id != null) {
                    Annotation annotation = LuaAnnotator.this.createInfoAnnotation(id, null);
                    if (o.getParent() instanceof LuaCallExpr) {
                        if (o.getColon() != null) {
                            annotation.setTextAttributes(LuaHighlightingData.INSTANCE.getINSTANCE_METHOD());
                        } else {
                            annotation.setTextAttributes(LuaHighlightingData.INSTANCE.getSTATIC_METHOD());
                        }
                    } else if (o.getColon() != null) {
                        AnnotationHolder annotationHolder = LuaAnnotator.this.myHolder;
                        if (annotationHolder == null) {
                            Intrinsics.throwNpe();
                        }
                        annotationHolder.createErrorAnnotation((PsiElement)o, "Arguments expected");
                    } else {
                        annotation.setTextAttributes(LuaHighlightingData.INSTANCE.getFIELD());
                    }
                }
            }
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/immomo/emmylua/lua/annotator/LuaAnnotator$LuaDocElementVisitor;", "Lcom/immomo/emmylua/lua/comment/psi/LuaDocVisitor;", "(Lcom/immomo/emmylua/lua/annotator/LuaAnnotator;)V", "visitClassNameRef", "", "o", "Lcom/immomo/emmylua/lua/comment/psi/LuaDocClassNameRef;", "visitParamNameRef", "Lcom/immomo/emmylua/lua/comment/psi/LuaDocParamNameRef;", "visitTagAlias", "Lcom/immomo/emmylua/lua/comment/psi/LuaDocTagAlias;", "visitTagClass", "Lcom/immomo/emmylua/lua/comment/psi/LuaDocTagClass;", "visitTagField", "Lcom/immomo/emmylua/lua/comment/psi/LuaDocTagField;", "MMPaas"})
    public final class LuaDocElementVisitor
    extends LuaDocVisitor {
        @Override
        public void visitTagClass(@NotNull LuaDocTagClass o) {
            Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
            super.visitTagClass(o);
            PsiElement psiElement = o.getId();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"o.id");
            Annotation annotation = LuaAnnotator.this.createInfoAnnotation(psiElement, null);
            annotation.setTextAttributes(LuaHighlightingData.INSTANCE.getCLASS_NAME());
        }

        @Override
        public void visitTagAlias(@NotNull LuaDocTagAlias o) {
            Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
            super.visitTagAlias(o);
            PsiElement psiElement = o.getId();
            if (psiElement == null) {
                return;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"o.id ?: return");
            PsiElement id = psiElement;
            Annotation annotation = LuaAnnotator.this.createInfoAnnotation(id, null);
            annotation.setTextAttributes(LuaHighlightingData.INSTANCE.getTYPE_ALIAS());
        }

        @Override
        public void visitClassNameRef(@NotNull LuaDocClassNameRef o) {
            Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
            Annotation annotation = LuaAnnotator.this.createInfoAnnotation((PsiElement)o, null);
            annotation.setTextAttributes(LuaHighlightingData.INSTANCE.getCLASS_REFERENCE());
        }

        @Override
        public void visitTagField(@NotNull LuaDocTagField o) {
            Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
            super.visitTagField(o);
            PsiElement id = o.getNameIdentifier();
            if (id != null) {
                Annotation annotation = LuaAnnotator.this.createInfoAnnotation(id, null);
                annotation.setTextAttributes(LuaHighlightingData.INSTANCE.getDOC_COMMENT_TAG_VALUE());
            }
        }

        @Override
        public void visitParamNameRef(@NotNull LuaDocParamNameRef o) {
            Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
            Annotation annotation = LuaAnnotator.this.createInfoAnnotation((PsiElement)o, null);
            annotation.setTextAttributes(LuaHighlightingData.INSTANCE.getDOC_COMMENT_TAG_VALUE());
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/immomo/emmylua/lua/annotator/LuaAnnotator$Companion;", "", "()V", "STD_MARKER", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "UPVALUE", "Lcom/intellij/lang/annotation/HighlightSeverity;", "MMPaas"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

