/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.emmylua.lua.annotator;

import com.immomo.emmylua.lua.project.LLuaSettings;
import com.immomo.emmylua.lua.psi.LuaPsiFile;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/immomo/emmylua/lua/annotator/LargerFileAnnotator;", "Lcom/intellij/lang/annotation/Annotator;", "()V", "annotate", "", "psiElement", "Lcom/intellij/psi/PsiElement;", "annotationHolder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "MMPaas"})
public final class LargerFileAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement psiElement, @NotNull AnnotationHolder annotationHolder) {
        Intrinsics.checkParameterIsNotNull((Object)psiElement, (String)"psiElement");
        Intrinsics.checkParameterIsNotNull((Object)annotationHolder, (String)"annotationHolder");
        if (psiElement instanceof LuaPsiFile && ((LuaPsiFile)psiElement).getTooLarger()) {
            VirtualFile file = ((LuaPsiFile)psiElement).getVirtualFile();
            String string = StringUtil.formatFileSize((long)((long)LLuaSettings.Companion.getInstance().getTooLargerFileThreshold() * 1024L));
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringUtil.formatFileSiz\u2026gerFileThreshold * 1024L)");
            String fileLimit = string;
            VirtualFile virtualFile = file;
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"file");
            String string2 = StringUtil.formatFileSize((long)virtualFile.getLength());
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"StringUtil.formatFileSize(file.length)");
            String fileSize = string2;
            Annotation annotation = annotationHolder.createWarningAnnotation(psiElement, "The file size (" + fileSize + ") exceeds configured limit (" + fileLimit + "). Code insight features are not available.");
            Intrinsics.checkExpressionValueIsNotNull((Object)annotation, (String)"annotationHolder.createW\u2026available.\"\n            )");
            annotation.setFileLevelAnnotation(true);
        }
    }
}

