/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.core.parser.view.generate;

import com.immomo.core.parser.config.Constants;
import com.immomo.core.parser.config.ViewConifg;
import com.immomo.core.parser.config.ViewInfo;
import com.immomo.core.parser.token.LLuaToken;
import com.immomo.core.parser.util.TokenUtil;
import com.immomo.core.parser.view.View;
import com.immomo.core.parser.view.ViewAttributeType;
import com.immomo.core.parser.view.generate.AttributeCombining;
import com.immomo.core.parser.view.generate.DataCombining;
import com.immomo.core.parser.view.generate.FuncCombining;
import com.immomo.core.parser.view.generate.StyleCombining;
import com.immomo.core.parser.view.generate.ViewNameUtil;
import java.util.LinkedHashMap;
import java.util.List;

public class ViewCombining {
    private String indentString;
    static AttributeCombining _attributeCombining = new AttributeCombining();
    static DataCombining _dataCombining = new DataCombining();
    private AttributeCombining attributeCombining;
    private DataCombining dataCombining;
    static FuncCombining _funcCombining = new FuncCombining();
    static StyleCombining _styleCombining = new StyleCombining();
    static StringBuilder empty = new StringBuilder();

    public ViewCombining() {
    }

    public ViewCombining(AttributeCombining attributeCombining, DataCombining dataCombining) {
        this.attributeCombining = attributeCombining;
        this.dataCombining = dataCombining;
    }

    public void update(AttributeCombining attributeCombining, DataCombining dataCombining) {
        this.attributeCombining = attributeCombining;
        this.dataCombining = dataCombining;
    }

    public void updateAttribute(AttributeCombining attributeCombining) {
        this.attributeCombining = attributeCombining;
    }

    public void updateData(DataCombining dataCombining) {
        this.dataCombining = dataCombining;
    }

    public StringBuilder viewToString(View view) {
        if (view.getCLASS().equals(Constants.WINDOW_CLASS)) {
            return new StringBuilder();
        }
        StringBuilder str = new StringBuilder();
        String variableStr = this.viewVariableName(view.variableName) + " = ";
        this.updateIndent(variableStr.length() - 1);
        str.append(variableStr);
        ViewNameUtil.addViewName(view.variableName);
        str.append((CharSequence)this.createViewInitString(view));
        str.append((CharSequence)this.attributesToString(view));
        str.append((CharSequence)this.funcAttributesToString(view));
        str.append((CharSequence)this.styleAttributesToString(view, view.getAttributeMap(ViewAttributeType.STYLE, false)));
        str.append((CharSequence)this.dataBindToString(view));
        return str;
    }

    protected String viewVariableName(String viewName) {
        return Constants.LOCAL + " " + viewName;
    }

    protected void updateIndent(int length) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            stringBuilder.append(' ');
        }
        this.indentString = stringBuilder.toString();
    }

    protected StringBuilder createViewInitString(View view) {
        StringBuilder stringBuilder = new StringBuilder();
        ViewInfo viewInfo = ViewConifg.INSTANCE.getViewInfo(view.getCLASS());
        if (viewInfo.hasInitCLZ()) {
            stringBuilder.append(viewInfo.getInitCLZ());
        } else {
            stringBuilder.append(viewInfo.getCLASS()).append('(');
            if (view.getAttributeMap(ViewAttributeType.ATTRIBUTE).containsKey(view.getCLASS())) {
                stringBuilder.append(TokenUtil.getTokenParametersToString(view.getAttributeMap(ViewAttributeType.ATTRIBUTE).get(view.getCLASS())));
                view.getAttributeMap(ViewAttributeType.ATTRIBUTE).remove(view.getCLASS());
            }
            stringBuilder.append(')');
        }
        TokenUtil.appendNewLine(stringBuilder);
        return stringBuilder;
    }

    protected StringBuilder attributesToString(View view) {
        if (this.attributeCombining == null) {
            this.attributeCombining = _attributeCombining;
        }
        StringBuilder stringBuilder = this.attributeCombining.attributesToString(view, this.indentString);
        TokenUtil.appendNewLine(stringBuilder);
        return stringBuilder;
    }

    public StringBuilder funcAttributesToString(View view) {
        if (view.getAttributeMap(ViewAttributeType.FUNC, false) == null) {
            return empty;
        }
        StringBuilder stringBuilder = _funcCombining.toString(view, this.dataCombining == null ? _dataCombining : this.dataCombining);
        TokenUtil.appendNewLine(stringBuilder);
        return stringBuilder;
    }

    public StringBuilder funcToString(String viewName, String attribute, List<LLuaToken> params) {
        return _funcCombining.funcToString(viewName, attribute, params, this.dataCombining == null ? _dataCombining : this.dataCombining);
    }

    public StringBuilder funcToString(String viewName, String selfName, String attribute, List<LLuaToken> params, boolean inserParams) {
        return _funcCombining.funcToString(viewName, selfName, attribute, params, this.dataCombining == null ? _dataCombining : this.dataCombining, inserParams);
    }

    public StringBuilder styleAttributesToString(View view, LinkedHashMap<String, List<LLuaToken>> style) {
        return _styleCombining.styleToString(view, style);
    }

    public StringBuilder styleToString(String viewName, LLuaToken styleName) {
        return _styleCombining.styleToString(viewName, styleName);
    }

    public StringBuilder dataBindToString(View view) {
        if (view.getAttributeMap(ViewAttributeType.BINDDATA, false) == null) {
            return empty;
        }
        if (this.dataCombining == null) {
            this.dataCombining = _dataCombining;
        }
        StringBuilder stringBuilder = this.dataCombining.dataBindToString(view);
        TokenUtil.appendNewLine(stringBuilder);
        return stringBuilder;
    }
}

