/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.core.parser.view.generate;

import com.immomo.core.parser.token.LLuaToken;
import com.immomo.core.parser.util.TokenUtil;
import com.immomo.core.parser.view.View;
import com.immomo.core.parser.view.ViewAttributeType;
import com.immomo.core.parser.view.generate.DataCombining;
import java.util.List;
import java.util.Map;

public class FuncCombining {
    public StringBuilder toString(View view, DataCombining dataCombining) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, List<LLuaToken>> entry : view.getAttributeMap(ViewAttributeType.FUNC).entrySet()) {
            stringBuilder.append((CharSequence)this.funcToString(view.variableName, entry.getKey(), entry.getValue(), dataCombining));
        }
        return stringBuilder;
    }

    public StringBuilder funcToString(String viewName, String attribute, List<LLuaToken> params, DataCombining dataCombining) {
        return this.funcToString(viewName, viewName, attribute, params, dataCombining, false);
    }

    public StringBuilder funcToString(String viewName, String selfName, String attribute, List<LLuaToken> params, DataCombining dataCombining, boolean insertParams) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(viewName).append(':').append(attribute).append("(function(");
        if (insertParams) {
            try {
                String parameters = TokenUtil.getTokenParametersToString(params.get((int)0).next.params);
                stringBuilder.append(parameters);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        stringBuilder.append(")\n");
        stringBuilder.append((CharSequence)dataCombining.dataBindBindToString(selfName, params, false));
        TokenUtil.appendNewLine(stringBuilder);
        stringBuilder.append("end)\n");
        return stringBuilder;
    }
}

