/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.core.parser.view;

import com.immomo.core.parser.LLuaParserStack;
import com.immomo.core.parser.config.Constants;
import com.immomo.core.parser.config.ViewConifg;
import com.immomo.core.parser.config.ViewFuncAttributes;
import com.immomo.core.parser.config.ViewInfo;
import com.immomo.core.parser.resolver.base.ResolverName;
import com.immomo.core.parser.token.LLuaToken;
import com.immomo.core.parser.util.TokenUtil;
import com.immomo.core.parser.view.BaseView;
import com.immomo.core.parser.view.ViewAttributeType;
import com.immomo.core.parser.view.ViewType;
import com.immomo.core.parser.view.generate.ViewCombining;
import java.lang.reflect.Constructor;
import java.util.List;

public class View
extends BaseView {
    private String deep = "";

    @Override
    public ViewType viewType() {
        return ViewType.VIEW;
    }

    public static View view(String variableName, String viewCLASS) {
        ViewInfo viewInfo = ViewConifg.INSTANCE.getViewInfo(viewCLASS);
        if (viewInfo == null) {
            return new View(variableName, viewCLASS);
        }
        try {
            Constructor<View> view = viewInfo.getViewClass().getDeclaredConstructor(String.class, String.class);
            view.setAccessible(true);
            return view.newInstance(variableName, viewCLASS);
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    protected View(String variableName, String clz) {
        super(variableName, clz);
    }

    @Override
    public String desViewLayout() {
        this.deep = "";
        return this._viewLayout();
    }

    @Override
    public StringBuilder desSourceCode() {
        if (this.getViewCombining() == null) {
            this.setViewCombining(new ViewCombining());
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((CharSequence)this.getViewCombining().viewToString(this));
        for (View subView : this.subViews) {
            stringBuilder.append((CharSequence)subView.desSourceCode());
            stringBuilder.append(this.variableName).append(":addView(").append(subView.variableName).append(")\n");
        }
        TokenUtil.appendNewLine(stringBuilder);
        return stringBuilder;
    }

    @Override
    public void handleAttribute(String attribute, List<LLuaToken> params) {
        ViewInfo viewInfo;
        if (ViewConifg.INSTANCE.isView(attribute) && (viewInfo = ViewConifg.INSTANCE.getViewInfo(attribute)).hasInitMapAttribute()) {
            attribute = viewInfo.getInitMapAttribute();
        }
        boolean isBindData = false;
        if (attribute.equals(Constants.BIND)) {
            isBindData = true;
        } else if (this.checkParamsIsDataBind(params)) {
            isBindData = true;
        }
        if (ViewFuncAttributes.INSTANCE.isFuncAttribute(attribute)) {
            this.getAttributeMap(ViewAttributeType.FUNC).put(attribute, params);
        } else if (attribute.equals(Constants.STYLE)) {
            this.getAttributeMap(ViewAttributeType.STYLE).put(attribute, params);
        } else if (isBindData) {
            this.getAttributeMap(ViewAttributeType.BINDDATA).put(attribute, params);
        } else if (params != null && params.size() > 0 && params.get((int)0).token == 265) {
            this.getAttributeMap(ViewAttributeType.FUNC).put(attribute, params);
        } else {
            this.getAttributeMap(ViewAttributeType.ATTRIBUTE).put(attribute, params);
        }
    }

    protected boolean checkParamsIsDataBind(List<LLuaToken> params) {
        for (LLuaToken token : params) {
            while (token != null) {
                if (token.token == 288 && LLuaParserStack.getMainAdapter().containModule(ResolverName.MODEL, token.value)) {
                    return true;
                }
                token = token.next;
            }
        }
        return false;
    }

    private String _viewLayout() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.getCLASS() != null) {
            stringBuilder.append(this.getCLASS());
            stringBuilder.append('<');
            if (this.attributes != null) {
                for (String string : this.getAttributeMap(ViewAttributeType.ATTRIBUTE).keySet()) {
                    stringBuilder.append(string).append(':');
                }
                if (stringBuilder.charAt(stringBuilder.length() - 1) == ':') {
                    stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                }
            }
            stringBuilder.append('>').append(":").append(this.variableName);
        }
        for (View view : this.subViews) {
            view.deep = this.deep + " ----";
            stringBuilder.append('\n').append(view.deep).append(view._viewLayout());
        }
        return stringBuilder.toString();
    }
}

