/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.core.parser.view;

import com.immomo.core.parser.config.list.ListInfo;
import com.immomo.core.parser.view.Cell;
import com.immomo.core.parser.view.ListView;
import com.immomo.core.parser.view.generate.ViewNameUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TableView
extends ListView {
    protected TableView(String variableName, String clz) {
        super(variableName, clz);
    }

    @Override
    protected StringBuilder createCellSourceBefore(List<Cell> cells, ListInfo listInfo) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((CharSequence)this.createAdapterSections(cells, listInfo));
        stringBuilder.append((CharSequence)this.combingAdapterHeightCells(cells, listInfo));
        stringBuilder.append((CharSequence)this.combingAdapterInitCells(cells));
        ArrayList<Cell> copyCells = new ArrayList<Cell>();
        copyCells.addAll(cells);
        Collections.reverse(copyCells);
        stringBuilder.append((CharSequence)this.combingAdapterFillCells(copyCells));
        return stringBuilder;
    }

    protected StringBuilder createAdapterSections(List<Cell> cells, ListInfo listInfo) {
        String adapterName = this.getAdapterName();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(adapterName).append(":sectionCount(function()\n").append("return DataBinding:getSectionCount(\"").append(this.bindDataSource).append("\")\nend)\n");
        stringBuilder.append(adapterName).append(":rowCount(function(section)\n").append("return DataBinding:getRowCount(\"").append(this.bindDataSource).append("\", section").append(")\nend)\n");
        stringBuilder.append(adapterName).append(":reuseId(function(section, row)\n").append("return DataBinding:getReuseId(\"").append(this.bindDataSource).append("\", section, row").append(")\nend)\n");
        return stringBuilder;
    }

    protected StringBuilder combingAdapterHeightCells(List<Cell> cells, ListInfo listInfo) {
        StringBuilder stringBuilder = new StringBuilder();
        String adapterName = this.getAdapterName();
        if (!listInfo.getCLASS().toLowerCase().startsWith("auto")) {
            for (Cell cell : cells) {
                stringBuilder.append(adapterName).append(":heightForCellByReuseId(").append(cell.id).append(", function(section, row)\n").append("return DataBinding:getHeight(\"").append(this.bindDataSource).append("\", section, row").append(")\nend)\n");
            }
        }
        return stringBuilder;
    }

    protected StringBuilder combingAdapterInitCells(List<Cell> cells) {
        StringBuilder stringBuilder = new StringBuilder();
        String adapterName = this.getAdapterName();
        for (Cell cell : cells) {
            ViewNameUtil.push();
            stringBuilder.append(adapterName).append(":initCellByReuseId(").append(cell.id).append(", function(cell)\n");
            stringBuilder.append((CharSequence)this.getCellInitSource(cell));
            stringBuilder.append("end)\n");
        }
        return stringBuilder;
    }

    protected StringBuilder combingAdapterFillCells(List<Cell> cells) {
        StringBuilder stringBuilder = new StringBuilder();
        String adapterName = this.getAdapterName();
        for (Cell cell : cells) {
            stringBuilder.append(adapterName).append(":fillCellDataByReuseId(").append(cell.id).append(", function(cell, section, row)\n");
            stringBuilder.append((CharSequence)this.getCellBindSource(cell));
            stringBuilder.append("end)\n");
            ViewNameUtil.pop();
        }
        return stringBuilder;
    }
}

