/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.core.parser.view;

import com.immomo.core.parser.LLuaParserStack;
import com.immomo.core.parser.config.Constants;
import com.immomo.core.parser.config.ListViewAttributeMapConfig;
import com.immomo.core.parser.config.ViewConifg;
import com.immomo.core.parser.config.list.ListInfo;
import com.immomo.core.parser.resolver.base.ModuleResult;
import com.immomo.core.parser.resolver.base.ResolverName;
import com.immomo.core.parser.resolver.base.ResolverResult;
import com.immomo.core.parser.resolver.ui.UIResolver;
import com.immomo.core.parser.token.LLuaToken;
import com.immomo.core.parser.util.ListCellUtil;
import com.immomo.core.parser.util.TokenUtil;
import com.immomo.core.parser.util.Util;
import com.immomo.core.parser.view.Cell;
import com.immomo.core.parser.view.ScrollView;
import com.immomo.core.parser.view.View;
import com.immomo.core.parser.view.ViewAttributeType;
import com.immomo.core.parser.view.ViewType;
import com.immomo.core.parser.view.generate.ViewCombining;
import com.immomo.core.parser.view.generate.list.ListCellViewCombining;
import com.immomo.core.parser.view.generate.list.ListCellViewDataCombining;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ListView
extends ScrollView {
    protected String bindDataSource;
    private List<Cell> cells = new ArrayList<Cell>();
    static ResolverResult cellItemBindResult = new ResolverResult(Constants.LIST_CELL_ITEM);

    @Override
    public ViewType viewType() {
        return ViewType.TABLEVIEW;
    }

    protected ListView(String variableName, String clz) {
        super(variableName, clz);
    }

    public String getBindDataSource() {
        return this.bindDataSource;
    }

    protected String getAdapterName() {
        return this.variableName + "_adapter";
    }

    @Override
    public StringBuilder desSourceCode() {
        StringBuilder stringBuilder = super.desSourceCode();
        for (Cell cell : this.cells) {
            this.updateCellViewsGenerate(cell, this.getCellViewCombining(cell));
        }
        TokenUtil.appendNewLine(stringBuilder);
        stringBuilder.append("DataBinding:bindListView(\"").append(this.bindDataSource).append("\", ").append(this.variableName).append(")\n");
        ListInfo listInfo = (ListInfo)ViewConifg.INSTANCE.getViewInfo(this.getCLASS());
        stringBuilder.append((CharSequence)this.createAdapter(listInfo));
        TokenUtil.appendNewLine(stringBuilder);
        StringBuilder b_s = this.createCellSourceBefore(this.cells, listInfo);
        if (b_s != null) {
            stringBuilder.append((CharSequence)b_s);
        }
        TokenUtil.appendNewLine(stringBuilder);
        StringBuilder event_func_s = this.createAdapterEventFunc();
        if (event_func_s != null) {
            stringBuilder.append((CharSequence)event_func_s);
        }
        TokenUtil.appendNewLine(stringBuilder);
        stringBuilder.append(this.variableName).append(":adapter(").append(this.getAdapterName()).append(")\n");
        StringBuilder e_s = this.createCellSourceEnd(this.cells, listInfo);
        if (e_s != null) {
            stringBuilder.append((CharSequence)e_s);
        }
        TokenUtil.appendNewLine(stringBuilder);
        return stringBuilder;
    }

    @Override
    public void handleAttribute(String attribute, List<LLuaToken> params) {
        if (attribute.equals(Constants.LIST_BINDDATA)) {
            this.bindDataSource = Util.delStringQuo(TokenUtil.getTokenParams(params).get(0));
        } else if (attribute.equals(Constants.LIST_CELL)) {
            Cell cell = new Cell();
            this.cells.add(cell);
            cell.id = TokenUtil.getTokensString(params.get(0));
            cell.cell = this._getCellView(cell.id, params.get(1));
        } else if (ListViewAttributeMapConfig.INSTANCE.containAdapter(attribute)) {
            String mapAttribute = ListViewAttributeMapConfig.INSTANCE.getAdapter(attribute);
            LLuaToken func = params.get(0);
            String itemName = Constants.ITEM;
            if (func.token == 265 && func.next.params != null && func.next.params.size() == 4) {
                itemName = TokenUtil.getTokensString(func.next.params.get(0));
                func.next.params.remove(0);
            }
            HashMap<String, String> cellItemMap = new HashMap<String, String>();
            cellItemMap.put(itemName, Constants.LIST_CELL_ITEM);
            Util.replaceFormalPamaters(params, cellItemMap);
            this.getAttributeMap(ViewAttributeType.ADAPTER).put(mapAttribute, params);
        } else {
            super.handleAttribute(attribute, params);
        }
    }

    protected StringBuilder createAdapter(ListInfo listInfo) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Constants.LOCAL + " ");
        stringBuilder.append(this.getAdapterName() + " = ").append(listInfo.getAdapterCLZ()).append("()\n");
        return stringBuilder;
    }

    protected StringBuilder createCellSourceBefore(List<Cell> cells, ListInfo listInfo) {
        return null;
    }

    protected StringBuilder createCellSourceEnd(List<Cell> cells, ListInfo listInfo) {
        return null;
    }

    protected StringBuilder createAdapterEventFunc() {
        if (this.getAttributeMap(ViewAttributeType.ADAPTER, false) == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        String adapterName = this.getAdapterName();
        ViewCombining viewCombining = this.getCellViewCombining(null);
        this._addCellBindData();
        for (Map.Entry<String, List<LLuaToken>> entry : this.getAttributeMap(ViewAttributeType.ADAPTER).entrySet()) {
            stringBuilder.append((CharSequence)viewCombining.funcToString(adapterName, this.variableName, entry.getKey(), entry.getValue(), true));
            TokenUtil.appendNewLine(stringBuilder);
        }
        this._removeCellBindData();
        return stringBuilder;
    }

    protected ViewCombining getCellViewCombining(Cell cell) {
        ListCellViewCombining viewCombining = new ListCellViewCombining();
        ListCellViewDataCombining dataCombining = new ListCellViewDataCombining();
        dataCombining.bindDataSource = this.bindDataSource;
        viewCombining.updateData(dataCombining);
        return viewCombining;
    }

    protected StringBuilder getCellInitSource(Cell cell) {
        this._addCellBindData();
        StringBuilder stringBuilder = cell.cell.desSourceCode();
        this._removeCellBindData();
        return stringBuilder;
    }

    protected StringBuilder getCellBindSource(Cell cell) {
        this._addCellBindData();
        StringBuilder stringBuilder = ListCellViewCombining.combiningViewDataBind(cell.cell);
        if (ListCellUtil.getCellBindAttributes().size() > 0) {
            TokenUtil.appendNewLine(stringBuilder);
            stringBuilder.append("DataBinding:bindCell(\"").append(this.getBindDataSource()).append("\", section, row, {");
            int index = 0;
            for (String value : ListCellUtil.getCellBindAttributes()) {
                if (index > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append('\"').append(value).append('\"');
                ++index;
            }
            stringBuilder.append("})\n");
            ListCellUtil.clearCellBindAttributes();
        }
        this._removeCellBindData();
        return stringBuilder;
    }

    private View _getCellView(String cellID, LLuaToken token) {
        LLuaToken header = token;
        boolean isMoudle = true;
        while (header != null) {
            if (header.token == 123 && header.pre != null && header.pre.token == 41) {
                isMoudle = false;
                break;
            }
            header = header.next;
        }
        HashMap<String, String> cellItemMap = new HashMap<String, String>();
        String item = Constants.ITEM;
        LLuaToken paramToken = token;
        if (isMoudle) {
            header = token;
            paramToken = token.next;
        }
        if (paramToken.token == 40 && paramToken.params.size() > 0) {
            item = TokenUtil.getTokensString(paramToken.params.get(0));
        }
        cellItemMap.put(item, Constants.LIST_CELL_ITEM);
        View headerView = new View(Constants.LIST_CELL_CONTENT, Constants.CELL_CLASS);
        this._addCellBindData();
        new UIResolver().uiResolve(header, headerView, 1, cellItemMap);
        this._removeCellBindData();
        return headerView;
    }

    private void _addCellBindData() {
        ModuleResult moduleResult = LLuaParserStack.getMainAdapter().getModules(ResolverName.MODEL);
        moduleResult.addResolerResult(cellItemBindResult);
    }

    private void _removeCellBindData() {
        ModuleResult moduleResult = LLuaParserStack.getMainAdapter().getModules(ResolverName.MODEL);
        moduleResult.removeResolerResult(Constants.LIST_CELL_ITEM);
    }

    private void updateCellViewsGenerate(Cell cell, ViewCombining toViewCombining) {
        this.upateViewsGenerate(cell.cell, toViewCombining);
    }

    private void upateViewsGenerate(View view, ViewCombining toViewCombining) {
        if (view == null) {
            return;
        }
        view.setViewCombining(toViewCombining);
        for (View subView : view.subViews) {
            this.upateViewsGenerate(subView, toViewCombining);
        }
    }
}

