/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.core.parser.util.preview;

import com.immomo.core.parser.LLuaParserStack;
import com.immomo.core.parser.config.Constants;
import com.immomo.core.parser.resolver.base.ModuleResult;
import com.immomo.core.parser.resolver.base.ResolverName;
import com.immomo.core.parser.resolver.base.ResolverResult;
import com.immomo.core.parser.util.TokenUtil;
import com.immomo.core.parser.util.Util;
import com.immomo.core.parser.view.ListView;

public class PreViewUtil {
    public static StringBuilder previewSource(ResolverResult preview) {
        StringBuilder[] list;
        StringBuilder src = new StringBuilder("---- \u9884\u89c8 ---\n");
        src.append("local function ").append(Constants.PREVIEW).append("()\n");
        src.append("if not DataBinding then\n    DataBinding = require(\"DataKVO\"):new()\nend\n");
        ModuleResult moduleResult = LLuaParserStack.getMainAdapter().getModules(ResolverName.MODEL);
        if (moduleResult != null) {
            for (ResolverResult model : moduleResult.getResolverResults()) {
                src.append("local ").append(model.name).append(" = {}\n");
            }
        }
        if ((list = PreViewUtil._listViewPreviewSource()) != null) {
            src.append((CharSequence)list[0]);
        }
        src.append((CharSequence)preview.moduleSrc);
        TokenUtil.appendNewLine(src);
        if (moduleResult != null) {
            for (ResolverResult model : moduleResult.getResolverResults()) {
                src.append("DataBinding:mock(\"").append(model.name).append("\",").append(model.name).append(")\n");
            }
        }
        if (list != null) {
            src.append((CharSequence)list[1]);
        }
        src.append("end\n");
        src.append(Constants.PREVIEW).append("()\n\n");
        return src;
    }

    private static StringBuilder[] _listViewPreviewSource() {
        ResolverResult ui = LLuaParserStack.getMainAdapter().getModule(ResolverName.UI, Constants.UI);
        if (ui == null) {
            return null;
        }
        ListView listView = Util.findListView(ui.view);
        if (listView == null) {
            return null;
        }
        StringBuilder stringBuilder1 = new StringBuilder();
        stringBuilder1.append("local ").append(Constants.UI).append(" = {}\n");
        StringBuilder stringBuilder2 = new StringBuilder();
        stringBuilder2.append("DataBinding:mockArray(\"").append(listView.getBindDataSource()).append("\",").append(listView.getBindDataSource()).append(", ").append(Constants.UI).append(")\n");
        return new StringBuilder[]{stringBuilder1, stringBuilder2};
    }
}

