/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.core.parser.util;

import com.immomo.core.parser.LLuaParserStack;
import com.immomo.core.parser.config.Constants;
import com.immomo.core.parser.config.ViewConifg;
import com.immomo.core.parser.resolver.base.ResolverName;
import com.immomo.core.parser.token.LLuaToken;
import com.immomo.core.parser.view.ListView;
import com.immomo.core.parser.view.View;
import com.immomo.core.parser.view.ViewType;
import java.util.HashMap;
import java.util.List;

public class Util {
    public static void replaceFormalPamaters(List<LLuaToken> tokens, HashMap<String, String> parametersMap) {
        if (tokens == null) {
            return;
        }
        for (LLuaToken tk : tokens) {
            Util.replaceFormalParameter(tk, parametersMap);
        }
    }

    public static void replaceFormalParameter(LLuaToken tk, HashMap<String, String> parametersMap) {
        if (tk == null) {
            return;
        }
        if (tk.token == 288 && parametersMap.keySet().contains(tk.value)) {
            tk.value = parametersMap.get(tk.value);
        } else if (tk.token == 40) {
            Util.replaceFormalPamaters(tk.params, parametersMap);
        }
        Util.replaceFormalParameter(tk.next, parametersMap);
    }

    public static String getRemoveEnd(String v) {
        return Util.getRemoveEnd(new StringBuilder(v)).toString();
    }

    public static StringBuilder getRemoveEnd(StringBuilder v) {
        while (v.charAt(v.length() - 1) == '\n') {
            v.deleteCharAt(v.length() - 1);
        }
        if (v.toString().endsWith("end")) {
            v.delete(v.length() - 3, v.length());
        }
        if (v.length() > 0) {
            while (v.charAt(v.length() - 1) == '\n') {
                v.deleteCharAt(v.length() - 1);
            }
        }
        return v;
    }

    public static String needTransformDotToColon(LLuaToken token) {
        token = token.pre;
        if (token == null) {
            return null;
        }
        int brackets = 0;
        int braces = 0;
        int vToken = 0;
        while (true) {
            if (token == null) {
                return null;
            }
            vToken = token.token;
            if (brackets == 0 && braces == 0 && (vToken == 288 && token.pre != null && (token.pre.token >= 257 || token.pre.token != 46 && token.pre.token != 58) || vToken == 288 && token.pre == null)) break;
            if (vToken == 40) {
                ++brackets;
            } else if (vToken == 123) {
                ++braces;
            } else if (vToken == 41) {
                --brackets;
            } else if (vToken == 125) {
                --braces;
            }
            token = token.pre;
        }
        if (token.token == 288) {
            return token.value;
        }
        return null;
    }

    public static boolean isLineEnd(LLuaToken tk) {
        if (tk.next == null) {
            return true;
        }
        if (tk.pre == null) {
            return false;
        }
        return Util.isLineEnd(tk.token, tk.next.token);
    }

    public static boolean isLineEnd(int tk, int next2) {
        switch (tk) {
            case 288: {
                if (next2 == 40) {
                    return false;
                }
            }
            case 41: 
            case 125: 
            case 262: 
            case 287: 
            case 289: {
                return !Util.isOperator(next2);
            }
        }
        return false;
    }

    public static boolean isLineBegin(LLuaToken tk) {
        if (tk.pre == null) {
            return true;
        }
        return Util.isLineEnd(tk.pre);
    }

    public static boolean isViewBegin(LLuaToken tk) {
        if (tk.token == 288 && tk.pre != null && tk.next != null && tk.next.token == 40) {
            switch (tk.pre.token) {
                case 46: 
                case 58: 
                case 257: 
                case 261: 
                case 264: 
                case 265: 
                case 267: 
                case 268: 
                case 269: 
                case 271: 
                case 272: 
                case 279: 
                case 280: 
                case 281: 
                case 282: 
                case 283: 
                case 284: 
                case 285: 
                case 286: {
                    return false;
                }
            }
        } else if (tk.pre != null) {
            return false;
        }
        if (ViewConifg.INSTANCE.isView(tk.value)) {
            return true;
        }
        return LLuaParserStack.getMainAdapter().containModule(ResolverName.MODULE, tk.value) && tk.next.token == 40;
    }

    public static boolean isOperator(LLuaToken tk) {
        if (tk == null) {
            return false;
        }
        return Util.isOperator(tk.token);
    }

    public static boolean isOperator(int token) {
        switch (token) {
            case 40: 
            case 41: 
            case 44: 
            case 46: 
            case 58: 
            case 60: 
            case 61: 
            case 62: 
            case 123: 
            case 125: 
            case 257: 
            case 271: 
            case 272: 
            case 279: 
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 284: {
                return true;
            }
        }
        return false;
    }

    public static String delStringQuo(String value) {
        if (value.startsWith(Constants.QUO1) || value.startsWith(Constants.QUO2)) {
            return value.substring(1, value.length() - 1);
        }
        return value;
    }

    public static boolean isListView(View view) {
        return view.viewType() == ViewType.TABLEVIEW || view.viewType() == ViewType.COLLECTIONVIEW;
    }

    public static boolean hasListView(View view) {
        if (view.subViews != null) {
            for (View value : view.subViews) {
                if (!Util.hasListView(value)) continue;
                return true;
            }
        }
        return Util.isListView(view);
    }

    public static ListView findListView(View view) {
        if (view.subViews != null) {
            for (View value : view.subViews) {
                if (Util.findListView(value) == null) continue;
                return (ListView)value;
            }
        }
        return Util.isListView(view) ? (ListView)view : null;
    }

    public static boolean isStyle(LLuaToken token) {
        if (token.token == 40 && token.params != null && token.params.size() == 1) {
            LLuaToken pre = token.pre;
            while (pre != null) {
                if (pre.token == 123 && pre.pre != null && pre.pre.token == 61) {
                    return true;
                }
                pre = pre.pre;
            }
        }
        return false;
    }
}

