/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.core.parser.token;

import com.immomo.core.parser.config.Constants;
import com.immomo.core.parser.util.TokenUtil;
import com.luaj.vm2.LuaString;
import com.luaj.vm2.LuaValue;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;

public class LLuaToken {
    public int token = 0;
    public String value = null;
    public boolean isLine = false;
    public LLuaToken next = null;
    public LLuaToken pre = null;
    public int tokenIndex = 0;
    public boolean isDot = false;
    public List<LLuaToken> params;

    public LLuaToken(int token, LuaString value, LuaValue vv) {
        this.token = token;
        this.value = token == 288 || token == 289 ? value.toString() : (token == 287 ? vv.toString() : "");
        if (token == 289) {
            if (this.value.matches(".*@\\{(([a-z|_][a-z|A-Z|0-9|_]+)(\\.[a-z|_][a-z|A-Z|0-9|_]+)*)\\}.*")) {
                this.value = this.value.replaceAll("@\\{(([a-z|_][a-z|A-Z|0-9|_]+)(\\.[a-z|_][a-z|A-Z|0-9|_]+)*)\\}", "\"..DataBinding:get($1)..\"");
            }
            this.value = this.value.charAt(0) == '\"' ? Constants.QUO1 + this.value + Constants.QUO1 : Constants.QUO2 + this.value + Constants.QUO2;
        }
        if (token == 276 || token == 263) {
            this.token = 288;
            this.value = token == 276 ? "true" : "false";
        }
    }

    private LLuaToken() {
    }

    public String valueName() {
        if (this.token == 289) {
            return this.value.substring(1, this.value.length() - 1);
        }
        return this.value;
    }

    public LLuaToken copy() {
        LLuaToken ctoken = new LLuaToken();
        ctoken.token = this.token;
        ctoken.value = this.value;
        ctoken.isLine = this.isLine;
        ctoken.isDot = this.isDot;
        ctoken.tokenIndex = this.tokenIndex;
        ctoken.params = this.params;
        ctoken.next = this.next;
        ctoken.pre = this.pre;
        return ctoken;
    }

    public LLuaToken deepCopyIgnorePre() {
        LLuaToken ct = new LLuaToken();
        ct.token = this.token;
        ct.value = this.value;
        ct.isLine = this.isLine;
        ct.isDot = this.isDot;
        ct.tokenIndex = this.tokenIndex;
        if (this.params != null) {
            ct.params = new ArrayList<LLuaToken>();
            for (LLuaToken tk : this.params) {
                ct.params.add(tk.deepCopyIgnorePre());
            }
        }
        if (this.next != null) {
            ct.next = this.next.deepCopyIgnorePre();
        }
        ct.pre = this.pre;
        return ct;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.params != null) {
            for (LLuaToken token : this.params) {
                token.dealloc();
            }
            this.params.clear();
        }
    }

    public void dealloc() {
        LLuaToken next2 = null;
        LLuaToken token = this;
        while (token != null) {
            next2 = token.next;
            token.pre = null;
            token.next = null;
            token = next2;
        }
    }

    public String toString() {
        if (this.token < 257) {
            return new Formatter().format("token: %3d , value: %c \n           , isLine: %d , index: %4d", this.token, this.token, this.isLine ? 1 : 0, this.tokenIndex).toString();
        }
        if (this.token == 288 || this.token == 289 || this.token == 287) {
            return new Formatter().format("token: %3d , value: %s \n           , isLine: %d  , index: %4d", this.token, this.value, this.isLine ? 1 : 0, this.tokenIndex).toString();
        }
        return new Formatter().format("token: %3d , value: %s \n           , isLine: %d , index: %4d", this.token, TokenUtil.getTokenSymbolString(this), this.isLine ? 1 : 0, this.tokenIndex).toString();
    }
}

