/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.core.parser.resolver.ui;

import com.immomo.core.parser.LLuaParserStack;
import com.immomo.core.parser.config.Constants;
import com.immomo.core.parser.resolver.base.Resolver;
import com.immomo.core.parser.resolver.base.ResolverName;
import com.immomo.core.parser.resolver.base.ResolverResult;
import com.immomo.core.parser.resolver.ui.UIModuleResolver;
import com.immomo.core.parser.token.LLuaToken;
import com.immomo.core.parser.util.TokenUtil;
import com.immomo.core.parser.view.View;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UIResolver
extends Resolver {
    private HashMap<String, String> lastParamsMap = null;
    protected boolean isMultiModuleView = false;
    protected int multiModuleViewFromIndex = 0;

    @Override
    public ResolverName resolveName() {
        return ResolverName.UI;
    }

    @Override
    public boolean canResolve(LLuaToken header) {
        return header.value.toLowerCase().equals(Constants.UI);
    }

    @Override
    public ResolverResult resolve(LLuaToken header) {
        this.resetViewIndexID();
        View superView = View.view("window", Constants.WINDOW_CLASS);
        this.uiResolve(header, superView, 1, null);
        ResolverResult result = new ResolverResult(Constants.UI);
        result.view = superView;
        return result;
    }

    public void uiResolve(LLuaToken header, View superView, int index, HashMap<String, String> lastParamsMap) {
        this.change2Token(header);
        this.resetViewIndexID(index);
        this.lastParamsMap = lastParamsMap;
        if (superView == null) {
            throw new Error("superView can't be nil .... ");
        }
        View view = null;
        while (this.token != null) {
            if (this.isNewView()) {
                view = this.createNewView(superView, this.token, this.lastParamsMap);
                this.nextToken();
                continue;
            }
            if (this.token.token == 288) {
                this.token = this.resolveViewIDAndSubs(this.token, view);
                this.nextToken();
                continue;
            }
            if (this.token.token == 40 && this.token.params != null) {
                if (view == null) {
                    throw new Error("view is nil  pre token:" + this.token.pre);
                }
                this.handleViewAttribute(view, this.token.pre.value, this.token.params);
                this.token = this.token.next;
            }
            this.nextToken();
        }
    }

    protected View createNewView(View superView, LLuaToken token, HashMap<String, String> lastParametersMap) {
        View view;
        if (LLuaParserStack.getMainAdapter().containModule(ResolverName.MODULE, token.value)) {
            ResolverResult r = LLuaParserStack.getMainAdapter().getModule(ResolverName.MODULE, token.value);
            List<String> cParams = null;
            if (token.next.params != null && token.next.params.size() > 0) {
                cParams = TokenUtil.getTokenParams(token);
                if (lastParametersMap != null) {
                    ArrayList<String> replaces = new ArrayList<String>();
                    for (String value : cParams) {
                        if (value.indexOf(46) != -1) {
                            for (Map.Entry<String, String> entry : lastParametersMap.entrySet()) {
                                if (!value.startsWith(entry.getKey() + ".")) continue;
                                value = value.replaceFirst(entry.getKey(), entry.getValue());
                            }
                        } else {
                            for (Map.Entry<String, String> entry : lastParametersMap.entrySet()) {
                                if (!value.equals(entry.getKey())) continue;
                                value = value.replaceFirst(entry.getKey(), entry.getValue());
                            }
                        }
                        replaces.add(value);
                    }
                    cParams = replaces;
                }
            }
            UIModuleResolver moduleResolver = new UIModuleResolver();
            moduleResolver.resetViewIndexID(this.getIncrementViewIndexID());
            this.autoIncrementViewIndexID();
            if (superView != null) {
                this.multiModuleViewFromIndex = superView.subViews.size();
            }
            r = moduleResolver.resolve(r.tokenHeader, cParams, superView);
            view = r.view;
            this.isMultiModuleView = view.equals(superView);
            if (superView != null) {
                return view;
            }
        } else {
            view = View.view(this.generateViewName(superView.variableName), token.value);
            this.isMultiModuleView = false;
            this.multiModuleViewFromIndex = 0;
        }
        superView.subViews.add(view);
        view.superView = superView;
        return view;
    }

    protected boolean isViewID(LLuaToken token) {
        return token.value.equals(Constants.ID);
    }

    protected boolean isSubsView(LLuaToken token) {
        return token.value.equals(Constants.SUBVIEWS) || token.value.equals(Constants.SUBS);
    }

    protected LLuaToken resolveViewIDAndSubs(LLuaToken token, View view) {
        if (this.isViewID(token)) {
            token = token.next;
            if (token.params != null) {
                view.variableName = token.params.get((int)0).value;
                this.reduceViewIndexID();
            }
        } else if (this.isSubsView(token)) {
            token = token.next;
            if (token.params != null) {
                int index = 1;
                for (LLuaToken subToken : token.params) {
                    if (this.isMultiModuleView) {
                        for (int i = this.multiModuleViewFromIndex; i < view.subViews.size(); ++i) {
                            View subView = (View)view.subViews.get(i);
                            new UIResolver().uiResolve(subToken, subView, index++, this.lastParamsMap);
                        }
                        continue;
                    }
                    new UIResolver().uiResolve(subToken, view, index++, this.lastParamsMap);
                }
            }
        }
        return token;
    }

    protected void handleViewAttribute(View view, String attribute, List<LLuaToken> params) {
        if (this.isMultiModuleView) {
            for (int i = this.multiModuleViewFromIndex; i < view.subViews.size(); ++i) {
                View subView = (View)view.subViews.get(i);
                subView.handleAttribute(attribute, params);
            }
        } else {
            view.handleAttribute(attribute, params);
        }
    }
}

