/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.core.parser.resolver.ui;

import com.immomo.core.parser.LLuaParserStack;
import com.immomo.core.parser.resolver.base.ResolverName;
import com.immomo.core.parser.resolver.base.ResolverResult;
import com.immomo.core.parser.resolver.ui.ModuleToken;
import com.immomo.core.parser.resolver.ui.UIResolver;
import com.immomo.core.parser.token.LLuaToken;
import com.immomo.core.parser.view.View;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class UIModuleResolver
extends UIResolver {
    private boolean _deubgLog = false;
    private List<Integer> patternList = Arrays.asList(288, 40, 41, 123);
    private List<String> actual;
    private static int _moduleViewIndex = 1;

    @Override
    public void clear() {
        super.clear();
        _moduleViewIndex = 1;
    }

    @Override
    public ResolverName resolveName() {
        return ResolverName.MODULE;
    }

    @Override
    public boolean canResolve(LLuaToken header) {
        boolean r = this._validate(header);
        this._log("match UIModuleResolver " + (r ? " ok" : "failed"));
        return r;
    }

    @Override
    public ResolverResult resolve(LLuaToken header) {
        return this._realResolve(header, null, null);
    }

    public ResolverResult resolve(LLuaToken header, List<String> actualParameters) {
        return this.resolve(header, actualParameters, null);
    }

    public ResolverResult resolve(LLuaToken header, List<String> actualParameters, View superView) {
        return this._realResolve(header, actualParameters, superView);
    }

    private ResolverResult _realResolve(LLuaToken tk, List<String> actualParameters, View superView) {
        if (actualParameters == null) {
            actualParameters = new ArrayList<String>();
        }
        tk = tk.deepCopyIgnorePre();
        ModuleToken mt = this._dump(tk);
        if (mt.formalParameters.size() != actualParameters.size() || actualParameters.size() == 0 && !LLuaParserStack.getMainAdapter().getModules(ResolverName.MODULE).contain(tk.value)) {
            ResolverResult resolverResult = new ResolverResult(tk.value);
            resolverResult.tokenHeader = tk;
            return resolverResult;
        }
        HashMap<String, String> parametersMap = new HashMap<String, String>();
        for (int i = 0; i < mt.formalParameters.size(); ++i) {
            parametersMap.put(mt.formalParameters.get(i), actualParameters.get(i));
        }
        View mv = this.resovleView(mt, mt.viewTableToken, superView, parametersMap);
        ResolverResult r = new ResolverResult(tk.value);
        r.view = mv;
        if (superView != null) {
            r.view = superView;
        }
        return r;
    }

    public View resovleView(ModuleToken mt, LLuaToken tk, View superView, HashMap<String, String> parametersMap) {
        View view = null;
        while (tk != null) {
            if (this.isNewView(tk)) {
                if (superView != null) {
                    view = this.createNewView(superView, tk, parametersMap);
                } else {
                    String variableName = mt.moduleName + _moduleViewIndex;
                    ++_moduleViewIndex;
                    view = View.view(variableName, tk.value);
                }
            } else if (tk.token == 288) {
                if (this.isViewID(tk)) {
                    tk = super.resolveViewIDAndSubs(tk, view);
                    if (superView == null) {
                        this.autoIncrementViewIndexID();
                    }
                } else if (this.isSubsView(tk)) {
                    tk = tk.next;
                    if (tk.params != null) {
                        for (LLuaToken subToken : tk.params) {
                            if (this.isMultiModuleView) {
                                for (int i = this.multiModuleViewFromIndex; i < view.subViews.size(); ++i) {
                                    View subView = (View)view.subViews.get(i);
                                    this.resovleView(mt, subToken, subView, parametersMap);
                                }
                                continue;
                            }
                            this.resovleView(mt, subToken, view, parametersMap);
                        }
                    }
                }
            } else if (tk.token == 40 && tk.params != null && tk.pre != null) {
                this._replaceFormalPamaters(tk.params, parametersMap);
                if (view == null) {
                    throw new Error("view is nil  pre token:" + tk.pre);
                }
                this.handleViewAttribute(view, tk.pre.value, tk.params);
            }
            tk = tk.next;
        }
        return view;
    }

    private void _replaceFormalPamaters(List<LLuaToken> tokens, HashMap<String, String> parametersMap) {
        if (tokens == null) {
            return;
        }
        for (LLuaToken tk : tokens) {
            this._replaceFormalParameter(tk, parametersMap);
        }
    }

    private void _replaceFormalParameter(LLuaToken tk, HashMap<String, String> parametersMap) {
        if (tk == null) {
            return;
        }
        if (tk.token == 288 && parametersMap.keySet().contains(tk.value)) {
            tk.value = parametersMap.get(tk.value);
        } else if (tk.token == 40) {
            this._replaceFormalPamaters(tk.params, parametersMap);
        }
        this._replaceFormalParameter(tk.next, parametersMap);
    }

    private ModuleToken _dump(LLuaToken tk) {
        ModuleToken mt = new ModuleToken();
        for (Integer v : this.patternList) {
            if (tk.token != v) {
                this._log("_dump wrong at " + v);
                return null;
            }
            switch (v) {
                case 288: {
                    mt.moduleName = tk.value;
                    break;
                }
                case 40: {
                    mt.parameters = new ArrayList<LLuaToken>();
                    mt.formalParameters = new ArrayList<String>();
                    if (tk.params == null) break;
                    for (LLuaToken token : tk.params) {
                        mt.parameters.add(token);
                        if (token.value == null) continue;
                        mt.formalParameters.add(token.value);
                    }
                    break;
                }
                case 123: {
                    mt.viewTableToken = tk;
                }
            }
            tk = tk.next;
        }
        this._log("start log dump ...");
        this._log(mt.moduleName);
        this._log(mt.parameters);
        this._log(mt.viewTableToken);
        this._log("end log dump ... \n");
        return mt;
    }

    private boolean _validate(LLuaToken tk) {
        LLuaToken last;
        if (tk == null) {
            return false;
        }
        boolean m = this._match(tk, this.patternList);
        if (m && !(m = this._match(last = this._findLast(tk), 125))) {
            m = this._match(last, 286) && this._match(last.pre, 125);
        }
        return m;
    }

    private boolean _match(LLuaToken tk, List<Integer> list) {
        for (Integer n : list) {
            if (!this._match(tk, n)) {
                return false;
            }
            tk = tk.next;
        }
        return true;
    }

    private boolean _match(LLuaToken tk, Integer n) {
        if (tk == null) {
            return false;
        }
        boolean r = tk.token == n;
        this._log("match " + n + (r ? " ok" : " failed, is " + tk.token));
        return r;
    }

    private LLuaToken _findLast(LLuaToken tk) {
        if (tk == null) {
            return null;
        }
        LLuaToken last = tk;
        while (last.next != null) {
            last = last.next;
        }
        return last;
    }

    private void _log(Object log2) {
        if (this._deubgLog) {
            System.out.println(log2);
        }
    }

    private void _logTokens(LLuaToken t) {
        while (this._deubgLog && t != null) {
            if (t.token < 256) {
                System.out.println(Character.toString((char)t.token));
            } else {
                System.out.println(t.token);
                System.out.println(t.value);
            }
            if (t.params != null) {
                System.out.println(t.params);
            }
            t = t.next;
        }
    }
}

