/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.core.parser.resolver.base;

import com.immomo.core.parser.resolver.base.ResolverName;
import com.immomo.core.parser.resolver.base.ResolverResult;
import com.immomo.core.parser.token.LLuaToken;
import com.immomo.core.parser.util.Util;

public abstract class Resolver {
    protected LLuaToken token;
    private int viewIndexID = 1;

    public ResolverName resolveName() {
        throw new Error("must be override resolveName() method");
    }

    public boolean canResolve(LLuaToken header) {
        throw new Error("must be override canResolve() method");
    }

    public ResolverResult resolve(LLuaToken header) {
        throw new Error("must be override resolve() method");
    }

    public void clear() {
        this.token = null;
    }

    protected void nextToken() {
        this.token = this.token.next;
    }

    protected void change2Token(LLuaToken token) {
        this.token = token;
    }

    protected boolean isNewView() {
        return this.isNewView(this.token);
    }

    protected boolean isNewView(LLuaToken token) {
        return Util.isViewBegin(token);
    }

    protected String generateViewName(String superName) {
        return superName + "_" + String.valueOf(this.viewIndexID++);
    }

    protected void reduceViewIndexID() {
        --this.viewIndexID;
    }

    protected int autoIncrementViewIndexID() {
        ++this.viewIndexID;
        return this.viewIndexID;
    }

    protected int getIncrementViewIndexID() {
        return this.viewIndexID;
    }

    protected void resetViewIndexID() {
        this.viewIndexID = 1;
    }

    protected void resetViewIndexID(int index) {
        this.viewIndexID = index;
    }
}

